/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.impl.ImageFrame;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Pair;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Tuple;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.UrlUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import org.apache.commons.codec.binary.Base64;

public class ImageUtils {
    private static final BlockingQueue<Pair<String, Pair<InputType, Object>>> urlRequests = Queues.newLinkedBlockingQueue();
    private static final Map<String, Tuple<Pair<InputType, Object>, Pair<Integer, List<ImageFrame>>, List<class_2960>>> cachedImages = Maps.newHashMap();
    private static final Thread urlQueue = new Thread("Url Queue"){

        @Override
        public void run() {
            block12: while (true) {
                try {
                    while (!CraftPresence.closing) {
                        Pair<String, Pair<InputType, Object>> request = urlRequests.take();
                        boolean isGif = request.getFirst().endsWith(".gif");
                        Pair<Integer, List<ImageFrame>> bufferData = cachedImages.get(request.getFirst()).getSecond();
                        if (bufferData == null) continue;
                        try {
                            InputStream streamData;
                            Object originData = request.getSecond().getSecond();
                            switch (request.getSecond().getFirst()) {
                                case FileData: {
                                    streamData = Files.newInputStream(((File)originData).toPath(), new OpenOption[0]);
                                    break;
                                }
                                case FileStream: {
                                    streamData = Files.newInputStream(Paths.get(originData.toString(), new String[0]), new OpenOption[0]);
                                    break;
                                }
                                case ByteStream: {
                                    Tuple<Boolean, String, String> base64Data = StringUtils.isBase64(originData.toString());
                                    byte[] dataSet = base64Data.getFirst() != false ? ImageUtils.decodeBase64(base64Data.getThird(), "UTF-8", false, false) : (originData instanceof byte[] ? (byte[])originData : originData.toString().getBytes());
                                    streamData = dataSet != null ? new ByteArrayInputStream(dataSet) : null;
                                    isGif = base64Data.getSecond().contains("gif");
                                    break;
                                }
                                case Url: {
                                    streamData = UrlUtils.getURLStream(originData instanceof URL ? (URL)originData : new URL(originData.toString()));
                                    isGif = originData.toString().endsWith(".gif");
                                    break;
                                }
                                default: {
                                    streamData = null;
                                }
                            }
                            if (streamData == null) continue block12;
                            if (isGif) {
                                ImageFrame[] frames;
                                for (ImageFrame frame : frames = ImageFrame.readGif(streamData)) {
                                    try {
                                        bufferData.getSecond().add(frame);
                                    }
                                    catch (Exception ex) {
                                        if (!ModUtils.IS_VERBOSE) continue;
                                        ex.printStackTrace();
                                    }
                                }
                            } else {
                                bufferData.getSecond().add(new ImageFrame(class_1011.method_4309((InputStream)streamData)));
                            }
                            cachedImages.get(request.getFirst()).setSecond(bufferData);
                            cachedImages.get(request.getFirst()).setThird(new ArrayList(bufferData.getSecond().size()));
                            continue block12;
                        }
                        catch (Exception ex) {
                            if (!ModUtils.IS_VERBOSE) continue;
                            ex.printStackTrace();
                        }
                    }
                    break;
                }
                catch (Exception ex) {
                    if (!ModUtils.IS_VERBOSE) break;
                    ex.printStackTrace();
                    break;
                }
            }
        }
    };

    public static class_2960 getTextureFromUrl(String textureName, String url) {
        try {
            return ImageUtils.getTextureFromUrl(textureName, new URL(url));
        }
        catch (Exception ex) {
            if (ModUtils.IS_VERBOSE) {
                ex.printStackTrace();
            }
            return new class_2960("");
        }
    }

    public static class_2960 getTextureFromUrl(String textureName, URL url) {
        try {
            return ImageUtils.getTextureFromUrl(textureName, new Pair<InputType, Object>(InputType.Url, url));
        }
        catch (Exception ex) {
            if (ModUtils.IS_VERBOSE) {
                ex.printStackTrace();
            }
            return new class_2960("");
        }
    }

    public static class_2960 getTextureFromUrl(String textureName, File url) {
        try {
            return ImageUtils.getTextureFromUrl(textureName, new Pair<InputType, Object>(InputType.FileData, url));
        }
        catch (Exception ex) {
            if (ModUtils.IS_VERBOSE) {
                ex.printStackTrace();
            }
            return new class_2960("");
        }
    }

    public static class_2960 getTextureFromUrl(String textureName, Object url) {
        if (url instanceof File) {
            return ImageUtils.getTextureFromUrl(textureName, (File)url);
        }
        if (url instanceof URL) {
            return ImageUtils.getTextureFromUrl(textureName, (URL)url);
        }
        if (url.toString().toLowerCase().startsWith("http")) {
            return ImageUtils.getTextureFromUrl(textureName, url.toString());
        }
        return ImageUtils.getTextureFromUrl(textureName, new Pair<InputType, Object>(StringUtils.isBase64(url.toString()).getFirst() != false ? InputType.ByteStream : InputType.FileStream, url.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_2960 getTextureFromUrl(String textureName, Pair<InputType, Object> stream) {
        Map<String, Tuple<Pair<InputType, Object>, Pair<Integer, List<ImageFrame>>, List<class_2960>>> map = cachedImages;
        synchronized (map) {
            Pair<Integer, List<ImageFrame>> bufferData;
            block21: {
                if (!cachedImages.containsKey(textureName) || !cachedImages.get(textureName).getFirst().equals(stream)) {
                    cachedImages.put(textureName, new Tuple<Pair<InputType, Object>, Pair<Integer, ArrayList>, Object>(stream, new Pair<Integer, ArrayList>(0, Lists.newArrayList()), null));
                    try {
                        urlRequests.put(new Pair<String, Pair<InputType, Object>>(textureName, stream));
                    }
                    catch (Exception ex) {
                        if (!ModUtils.IS_VERBOSE) break block21;
                        ex.printStackTrace();
                    }
                }
            }
            if ((bufferData = cachedImages.get(textureName).getSecond()) == null || bufferData.getSecond() == null || bufferData.getSecond().isEmpty()) {
                return new class_2960("");
            }
            if (textureName != null) {
                boolean shouldRepeat = textureName.endsWith(".gif") || stream.getSecond().toString().contains("gif");
                boolean doesContinue = bufferData.getFirst() < bufferData.getSecond().size() - 1;
                List<class_2960> resources = cachedImages.get(textureName).getThird();
                if (bufferData.getFirst() < resources.size()) {
                    class_2960 texLocation = resources.get(bufferData.getFirst());
                    if (bufferData.getSecond().get(bufferData.getFirst()).shouldRenderNext()) {
                        if (doesContinue) {
                            bufferData.getSecond().get(bufferData.setFirst(bufferData.getFirst() + 1)).setRenderTime(System.currentTimeMillis());
                        } else if (shouldRepeat) {
                            bufferData.getSecond().get(bufferData.setFirst(0)).setRenderTime(System.currentTimeMillis());
                        }
                    }
                    return texLocation;
                }
                try {
                    class_1043 dynTexture = new class_1043(bufferData.getSecond().get(bufferData.getFirst()).getNativeImage());
                    class_2960 cachedTexture = CraftPresence.instance.method_1531().method_4617(textureName + (String)(textureName.endsWith(".gif") ? "_" + cachedImages.get(textureName).getSecond().getFirst() : ""), dynTexture);
                    if (bufferData.getSecond().get(bufferData.getFirst()).shouldRenderNext()) {
                        if (doesContinue) {
                            bufferData.getSecond().get(bufferData.setFirst(bufferData.getFirst() + 1)).setRenderTime(System.currentTimeMillis());
                        } else if (shouldRepeat) {
                            bufferData.setFirst(0);
                        }
                    }
                    if (!resources.contains(cachedTexture)) {
                        resources.add(cachedTexture);
                    }
                    return cachedTexture;
                }
                catch (Exception ex) {
                    if (ModUtils.IS_VERBOSE) {
                        ex.printStackTrace();
                    }
                    return new class_2960("");
                }
            }
            return new class_2960("");
        }
    }

    public static boolean isExternalImage(String input) {
        return !StringUtils.isNullOrEmpty(input) && (input.toLowerCase().startsWith("http") || StringUtils.isBase64(input).getFirst() != false || input.toLowerCase().startsWith("file://"));
    }

    public static byte[] decodeBase64(String input, String encoding, boolean useDecodingMethod, boolean repeatCycle) {
        try {
            return Base64.decodeBase64((String)(useDecodingMethod ? URLDecoder.decode(input, encoding) : input));
        }
        catch (Exception ex) {
            if (ModUtils.IS_VERBOSE) {
                ex.printStackTrace();
            }
            if (!repeatCycle) {
                return ImageUtils.decodeBase64(input, encoding, !useDecodingMethod, true);
            }
            return null;
        }
    }

    public static boolean isTextureNull(class_2960 location) {
        return location == null || StringUtils.isNullOrEmpty(location.method_12836()) || StringUtils.isNullOrEmpty(location.method_12832());
    }

    static {
        urlQueue.start();
    }

    public static enum InputType {
        FileData,
        FileStream,
        ByteStream,
        Url,
        Unknown;

    }
}

