/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils;

import com.google.common.collect.Lists;
import external.com.jagrosh.discordipc.entities.DiscordBuild;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.impl.discord.ArgumentType;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.curse.CurseUtils;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.mcupdater.MCUpdaterUtils;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.multimc.MultiMCUtils;
import fabric.com.gitlab.cdagaming.craftpresence.integrations.technic.TechnicUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import java.util.ArrayList;

public class CommandUtils {
    public static boolean isInMainMenu = false;
    public static boolean isLoadingGame = false;

    public static void reloadData(boolean forceUpdateRPC) {
        ModUtils.TRANSLATOR.onTick();
        CraftPresence.SYSTEM.onTick();
        CraftPresence.instance.execute(() -> CraftPresence.KEYBINDINGS.onTick());
        CraftPresence.GUIS.onTick();
        if (CraftPresence.SYSTEM.HAS_LOADED && CraftPresence.SYSTEM.HAS_GAME_LOADED) {
            CraftPresence.BIOMES.onTick();
            CraftPresence.DIMENSIONS.onTick();
            CraftPresence.TILE_ENTITIES.onTick();
            CraftPresence.ENTITIES.onTick();
            CraftPresence.SERVER.onTick();
            if (forceUpdateRPC) {
                ModUtils.TRANSLATOR.syncTranslations();
                if (CraftPresence.DIMENSIONS.isInUse) {
                    CraftPresence.DIMENSIONS.updateDimensionPresence();
                }
                if (CraftPresence.GUIS.isInUse) {
                    CraftPresence.GUIS.updateGUIPresence();
                }
                if (CraftPresence.TILE_ENTITIES.isInUse) {
                    CraftPresence.TILE_ENTITIES.updateEntityPresence();
                }
                if (CraftPresence.ENTITIES.isInUse) {
                    CraftPresence.ENTITIES.updateEntityPresence();
                }
                if (CraftPresence.SERVER.isInUse) {
                    CraftPresence.SERVER.updateServerPresence();
                }
                if (CraftPresence.BIOMES.isInUse) {
                    CraftPresence.BIOMES.updateBiomePresence();
                }
            }
        }
    }

    public static void rebootRPC(boolean flushOverride) {
        flushOverride = flushOverride || !CraftPresence.CLIENT.CLIENT_ID.equals(CraftPresence.CONFIG.clientId);
        CraftPresence.CLIENT.shutDown();
        if (flushOverride) {
            DiscordAssetUtils.emptyData();
            CraftPresence.CLIENT.CLIENT_ID = CraftPresence.CONFIG.clientId;
        } else {
            DiscordAssetUtils.clearClientData();
        }
        if (!CraftPresence.CLIENT.PREFERRED_CLIENT.equals((Object)DiscordBuild.from(CraftPresence.CONFIG.preferredClientLevel))) {
            CraftPresence.CLIENT.PREFERRED_CLIENT = DiscordBuild.from(CraftPresence.CONFIG.preferredClientLevel);
        }
        DiscordAssetUtils.loadAssets(CraftPresence.CONFIG.clientId, true);
        CraftPresence.CLIENT.init(CraftPresence.CONFIG.resetTimeOnInit);
    }

    public static void rebootRPC() {
        CommandUtils.rebootRPC(false);
    }

    public static void init() {
        if (CraftPresence.CONFIG.detectCurseManifest && !CraftPresence.packFound) {
            CurseUtils.loadManifest();
        }
        if (CraftPresence.CONFIG.detectMultiMCManifest && !CraftPresence.packFound) {
            MultiMCUtils.loadInstance();
        }
        if (CraftPresence.CONFIG.detectMCUpdaterInstance && !CraftPresence.packFound) {
            MCUpdaterUtils.loadInstance();
        }
        if (CraftPresence.CONFIG.detectTechnicPack && !CraftPresence.packFound) {
            TechnicUtils.loadPack();
        }
        DiscordAssetUtils.loadAssets(CraftPresence.CONFIG.clientId, true);
        CraftPresence.KEYBINDINGS.register();
    }

    public static void setLoadingPresence() {
        ArrayList loadingArgs = Lists.newArrayList();
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            StringUtils.addEntriesNotPresent(loadingArgs, CraftPresence.CLIENT.generalArgs);
        }
        CraftPresence.CLIENT.clearPartyData(true, false);
        CraftPresence.CLIENT.syncArgument("&MAINMENU&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.loadingMessage, loadingArgs), ArgumentType.Text);
        CraftPresence.CLIENT.syncArgument("&MAINMENU&", CraftPresence.CLIENT.imageOf("&MAINMENU&", false, CraftPresence.CONFIG.defaultIcon, ""), ArgumentType.Image);
        isLoadingGame = true;
    }

    public static void setMainMenuPresence() {
        ArrayList mainMenuArgs = Lists.newArrayList();
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            StringUtils.addEntriesNotPresent(mainMenuArgs, CraftPresence.CLIENT.generalArgs);
        }
        if (isLoadingGame) {
            CraftPresence.CLIENT.initArgument(ArgumentType.Text, "&MAINMENU&");
            CraftPresence.CLIENT.initArgument(ArgumentType.Image, "&MAINMENU&");
            isLoadingGame = false;
        }
        CraftPresence.CLIENT.syncArgument("&MAINMENU&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.mainMenuMessage, mainMenuArgs), ArgumentType.Text);
        CraftPresence.CLIENT.syncArgument("&MAINMENU&", CraftPresence.CLIENT.imageOf("&MAINMENU&", false, CraftPresence.CONFIG.defaultIcon, ""), ArgumentType.Image);
        isInMainMenu = true;
    }
}

