/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util.biome;

import grondag.canvas.terrain.region.input.InputRegion;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.pepperbell.continuity.client.util.biome.BiomeView;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_4538;
import net.minecraft.class_853;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class BiomeRetriever {
    private static final Provider PROVIDER = BiomeRetriever.createProvider();

    private static Provider createProvider() {
        ClassLoader classLoader = BiomeRetriever.class.getClassLoader();
        if (FabricLoader.getInstance().isModLoaded("sodium")) {
            try {
                Class<?> worldSliceClass = Class.forName("me.jellysquid.mods.sodium.client.world.WorldSlice", false, classLoader);
                worldSliceClass.getMethod("getBiomeAccess", new Class[0]);
                return BiomeRetriever::getBiomeByWorldSlice;
            }
            catch (ClassNotFoundException | NoSuchMethodException worldSliceClass) {
                return BiomeRetriever::getBiomeByWorldView;
            }
        }
        if (FabricLoader.getInstance().isModLoaded("canvas")) {
            try {
                Class<?> inputRegionClass = Class.forName("grondag.canvas.terrain.region.input.InputRegion", false, classLoader);
                inputRegionClass.getMethod("getBiome", class_2338.class);
                return BiomeRetriever::getBiomeByInputRegion;
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                return BiomeRetriever::getBiomeByWorldView;
            }
        }
        if (ArrayUtils.contains((Object[])class_853.class.getInterfaces(), BiomeView.class)) {
            return BiomeRetriever::getBiomeByExtension;
        }
        return BiomeRetriever::getBiomeByWorldView;
    }

    @Nullable
    public static class_1959 getBiome(class_1920 blockView, class_2338 pos) {
        return PROVIDER.getBiome(blockView, pos);
    }

    @ApiStatus.Internal
    public static void init() {
    }

    private static class_1959 getBiomeByWorldView(class_1920 blockView, class_2338 pos) {
        if (blockView instanceof class_4538) {
            class_4538 worldView = (class_4538)blockView;
            return (class_1959)worldView.method_23753(pos).comp_349();
        }
        return null;
    }

    private static class_1959 getBiomeByExtension(class_1920 blockView, class_2338 pos) {
        if (blockView instanceof BiomeView) {
            BiomeView biomeView = (BiomeView)blockView;
            return (class_1959)biomeView.continuity$getBiome(pos).comp_349();
        }
        return BiomeRetriever.getBiomeByWorldView(blockView, pos);
    }

    private static class_1959 getBiomeByWorldSlice(class_1920 blockView, class_2338 pos) {
        if (blockView instanceof WorldSlice) {
            WorldSlice worldSlice = (WorldSlice)blockView;
            return (class_1959)worldSlice.getBiomeAccess().method_22393(pos).comp_349();
        }
        return BiomeRetriever.getBiomeByWorldView(blockView, pos);
    }

    private static class_1959 getBiomeByInputRegion(class_1920 blockView, class_2338 pos) {
        if (blockView instanceof InputRegion) {
            InputRegion inputRegion = (InputRegion)blockView;
            return inputRegion.getBiome(pos);
        }
        return BiomeRetriever.getBiomeByWorldView(blockView, pos);
    }

    private static interface Provider {
        public class_1959 getBiome(class_1920 var1, class_2338 var2);
    }
}

