/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util;

import io.vram.frex.api.material.RenderMaterial;
import io.vram.frex.fabric.compat.FabricQuadView;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import link.infra.indium.renderer.RenderMaterialImpl;
import me.pepperbell.continuity.client.ContinuityClient;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1059;
import net.minecraft.class_1092;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.jetbrains.annotations.ApiStatus;

public final class RenderUtil {
    private static final class_324 BLOCK_COLORS = class_310.method_1551().method_1505();
    private static final class_1092 MODEL_MANAGER = class_310.method_1551().method_1554();
    private static final ThreadLocal<MaterialFinder> MATERIAL_FINDER = ThreadLocal.withInitial(() -> RendererAccess.INSTANCE.getRenderer().materialFinder());
    private static final BlendModeGetter BLEND_MODE_GETTER = RenderUtil.createBlendModeGetter();
    private static SpriteFinder blockAtlasSpriteFinder;

    private static BlendModeGetter createBlendModeGetter() {
        if (FabricLoader.getInstance().isModLoaded("frex")) {
            try {
                Field frexQuadField = FabricQuadView.class.getDeclaredField("wrapped");
                frexQuadField.setAccessible(true);
                return quad -> {
                    try {
                        RenderMaterial frexMaterial = ((io.vram.frex.api.mesh.QuadView)frexQuadField.get(quad)).material();
                        return switch (frexMaterial.preset()) {
                            case 1 -> BlendMode.DEFAULT;
                            case 2 -> BlendMode.SOLID;
                            case 3 -> BlendMode.CUTOUT_MIPPED;
                            case 4 -> BlendMode.CUTOUT;
                            case 5 -> BlendMode.TRANSLUCENT;
                            case 0 -> {
                                if (frexMaterial.transparency() != 0) {
                                    yield BlendMode.TRANSLUCENT;
                                }
                                if (frexMaterial.cutout() == 0) {
                                    yield BlendMode.SOLID;
                                }
                                if (frexMaterial.unmipped()) {
                                    yield BlendMode.CUTOUT;
                                }
                                yield BlendMode.CUTOUT_MIPPED;
                            }
                            default -> BlendMode.DEFAULT;
                        };
                    }
                    catch (Exception exception) {
                        return BlendMode.DEFAULT;
                    }
                };
            }
            catch (Exception e) {
                ContinuityClient.LOGGER.error("Detected FREX but failed to load quad wrapper field", (Throwable)e);
            }
        } else {
            if (FabricLoader.getInstance().isModLoaded("indium")) {
                return quad -> ((RenderMaterialImpl)quad.material()).blendMode(0);
            }
            if (RendererAccess.INSTANCE.getRenderer() instanceof IndigoRenderer) {
                return quad -> ((net.fabricmc.fabric.impl.client.indigo.renderer.RenderMaterialImpl)quad.material()).blendMode(0);
            }
        }
        return quad -> BlendMode.DEFAULT;
    }

    public static int getTintColor(class_2680 state, class_1920 blockView, class_2338 pos, int tintIndex) {
        if (state == null || tintIndex == -1) {
            return -1;
        }
        return 0xFF000000 | BLOCK_COLORS.method_1697(state, blockView, pos, tintIndex);
    }

    public static MaterialFinder getMaterialFinder() {
        return MATERIAL_FINDER.get().clear();
    }

    public static BlendMode getBlendMode(QuadView quad) {
        return BLEND_MODE_GETTER.getBlendMode(quad);
    }

    public static SpriteFinder getSpriteFinder() {
        return blockAtlasSpriteFinder;
    }

    private static interface BlendModeGetter {
        public BlendMode getBlendMode(QuadView var1);
    }

    public static class ReloadListener
    implements SimpleSynchronousResourceReloadListener {
        public static final class_2960 ID = ContinuityClient.asId("render_util");
        public static final List<class_2960> DEPENDENCIES = List.of(ResourceReloadListenerKeys.MODELS);
        private static final ReloadListener INSTANCE = new ReloadListener();

        @ApiStatus.Internal
        public static void init() {
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)INSTANCE);
        }

        public void method_14491(class_3300 manager) {
            blockAtlasSpriteFinder = SpriteFinder.get((class_1059)MODEL_MANAGER.method_24153(class_1059.field_5275));
        }

        public class_2960 getFabricId() {
            return ID;
        }

        public Collection<class_2960> getFabricDependencies() {
            return DEPENDENCIES;
        }
    }
}

