/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import java.util.Locale;
import java.util.Properties;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;
import me.pepperbell.continuity.client.util.SpriteCalculator;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3300;

public class ConnectingCTMProperties
extends BaseCTMProperties {
    protected ConnectionPredicate connectionPredicate;

    public ConnectingCTMProperties(Properties properties, class_2960 id, class_3262 pack, int packPriority, class_3300 resourceManager, String method) {
        super(properties, id, pack, packPriority, resourceManager, method);
    }

    @Override
    public void init() {
        super.init();
        this.parseConnect();
        this.detectConnect();
        this.validateConnect();
    }

    protected void parseConnect() {
        String connectStr = this.properties.getProperty("connect");
        if (connectStr == null) {
            return;
        }
        try {
            this.connectionPredicate = ConnectionType.valueOf(connectStr.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void detectConnect() {
        if (this.connectionPredicate == null) {
            if (this.matchBlocksPredicate != null) {
                this.connectionPredicate = ConnectionType.BLOCK;
            } else if (this.matchTilesSet != null) {
                this.connectionPredicate = ConnectionType.TILE;
            }
        }
    }

    protected void validateConnect() {
        if (this.connectionPredicate == null) {
            ContinuityClient.LOGGER.error("No valid connection type provided in file '" + this.id + "' in pack '" + this.packName + "'");
            this.valid = false;
        }
    }

    public ConnectionPredicate getConnectionPredicate() {
        return this.connectionPredicate;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ConnectionType implements ConnectionPredicate
    {
        BLOCK{

            @Override
            public boolean shouldConnect(class_1920 blockView, class_2680 state, class_2338 pos, class_2680 toState, class_2350 face, class_1058 quadSprite) {
                return state.method_26204() == toState.method_26204();
            }
        }
        ,
        TILE{

            @Override
            public boolean shouldConnect(class_1920 blockView, class_2680 state, class_2338 pos, class_2680 toState, class_2350 face, class_1058 quadSprite) {
                if (state == toState) {
                    return true;
                }
                return quadSprite == SpriteCalculator.getSprite(toState, face);
            }
        }
        ,
        MATERIAL{

            @Override
            public boolean shouldConnect(class_1920 blockView, class_2680 state, class_2338 pos, class_2680 toState, class_2350 face, class_1058 quadSprite) {
                return state.method_26207() == toState.method_26207();
            }
        }
        ,
        STATE{

            @Override
            public boolean shouldConnect(class_1920 blockView, class_2680 state, class_2338 pos, class_2680 toState, class_2350 face, class_1058 quadSprite) {
                return state == toState;
            }
        };

    }
}

