/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.coloredglowlib.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.emafire003.dev.coloredglowlib.ColoredGlowLibMod;
import me.emafire003.dev.coloredglowlib.custom_data_animations.CustomColorAnimation;

public class ColorUtils {
    public static final String WHITE = "#ffffff";
    public static final String RED = "#ff0000";
    public static final String GREEN = "#00ff00";
    public static final String BLUE = "#0000ff";
    public static final String BLACK = "#000000";

    public static boolean isHexColor(String str) {
        if (!((String)str).startsWith("#")) {
            str = "#" + (String)str;
        }
        Pattern hexaPattern = Pattern.compile("^#([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$");
        Matcher matcher = hexaPattern.matcher((CharSequence)str);
        return matcher.matches();
    }

    public static int toColorValue(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static int toColorValue(String hex) {
        if (!ColorUtils.isHexColor((String)hex)) {
            return ColorUtils.toColorValue(0, 0, 0);
        }
        if (!((String)hex).startsWith("#")) {
            hex = "#" + (String)hex;
        }
        return Integer.decode((String)hex);
    }

    public static String toHex(int colorValue) {
        return "#" + Integer.toHexString(colorValue).substring(2);
    }

    public static String toHex(int r, int g, int b) {
        return "#" + Integer.toHexString(ColorUtils.toColorValue(r, g, b)).substring(2);
    }

    public static boolean checkDefault(String color) {
        return color.equalsIgnoreCase(WHITE) || color.equalsIgnoreCase("ffffff");
    }

    public static boolean checkSameColor(String color, String color1) {
        if (!((String)color).startsWith("#")) {
            color = "#" + (String)color;
        }
        if (!((String)color1).startsWith("#")) {
            color1 = "#" + (String)color1;
        }
        return ((String)color).equalsIgnoreCase((String)color1);
    }

    public static int[] toRGB(String color) {
        if (ColorUtils.isHexColor(color)) {
            if (color.startsWith("#")) {
                color = color.replaceAll("#", "");
            }
            int r = Integer.valueOf(color.substring(0, 2), 16);
            int g = Integer.valueOf(color.substring(2, 4), 16);
            int b = Integer.valueOf(color.substring(4, 6), 16);
            return new int[]{r, g, b};
        }
        return new int[]{-1, -1, -1};
    }

    public static boolean isValidColor(String color) {
        if (color.startsWith("#")) {
            color = color.replaceAll("#", "");
        }
        return ColorUtils.isHexColor(color) || color.equalsIgnoreCase("rainbow") || color.equalsIgnoreCase("random");
    }

    public static boolean isValidColorOrCustom(String color) {
        if (color.startsWith("#")) {
            color = color.replaceAll("#", "");
        }
        return ColorUtils.isValidColor(color) || ColorUtils.isCustomAnimation(color);
    }

    public static boolean isCustomAnimation(String color) {
        for (CustomColorAnimation animation : ColoredGlowLibMod.getCustomColorAnimations()) {
            if (!color.equalsIgnoreCase(animation.getName())) continue;
            return true;
        }
        return false;
    }

    public static class RainbowChanger {
        int r = 0;
        int g = 0;
        int b = 0;

        public RainbowChanger(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public int getColorValue() {
            return ColorUtils.toColorValue(this.r, this.g, this.b);
        }

        public void setRainbowColor(int factor) {
            int re = this.r;
            int gr = this.g;
            int bl = this.b;
            if (re == 255 && gr == 0 && bl != 255) {
                this.b = bl + factor;
                if (this.b > 255) {
                    this.b = 255;
                }
                return;
            }
            if (bl == 255 && gr == 0 && re != 0) {
                this.r -= factor;
                if (this.r < 0) {
                    this.r = 0;
                }
                return;
            }
            if (bl == 255 && re == 0 && gr != 255) {
                this.g = gr + factor;
                if (this.g > 255) {
                    this.g = 255;
                }
                return;
            }
            if (re == 0 && gr == 255 && bl != 0) {
                this.b -= factor;
                if (this.b < 0) {
                    this.b = 0;
                }
                return;
            }
            if (gr == 255 && bl == 0 && re != 255) {
                this.r = re + factor;
                if (this.r > 255) {
                    this.r = 255;
                }
                return;
            }
            if (re == 255 && bl == 0 && gr != 0) {
                this.g -= factor;
                if (this.g < 0) {
                    this.g = 0;
                }
                return;
            }
        }
    }
}

