/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.coloredglowlib.mixin;

import java.util.UUID;
import me.emafire003.dev.coloredglowlib.ColoredGlowLibMod;
import me.emafire003.dev.coloredglowlib.ColoredGlowLibModClient;
import me.emafire003.dev.coloredglowlib.custom_data_animations.CustomColorAnimation;
import me.emafire003.dev.coloredglowlib.util.ColorUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1297.class})
public abstract class EntityColorMixin {
    @Shadow
    @Final
    private class_1299<?> field_5961;
    @Unique
    private ColorUtils.RainbowChanger rainbowColor = new ColorUtils.RainbowChanger(255, 0, 0);
    @Unique
    int random_delay_counter = 0;
    @Unique
    int prev_random_color = ColorUtils.toColorValue("#ffffff");

    @Shadow
    public abstract UUID method_5667();

    @Unique
    public int handleCustomColor(String color) {
        if (color.startsWith("#")) {
            color = color.replaceAll("#", "");
        }
        for (CustomColorAnimation customColorAnimation : ColoredGlowLibMod.getCustomColorAnimations()) {
            if (!color.equalsIgnoreCase(customColorAnimation.getName())) continue;
            int color_index = customColorAnimation.getCurrentColorIndex();
            int current_ticks = customColorAnimation.getCurrentTicks();
            if (current_ticks > customColorAnimation.getColorAnimations().get(color_index).getActiveFor()) {
                ++color_index;
                current_ticks = 0;
            }
            if (color_index > customColorAnimation.getColorAnimations().size() - 1) {
                color_index = 0;
            }
            customColorAnimation.setCurrentColorIndex(color_index);
            customColorAnimation.setCurrentTicks(++current_ticks);
            String custom_color = customColorAnimation.getColorAnimations().get(color_index).getColor();
            if (custom_color.equalsIgnoreCase("rainbow")) {
                return this.getRainbowColor();
            }
            if (custom_color.equalsIgnoreCase("random")) {
                return this.randomColor();
            }
            if (!custom_color.equalsIgnoreCase(customColorAnimation.getName()) && ColorUtils.isCustomAnimation(custom_color)) {
                return this.handleCustomColor(custom_color);
            }
            return ColorUtils.toColorValue(custom_color);
        }
        return -1;
    }

    @Unique
    private int getRainbowColor() {
        if (this.rainbowColor == null) {
            ColoredGlowLibMod.LOGGER.warn("rainbowColor was null, reinitialising");
            this.rainbowColor = new ColorUtils.RainbowChanger(255, 0, 0);
        }
        this.rainbowColor.setRainbowColor(10);
        return this.rainbowColor.getColorValue();
    }

    @Unique
    private int randomColor() {
        class_1297 entity = (class_1297)this;
        class_5819 r = entity.method_37908().method_8409();
        if (this.random_delay_counter == 10) {
            this.random_delay_counter = 0;
            this.prev_random_color = ColorUtils.toColorValue(r.method_39332(0, 255), r.method_39332(0, 255), r.method_39332(0, 255));
        } else {
            ++this.random_delay_counter;
        }
        return this.prev_random_color;
    }

    @Inject(method={"getTeamColorValue"}, at={@At(value="RETURN")}, cancellable=true)
    public void injectChangeColorValue(CallbackInfoReturnable<Integer> cir) {
        String entityColor;
        if (this.field_5961 != class_1299.field_6097) {
            return;
        }
        @NotNull String uuid = this.method_5667().toString();
        switch (entityColor = ColoredGlowLibModClient.getEntityUuidColor().getOrDefault(uuid, "null")) {
            case "null": {
                return;
            }
            case "#rainbow": {
                cir.setReturnValue((Object)this.getRainbowColor());
                return;
            }
            case "#random": {
                cir.setReturnValue((Object)this.randomColor());
                return;
            }
        }
        int custom = this.handleCustomColor(entityColor);
        if (custom != -1) {
            cir.setReturnValue((Object)custom);
            return;
        }
        cir.setReturnValue((Object)ColorUtils.toColorValue(entityColor));
    }
}

