/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.coloredglowlib.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Optional;
import me.emafire003.dev.coloredglowlib.ColoredGlowLibMod;
import me.emafire003.dev.coloredglowlib.command.CGLCommand;
import me.emafire003.dev.coloredglowlib.compat.permissions.PermissionsChecker;
import me.emafire003.dev.coloredglowlib.component.GlobalColorComponent;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2183;
import net.minecraft.class_2186;
import net.minecraft.class_2321;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class ClearGlowColorCommand
implements CGLCommand {
    private int resetDefaultColor(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (ColoredGlowLibMod.getAPI() == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)(ColoredGlowLibMod.PREFIX + "\u00a7cAn error has occurred. The API hasn't yet been initialised!")));
            return 0;
        }
        ColoredGlowLibMod.getAPI().clearGlobalColor();
        source.method_9226((class_2561)class_2561.method_43470((String)(ColoredGlowLibMod.PREFIX + "\u00a77Resetted the default color to white!")), false);
        return 1;
    }

    private int clearEntityColor(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean useDefault;
        Collection targets = class_2186.method_9317(context, (String)"targets");
        class_2168 source = (class_2168)context.getSource();
        try {
            useDefault = BoolArgumentType.getBool(context, (String)"useDefaultColor");
        }
        catch (Exception e) {
            useDefault = false;
        }
        for (class_1297 entity : targets) {
            if (ColoredGlowLibMod.getAPI() != null) {
                ColoredGlowLibMod.getAPI().clearColor(entity, useDefault);
                continue;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)(ColoredGlowLibMod.PREFIX + "\u00a7cAn error has occurred. The API hasn't yet been initialised!")));
            return 1;
        }
        source.method_9226((class_2561)class_2561.method_43470((String)(ColoredGlowLibMod.PREFIX + "\u00a77Cleared the color from the selected entity/entities!")), true);
        return targets.size();
    }

    private int clearEntityColorFor(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean useDefault;
        Collection targets = class_2186.method_9317(context, (String)"targets");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = class_2186.method_9315(context, (String)"visibleToPlayer");
        try {
            useDefault = BoolArgumentType.getBool(context, (String)"useDefaultColor");
        }
        catch (Exception e) {
            useDefault = false;
        }
        for (class_1297 entity : targets) {
            if (ColoredGlowLibMod.getAPI() != null) {
                ColoredGlowLibMod.getAPI().clearExclusiveColorFor(entity, (class_1657)player, useDefault);
                continue;
            }
            source.method_9213((class_2561)class_2561.method_43470((String)(ColoredGlowLibMod.PREFIX + "\u00a7cAn error has occurred. The API hasn't yet been initialised!")));
            return 1;
        }
        source.method_9226((class_2561)class_2561.method_43470((String)(ColoredGlowLibMod.PREFIX + "\u00a77Cleared the color visible only to " + player.method_5477().getString() + "from the selected entity/entities!")), true);
        return targets.size();
    }

    private int clearEntityTypeColor(CommandContext<class_2168> context) throws CommandSyntaxException {
        boolean useDefault;
        Optional type = class_1299.method_5898((String)class_2183.method_9294(context, (String)"entity").toString());
        class_2168 source = (class_2168)context.getSource();
        if (type.isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"The EntityType you have specified does not exist!"));
            return 0;
        }
        try {
            useDefault = BoolArgumentType.getBool(context, (String)"useDefaultColor");
        }
        catch (Exception e) {
            useDefault = false;
        }
        if (ColoredGlowLibMod.getAPI() == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)(ColoredGlowLibMod.PREFIX + "\u00a7cAn error has occurred. The API hasn't yet been initialised!")));
            return 0;
        }
        ColoredGlowLibMod.getAPI().clearColor((class_1299)type.get(), useDefault);
        source.method_9226((class_2561)class_2561.method_43470((String)(ColoredGlowLibMod.PREFIX + "\u00a77Cleared color from the selected entity/entities!")), false);
        return 1;
    }

    private int resetSettings(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (ColoredGlowLibMod.getAPI() == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)(ColoredGlowLibMod.PREFIX + "\u00a7cAn error has occurred. The API hasn't yet been initialised!")));
            return 0;
        }
        ColoredGlowLibMod.getAPI().setEntityTypeColorOverridesEntityColor(false);
        ColoredGlowLibMod.getAPI().setDefaultOverridesAll(false);
        ColoredGlowLibMod.getAPI().setOverrideTeamColors(false);
        source.method_9226((class_2561)class_2561.method_43470((String)(ColoredGlowLibMod.PREFIX + "\u00a77All settings have been reset to default values!")), false);
        return 1;
    }

    private int resetAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        GlobalColorComponent globalColorComponent = (GlobalColorComponent)GlobalColorComponent.GLOBAL_COLOR_COMPONENT.get((Object)source.method_9211().method_3845());
        globalColorComponent.clear();
        source.method_9226((class_2561)class_2561.method_43470((String)(ColoredGlowLibMod.PREFIX + "\u00a77All settings and entitytype/default/global colors have been reset to default values!")), false);
        source.method_9226((class_2561)class_2561.method_43470((String)(ColoredGlowLibMod.PREFIX + "\u00a77If you want to clear entity-specifc colors as well use /cgl clear @e!")), false);
        return 1;
    }

    @Override
    public LiteralCommandNode<class_2168> getNode(class_7157 registryAccess) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(PermissionsChecker.hasPerms("coloredglowlib.commands.clearcolor", 2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(this::clearEntityColor)).then(class_2170.method_9244((String)"useDefaultColor", (ArgumentType)BoolArgumentType.bool()).executes(this::clearEntityColor)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).executes(this::clearEntityColor)).then(class_2170.method_9244((String)"visibleToPlayer", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"useDefaultColor", (ArgumentType)BoolArgumentType.bool()).executes(this::clearEntityColorFor))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_2183.method_9295()).suggests(class_2321.field_10935).executes(this::clearEntityTypeColor)).then(class_2170.method_9244((String)"useDefaultColor", (ArgumentType)BoolArgumentType.bool()).executes(this::clearEntityTypeColor)))).then(class_2170.method_9247((String)"default").executes(this::resetDefaultColor))).then(class_2170.method_9247((String)"settings").executes(this::resetSettings))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").requires(PermissionsChecker.hasPerms("coloredglowlib.commands.clearcolor.all", 2))).then(class_2170.method_9247((String)"confirm").executes(this::resetAll)))).build();
    }
}

