/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.coloredglowlib;

import com.mojang.text2speech.Narrator;
import com.zeydie.sgson.SGsonBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import lombok.Generated;
import me.emafire003.dev.coloredglowlib.ColoredGlowLibMod;
import me.emafire003.dev.coloredglowlib.custom_data_animations.CustomColorAnimation;
import me.emafire003.dev.coloredglowlib.networking.ColorAnimationPacketS2C;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColoredGlowLibModClient
implements ClientModInitializer {
    private static final List<CustomColorAnimation> animations = new ArrayList<CustomColorAnimation>();
    @NotNull
    private static final Map<String, String> entityUuidColor = new HashMap<String, String>();
    @NotNull
    private static final Map<String, Float> entityAlpha = new HashMap<String, Float>();

    public void onInitializeClient() {
        this.registerColorAnimationPacket();
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            ColoredGlowLibMod.LOGGER.info("Unregistering the color animations received from the server...");
            animations.forEach(animation -> ColoredGlowLibMod.getCustomColorAnimations().remove(animation));
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            entityUuidColor.clear();
            entityAlpha.clear();
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)class_2960.method_43902((String)"votivemods", (String)"translucent"), (client, handler, buf, responseSender) -> {
            @NotNull String json = new String(buf.method_36132());
            System.out.println("json " + json);
            @NotNull HashMap entities = (HashMap)SGsonBase.create().fromJsonToObject(json, new HashMap());
            @Nullable class_638 world = class_310.method_1551().field_1687;
            if (world == null) {
                entityAlpha.clear();
                return;
            }
            @Nullable class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            System.out.println("translucent " + String.valueOf(entities));
            entities.forEach((s, s2) -> {
                if (s2 >= 1.0) {
                    entityAlpha.remove(s);
                } else if (entityAlpha.containsKey(s)) {
                    entityAlpha.replace((String)s, Float.valueOf(s2.floatValue()));
                } else {
                    entityAlpha.put((String)s, Float.valueOf(s2.floatValue()));
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)class_2960.method_43902((String)"votivemods", (String)"coloredglowlib"), (client, handler, buf, responseSender) -> {
            @NotNull String json = new String(buf.method_36132());
            System.out.println("json " + json);
            @NotNull HashMap entities = (HashMap)SGsonBase.create().fromJsonToObject(json, new HashMap());
            @Nullable class_638 world = class_310.method_1551().field_1687;
            if (world == null) {
                entityUuidColor.clear();
                return;
            }
            @Nullable class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            System.out.println("entities " + String.valueOf(entities));
            entities.forEach((s, s2) -> {
                if (s2.equalsIgnoreCase("null")) {
                    entityUuidColor.remove(s);
                } else if (entityUuidColor.containsKey(s)) {
                    entityUuidColor.replace((String)s, (String)s2);
                } else {
                    entityUuidColor.put((String)s, (String)s2);
                }
            });
        });
    }

    private void registerColorAnimationPacket() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ColorAnimationPacketS2C.ID, (client, handler, buf, responseSender) -> {
            CustomColorAnimation animation = ColorAnimationPacketS2C.read(buf);
            client.execute(() -> {
                try {
                    if (!ColoredGlowLibMod.getCustomColorAnimations().contains(animation)) {
                        ColoredGlowLibMod.loadCustomColorAnimation(animation);
                        animations.add(animation);
                    }
                }
                catch (NoSuchElementException e) {
                    Narrator.LOGGER.warn("No value in the packet, probably not a big problem");
                }
                catch (Exception e) {
                    Narrator.LOGGER.error("There was an error while getting the packet!");
                    e.printStackTrace();
                }
            });
        });
    }

    @NotNull
    @Generated
    public static Map<String, String> getEntityUuidColor() {
        return entityUuidColor;
    }

    @NotNull
    @Generated
    public static Map<String, Float> getEntityAlpha() {
        return entityAlpha;
    }
}

