/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public abstract class DynamicSmoothScrollingEntryListWidget<E extends DynamicEntryListWidget.Entry<E>>
extends DynamicEntryListWidget<E> {
    protected boolean smoothScrolling = true;
    protected final NumberAnimator<Double> scrollAnimator = ValueAnimator.ofDouble();

    public DynamicSmoothScrollingEntryListWidget(class_310 client, int width, int height, int top, int bottom, class_2960 backgroundLocation) {
        super(client, width, height, top, bottom, backgroundLocation);
    }

    public boolean isSmoothScrolling() {
        return this.smoothScrolling;
    }

    public void setSmoothScrolling(boolean smoothScrolling) {
        this.smoothScrolling = smoothScrolling;
    }

    @Override
    public void capYPosition(double scroll) {
        if (!this.smoothScrolling) {
            this.scrollAnimator.setAs(class_3532.method_15350((double)scroll, (double)0.0, (double)this.getMaxScroll()));
        } else {
            this.scrollAnimator.setAs(ScrollingContainer.clampExtension(scroll, this.getMaxScroll()));
        }
        this.scroll = (Double)this.scrollAnimator.value();
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.smoothScrolling) {
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.getFocused() != null && this.method_25397() && button == 0 && this.getFocused().method_25403(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        if (button == 0 && this.scrolling) {
            if (mouseY < (double)this.top) {
                this.capYPosition(0.0);
            } else if (mouseY > (double)this.bottom) {
                this.capYPosition(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = class_3532.method_15340((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                this.capYPosition(class_3532.method_15350((double)(this.getScroll() + deltaY * double_6), (double)0.0, (double)this.getMaxScroll()));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double amount) {
        for (DynamicEntryListWidget.Entry entry : this.method_25396()) {
            if (!entry.method_25401(mouseX, mouseY, amount)) continue;
            return true;
        }
        if (!this.smoothScrolling) {
            this.scroll += 16.0 * -amount;
            this.scroll = class_3532.method_15350((double)amount, (double)0.0, (double)this.getMaxScroll());
            return true;
        }
        this.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
        return true;
    }

    public void offset(double value, boolean animated) {
        this.scrollTo((Double)this.scrollAnimator.target() + value, animated);
    }

    public void scrollTo(double value, boolean animated) {
        this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
    }

    public void scrollTo(double value, boolean animated, long duration) {
        if (animated) {
            this.scrollAnimator.setTo(value, duration);
        } else {
            this.scrollAnimator.setAs(value);
        }
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.scrollAnimator.setTarget(ScrollingContainer.handleBounceBack((Double)this.scrollAnimator.target(), this.getMaxScroll(), delta));
        this.scrollAnimator.update(delta);
        this.scroll = (Double)this.scrollAnimator.value();
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    @Override
    protected void renderScrollBar(class_4587 matrices, class_289 tessellator, class_287 buffer, int maxScroll, int scrollbarPositionMinX, int scrollbarPositionMaxX) {
        if (!this.smoothScrolling) {
            super.renderScrollBar(matrices, tessellator, buffer, maxScroll, scrollbarPositionMinX, scrollbarPositionMaxX);
        } else if (maxScroll > 0) {
            int height = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            height = class_3532.method_15340((int)height, (int)32, (int)(this.bottom - this.top - 8));
            height = (int)((double)height - Math.min((double)(this.scroll < 0.0 ? (int)(-this.scroll) : (this.scroll > (double)this.getMaxScroll() ? (int)this.scroll - this.getMaxScroll() : 0)), (double)height * 0.95));
            height = Math.max(10, height);
            int minY = Math.min(Math.max((int)this.getScroll() * (this.bottom - this.top - height) / maxScroll + this.top, this.top), this.bottom - height);
            int bottomc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 168 : 128;
            int topc = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse()) ? 222 : 172;
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.disableTexture();
            Matrix4f matrix = matrices.method_23760().method_23761();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            buffer.method_22918(matrix, (float)scrollbarPositionMinX, (float)this.bottom, 0.0f).method_1336(0, 0, 0, 255).method_1344();
            buffer.method_22918(matrix, (float)scrollbarPositionMaxX, (float)this.bottom, 0.0f).method_1336(0, 0, 0, 255).method_1344();
            buffer.method_22918(matrix, (float)scrollbarPositionMaxX, (float)this.top, 0.0f).method_1336(0, 0, 0, 255).method_1344();
            buffer.method_22918(matrix, (float)scrollbarPositionMinX, (float)this.top, 0.0f).method_1336(0, 0, 0, 255).method_1344();
            buffer.method_22918(matrix, (float)scrollbarPositionMinX, (float)(minY + height), 0.0f).method_1336(bottomc, bottomc, bottomc, 255).method_1344();
            buffer.method_22918(matrix, (float)scrollbarPositionMaxX, (float)(minY + height), 0.0f).method_1336(bottomc, bottomc, bottomc, 255).method_1344();
            buffer.method_22918(matrix, (float)scrollbarPositionMaxX, (float)minY, 0.0f).method_1336(bottomc, bottomc, bottomc, 255).method_1344();
            buffer.method_22918(matrix, (float)scrollbarPositionMinX, (float)minY, 0.0f).method_1336(bottomc, bottomc, bottomc, 255).method_1344();
            buffer.method_22918(matrix, (float)scrollbarPositionMinX, (float)(minY + height - 1), 0.0f).method_1336(topc, topc, topc, 255).method_1344();
            buffer.method_22918(matrix, (float)(scrollbarPositionMaxX - 1), (float)(minY + height - 1), 0.0f).method_1336(topc, topc, topc, 255).method_1344();
            buffer.method_22918(matrix, (float)(scrollbarPositionMaxX - 1), (float)minY, 0.0f).method_1336(topc, topc, topc, 255).method_1344();
            buffer.method_22918(matrix, (float)scrollbarPositionMinX, (float)minY, 0.0f).method_1336(topc, topc, topc, 255).method_1344();
            tessellator.method_1350();
            RenderSystem.disableBlend();
            RenderSystem.enableTexture();
        }
    }

    public static class Precision {
        public static final float FLOAT_EPSILON = 0.001f;
        public static final double DOUBLE_EPSILON = 1.0E-7;

        public static boolean almostEquals(float value1, float value2, float acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }

        public static boolean almostEquals(double value1, double value2, double acceptableDifference) {
            return Math.abs(value1 - value2) <= acceptableDifference;
        }
    }

    public static class Interpolation {
        public static double expoEase(double start, double end, double amount) {
            return start + (end - start) * ClothConfigInitializer.getEasingMethod().apply(amount);
        }
    }
}

