/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.mixin.iris;

import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.FadeTypes;
import com.koteinik.chunksfadein.core.ShaderInjector;
import net.coderbot.iris.compat.sodium.impl.shader_overrides.IrisChunkProgramOverrides;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Pseudo
@Mixin(value={IrisChunkProgramOverrides.class})
public class IrisChunkProgramOverridesMixin {
    private static final ShaderInjector vertexInjectorFull = new ShaderInjector();
    private static final ShaderInjector fragmentInjectorFull = new ShaderInjector();
    private static final ShaderInjector vertexInjectorLined = new ShaderInjector();
    private static final ShaderInjector fragmentInjectorLined = new ShaderInjector();

    @ModifyVariable(method={"createVertexShader"}, at=@At(value="STORE", ordinal=0), remap=false)
    private String modifyCreateVertexShader(String irisVertexShader) {
        if (irisVertexShader == null) {
            return null;
        }
        if (!Config.isModEnabled) {
            return irisVertexShader;
        }
        String code = (Config.fadeType == FadeTypes.FULL ? vertexInjectorFull : vertexInjectorLined).get(irisVertexShader);
        return code;
    }

    @ModifyVariable(method={"createFragmentShader"}, at=@At(value="STORE", ordinal=0), remap=false)
    private String modifyCreateFragmentShader(String irisFragmentShader) {
        if (irisFragmentShader == null) {
            return null;
        }
        if (!Config.isModEnabled) {
            return irisFragmentShader;
        }
        String code = (Config.fadeType == FadeTypes.FULL ? fragmentInjectorFull : fragmentInjectorLined).get(irisFragmentShader);
        return code;
    }

    static {
        boolean isIrisV12 = false;
        try {
            isIrisV12 = ((ModContainer)FabricLoader.getInstance().getModContainer("iris").get()).getMetadata().getVersion().compareTo((Object)Version.parse((String)"1.4")) < 0;
        }
        catch (VersionParsingException versionParsingException) {
            // empty catch block
        }
        vertexInjectorFull.insertAfterDefines("out float fadeCoeff;", "struct ChunkFadeData {", "    vec4 fadeData;", "};", "layout(std140) uniform ubo_ChunkFadeDatas {", "    ChunkFadeData Chunk_FadeDatas[256];", "};");
        vertexInjectorFull.appendToFunction("void _vert_init()", "fadeCoeff = Chunk_FadeDatas[_draw_id].fadeData.w;", "_vert_position = _vert_position + Chunk_FadeDatas[_draw_id].fadeData.xyz;");
        vertexInjectorLined.copyFrom(vertexInjectorFull);
        vertexInjectorLined.insertAfterDefines("out float localHeight;");
        vertexInjectorLined.appendToFunction("void _vert_init()", "localHeight = _vert_position.y;");
        fragmentInjectorFull.insertAfterDefines("in float fadeCoeff;");
        fragmentInjectorLined.copyFrom(fragmentInjectorFull);
        fragmentInjectorLined.insertAfterDefines("in float localHeight;");
        fragmentInjectorLined.appendToFunction("void main()", "float fadeLineY = fadeCoeff * 16.0;");
        if (isIrisV12) {
            fragmentInjectorFull.appendToFunction("void main()", "if(fadeCoeff != 0.0) iris_FragData[0] = mix(iris_FragData[0], iris_FogColor, 1.0 - fadeCoeff);");
            fragmentInjectorLined.appendToFunction("void main()", "if(fadeCoeff != 0.0) iris_FragData[0] = mix(iris_FragData[0], iris_FogColor, localHeight <= fadeLineY ? 0.0 : 1.0);");
        } else {
            fragmentInjectorFull.appendToFunction("void main()", "if(fadeCoeff != 0.0) ${uniform_0} = ${uniform_0_prefix}mix(${uniform_0}, iris_FogColor, 1.0 - fadeCoeff)${uniform_0_postfix};");
            fragmentInjectorLined.appendToFunction("void main()", "if(fadeCoeff != 0.0) ${uniform_0} = ${uniform_0_prefix}mix(${uniform_0}, iris_FogColor, localHeight <= fadeLineY ? 0.0 : 1.0)${uniform_0_postfix};");
        }
    }
}

