/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.mixin.chunk;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.ChunkFadeInController;
import com.koteinik.chunksfadein.extenstions.ChunkShaderInterfaceExt;
import com.koteinik.chunksfadein.extenstions.RenderRegionExt;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegion;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegionManager;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderRegion.class}, remap=false)
public class RenderRegionMixin
implements RenderRegionExt {
    @Shadow
    private final Set<RenderSection> chunks = new ObjectOpenHashSet();
    private ChunkFadeInController fadeController;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void modifyConstructor(RenderRegionManager manager, int x, int y, int z, CallbackInfo ci) {
        if (!Config.isModEnabled) {
            return;
        }
        this.fadeController = new ChunkFadeInController();
    }

    @Inject(method={"addChunk"}, at={@At(value="TAIL")})
    private void modifyAddChunk(RenderSection chunk, CallbackInfo ci) {
        if (!Config.isModEnabled) {
            return;
        }
        boolean completeAnimation = false;
        if (!Config.animateNearPlayer) {
            int camChunkZ;
            int camChunkY;
            int camChunkX;
            int chunkX = chunk.getChunkX();
            int chunkY = chunk.getChunkY();
            int chunkZ = chunk.getChunkZ();
            class_1297 camera = class_310.method_1551().field_1719;
            if (camera != null && MathUtils.chunkInRange(chunkX, chunkY, chunkZ, camChunkX = MathUtils.floor((float)(camera.field_6038 / 16.0)), camChunkY = MathUtils.floor((float)(camera.field_5971 / 16.0)), camChunkZ = MathUtils.floor((float)(camera.field_5989 / 16.0)), 1)) {
                completeAnimation = true;
            }
        }
        if (!completeAnimation) {
            this.fadeController.resetFadeForChunk(chunk.getChunkId());
        } else {
            this.fadeController.completeChunkFade(chunk.getChunkId(), false);
        }
    }

    @Inject(method={"deleteResources"}, at={@At(value="TAIL")})
    private void modifyDeleteResources(CommandList commandList, CallbackInfo ci) {
        if (!Config.isModEnabled) {
            return;
        }
        this.fadeController.delete(commandList);
    }

    @Override
    public void updateChunksFade(List<RenderSection> chunks, ChunkShaderInterfaceExt shader, CommandList commandList) {
        this.fadeController.updateChunksFade(chunks, shader, commandList);
    }

    @Override
    public float[] getChunkData(int x, int y, int z) {
        return this.fadeController.getChunkData(x, y, z);
    }

    @Override
    public void completeChunkFade(int x, int y, int z, boolean completeFade) {
        this.fadeController.completeChunkFade(x, y, z, completeFade);
    }
}

