/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.MathUtils;
import java.util.function.Function;

public enum Curves {
    LINEAR(f -> f),
    EASE_OUT(f -> Float.valueOf(1.0f - MathUtils.pow(1.0f - f.floatValue(), 3))),
    EASE_CIRCULAR(f -> {
        float f1 = 2.0f * f.floatValue();
        return Float.valueOf(f.floatValue() < 0.5f ? (1.0f - MathUtils.sqrt(1.0f - MathUtils.pow(f1, 2))) / 2.0f : (MathUtils.sqrt(1.0f - MathUtils.pow(-f1 + 2.0f, 2)) + 1.0f) / 2.0f);
    }),
    BOUNCE(f -> {
        if (f.floatValue() < 0.36363637f) {
            return Float.valueOf(7.5625f * f.floatValue() * f.floatValue());
        }
        if (f.floatValue() < 0.72727275f) {
            f = Float.valueOf(f.floatValue() - 0.54545456f);
            return Float.valueOf(7.5625f * f.floatValue() * f.floatValue() + 0.75f);
        }
        if ((double)f.floatValue() < 0.9090909090909091) {
            f = Float.valueOf(f.floatValue() - 0.8181818f);
            return Float.valueOf(7.5625f * f.floatValue() * f.floatValue() + 0.9375f);
        }
        f = Float.valueOf(f.floatValue() - 0.95454544f);
        return Float.valueOf(7.5625f * f.floatValue() * f.floatValue() + 0.984375f);
    });

    private final Function<Float, Float> calculate;

    private Curves(Function<Float, Float> calculate) {
        this.calculate = calculate;
    }

    public Float calculate(Float in) {
        return this.calculate.apply(in);
    }
}

