/*
 * Decompiled with CFR 0.152.
 */
package com.koteinik.chunksfadein.core;

import com.koteinik.chunksfadein.MathUtils;
import com.koteinik.chunksfadein.config.Config;
import com.koteinik.chunksfadein.core.DataBuffer;
import com.koteinik.chunksfadein.extenstions.ChunkShaderInterfaceExt;
import java.util.List;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;

public class ChunkFadeInController {
    private final float[] progressArr = new float[256];
    private final DataBuffer chunkFadeDatasBuffer = new DataBuffer(256, 4);
    private GlMutableBuffer chunkGlFadeDataBuffer;
    private long lastFrameTime = 0L;

    public ChunkFadeInController() {
        for (int i = 0; i < 256; ++i) {
            this.resetFadeForChunk(i);
        }
    }

    public float[] getChunkData(int x, int y, int z) {
        return this.getChunkData(MathUtils.chunkIdFromGlobal(x, y, z));
    }

    public float[] getChunkData(int chunkId) {
        float x = this.chunkFadeDatasBuffer.get(chunkId, 0);
        float y = this.chunkFadeDatasBuffer.get(chunkId, 1);
        float z = this.chunkFadeDatasBuffer.get(chunkId, 2);
        float w = this.chunkFadeDatasBuffer.get(chunkId, 3);
        return new float[]{x, y, z, w};
    }

    public void completeChunkFade(int x, int y, int z, boolean completeFade) {
        this.completeChunkFade(MathUtils.chunkIdFromGlobal(x, y, z), completeFade);
    }

    public void completeChunkFade(int chunkId, boolean completeFade) {
        this.chunkFadeDatasBuffer.put(chunkId, 0, 0.0f);
        this.chunkFadeDatasBuffer.put(chunkId, 1, 0.0f);
        this.chunkFadeDatasBuffer.put(chunkId, 2, 0.0f);
        if (completeFade) {
            this.chunkFadeDatasBuffer.put(chunkId, 3, 1.0f);
        }
        this.progressArr[chunkId] = 1.0f;
    }

    public void resetFadeForChunk(int x, int y, int z) {
        this.resetFadeForChunk(MathUtils.chunkIdFromGlobal(x, y, z));
    }

    public void resetFadeForChunk(int chunkId) {
        this.chunkFadeDatasBuffer.put(chunkId, 0, 0.0f);
        this.chunkFadeDatasBuffer.put(chunkId, 1, -Config.animationInitialOffset);
        this.chunkFadeDatasBuffer.put(chunkId, 2, 0.0f);
        this.chunkFadeDatasBuffer.put(chunkId, 3, Config.isFadeEnabled ? 0.0f : 1.0f);
        this.progressArr[chunkId] = 0.0f;
    }

    public void updateChunksFade(List<RenderSection> chunks, ChunkShaderInterfaceExt shader, CommandList commandList) {
        this.checkMutableBuffer(commandList);
        long currentFrameTime = System.nanoTime();
        long delta = this.lastFrameTime == 0L ? 0L : (currentFrameTime - this.lastFrameTime) / 1000000L;
        int chunksSize = chunks.size();
        for (int i = 0; i < chunksSize; ++i) {
            this.processChunk(delta, chunks.get(i));
        }
        this.chunkFadeDatasBuffer.uploadData(commandList, this.chunkGlFadeDataBuffer);
        shader.setFadeDatas(this.chunkGlFadeDataBuffer);
        this.lastFrameTime = currentFrameTime;
    }

    public void delete(CommandList commandList) {
        this.chunkFadeDatasBuffer.delete();
        if (this.chunkGlFadeDataBuffer != null) {
            commandList.deleteBuffer((GlBuffer)this.chunkGlFadeDataBuffer);
        }
    }

    private void checkMutableBuffer(CommandList commandList) {
        if (this.chunkGlFadeDataBuffer == null) {
            this.chunkGlFadeDataBuffer = commandList.createMutableBuffer();
        }
    }

    private void processChunk(long delta, RenderSection chunk) {
        int chunkId = chunk.getChunkId();
        if (Config.isFadeEnabled) {
            float fadeCoeffChange = Config.fadeChangePerMs * (float)delta;
            float fadeCoeff = this.chunkFadeDatasBuffer.get(chunkId, 3);
            if (fadeCoeff != 1.0f) {
                if ((fadeCoeff += fadeCoeffChange) > 1.0f) {
                    fadeCoeff = 1.0f;
                }
                this.chunkFadeDatasBuffer.put(chunkId, 3, fadeCoeff);
            }
        } else if (!Config.isFadeEnabled && this.chunkFadeDatasBuffer.get(chunkId, 3) != 1.0f) {
            this.chunkFadeDatasBuffer.put(chunkId, 3, 1.0f);
        }
        if (Config.isAnimationEnabled) {
            float y = this.chunkFadeDatasBuffer.get(chunkId, 1);
            if (y != 0.0f) {
                float animationProgress = this.progressArr[chunkId];
                if ((animationProgress += Config.animationChangePerMs * (float)delta) > 1.0f) {
                    animationProgress = 1.0f;
                }
                this.progressArr[chunkId] = animationProgress;
                float curved = Config.animationInitialOffset - Config.animationCurve.calculate(Float.valueOf(animationProgress)).floatValue() * Config.animationInitialOffset;
                curved = -curved;
                y = y <= 0.0f && curved > 0.0f ? 0.0f : curved;
                this.chunkFadeDatasBuffer.put(chunkId, 1, y);
            }
        } else if (!Config.isAnimationEnabled && this.chunkFadeDatasBuffer.get(chunkId, 1) != 0.0f) {
            this.chunkFadeDatasBuffer.put(chunkId, 1, 0.0f);
        }
    }
}

