/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.fabric.abstractions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.MappingResolver;

public final class ReflectionUtils {
    private static final MappingResolver mappingResolver = FabricLoader.getInstance().getMappingResolver();

    public static Class<?> TryGetClass(String fullClassName) {
        try {
            return ReflectionUtils.GetClass(fullClassName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> GetClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    public static Class<?> TryGetObfuscatedClass(String fullIntermediaryClassName) {
        try {
            return ReflectionUtils.GetObfuscatedClass(fullIntermediaryClassName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> GetObfuscatedClass(String intermediaryClassName) throws ClassNotFoundException {
        String mappedTypeName = mappingResolver.mapClassName("intermediary", intermediaryClassName);
        Class<?> type = Class.forName(mappedTypeName);
        return type;
    }

    public static Method TryGetMethod(Class<?> type, String methodName, Class<?>[] parameterTypes) {
        try {
            return ReflectionUtils.GetMethod(type, methodName, parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method GetMethod(Class<?> type, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException, ClassNotFoundException {
        return type.getMethod(methodName, parameterTypes);
    }

    public static Method TryGetObfuscatedMethod(String intermediaryClassName, String intermediaryMethodName, String methodDescriptor, Class<?>[] parameterTypes) {
        try {
            return ReflectionUtils.GetObfuscatedMethod(intermediaryClassName, intermediaryMethodName, methodDescriptor, parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method GetObfuscatedMethod(String intermediaryClassName, String intermediaryMethodName, String methodDescriptor, Class<?>[] parameterTypes) throws NoSuchMethodException, ClassNotFoundException {
        Class<?> type = ReflectionUtils.GetObfuscatedClass(intermediaryClassName);
        String mappedMethodName = mappingResolver.mapMethodName("intermediary", intermediaryClassName, intermediaryMethodName, methodDescriptor);
        Method method = type.getMethod(mappedMethodName, parameterTypes);
        return method;
    }

    public static Object TryInvokeMethod(Method method, Object instance, Object ... args) {
        try {
            return method.invoke(instance, args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Constructor<?> TryGetConstructor(Class<?> type, Class<?> ... parameters) {
        try {
            return ReflectionUtils.GetConstructor(type, parameters);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Constructor<?> GetConstructor(Class<?> type, Class<?> ... parameters) throws NoSuchMethodException {
        return type.getConstructor(parameters);
    }

    public static Object TryCreateInstance(Constructor<?> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            return null;
        }
    }
}

