/*
 * Decompiled with CFR 0.152.
 */
package mirsario.cameraoverhaul.fabric;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.util.function.Function;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.FloatListEntry;
import mirsario.cameraoverhaul.common.CameraOverhaul;
import mirsario.cameraoverhaul.common.configuration.ConfigData;
import mirsario.cameraoverhaul.core.configuration.Configuration;
import mirsario.cameraoverhaul.core.utils.MathUtils;
import mirsario.cameraoverhaul.fabric.abstractions.TextAbstractions;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class ModMenuConfigIntegration
implements ModMenuApi {
    private static final String configEntriesPrefix = "cameraoverhaul.config";

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return screen -> ModMenuConfigIntegration.GetConfigBuilder().build();
    }

    public static ConfigBuilder GetConfigBuilder() {
        ConfigData config = CameraOverhaul.instance.config;
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(class_310.method_1551().field_1755).setTitle(TextAbstractions.CreateText("cameraoverhaul.config.title")).transparentBackground().setSavingRunnable(() -> Configuration.SaveConfig(CameraOverhaul.instance.config, "cameraoverhaul", 1));
        ConfigCategory general = builder.getOrCreateCategory(TextAbstractions.CreateText("cameraoverhaul.config.category.general"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        general.addEntry((AbstractConfigListEntry)ModMenuConfigIntegration.CreateBooleanEntry(entryBuilder, "enabled", true, config.enabled, value -> {
            config.enabled = value;
            return config.enabled;
        }));
        general.addEntry((AbstractConfigListEntry)ModMenuConfigIntegration.CreateFloatFactorEntry(entryBuilder, "strafingRollFactor", 1.0f, config.strafingRollFactor, value -> {
            config.strafingRollFactor = value.floatValue();
            return Float.valueOf(config.strafingRollFactor);
        }));
        general.addEntry((AbstractConfigListEntry)ModMenuConfigIntegration.CreateFloatFactorEntry(entryBuilder, "strafingRollFactorWhenFlying", -1.0f, config.strafingRollFactorWhenFlying, value -> {
            config.strafingRollFactorWhenFlying = value.floatValue();
            return Float.valueOf(config.strafingRollFactorWhenFlying);
        }));
        general.addEntry((AbstractConfigListEntry)ModMenuConfigIntegration.CreateFloatFactorEntry(entryBuilder, "strafingRollFactorWhenSwimming", -1.0f, config.strafingRollFactorWhenSwimming, value -> {
            config.strafingRollFactorWhenSwimming = value.floatValue();
            return Float.valueOf(config.strafingRollFactorWhenSwimming);
        }));
        general.addEntry((AbstractConfigListEntry)ModMenuConfigIntegration.CreateFloatFactorEntry(entryBuilder, "yawDeltaRollFactor", 1.0f, config.yawDeltaRollFactor, value -> {
            config.yawDeltaRollFactor = value.floatValue();
            return Float.valueOf(config.yawDeltaRollFactor);
        }));
        general.addEntry((AbstractConfigListEntry)ModMenuConfigIntegration.CreateFloatFactorEntry(entryBuilder, "verticalVelocityPitchFactor", 1.0f, config.verticalVelocityPitchFactor, value -> {
            config.verticalVelocityPitchFactor = value.floatValue();
            return Float.valueOf(config.verticalVelocityPitchFactor);
        }));
        general.addEntry((AbstractConfigListEntry)ModMenuConfigIntegration.CreateFloatFactorEntry(entryBuilder, "forwardVelocityPitchFactor", 1.0f, config.forwardVelocityPitchFactor, value -> {
            config.forwardVelocityPitchFactor = value.floatValue();
            return Float.valueOf(config.forwardVelocityPitchFactor);
        }));
        general.addEntry((AbstractConfigListEntry)ModMenuConfigIntegration.CreateFloatFactorEntry(entryBuilder, "horizontalVelocitySmoothingFactor", 0.8f, ModMenuConfigIntegration.ClampSmoothness(config.horizontalVelocitySmoothingFactor), value -> {
            config.horizontalVelocitySmoothingFactor = ModMenuConfigIntegration.ClampSmoothness(value.floatValue());
            return Float.valueOf(config.horizontalVelocitySmoothingFactor);
        }));
        general.addEntry((AbstractConfigListEntry)ModMenuConfigIntegration.CreateFloatFactorEntry(entryBuilder, "verticalVelocitySmoothingFactor", 0.8f, ModMenuConfigIntegration.ClampSmoothness(config.verticalVelocitySmoothingFactor), value -> {
            config.verticalVelocitySmoothingFactor = ModMenuConfigIntegration.ClampSmoothness(value.floatValue());
            return Float.valueOf(config.verticalVelocitySmoothingFactor);
        }));
        general.addEntry((AbstractConfigListEntry)ModMenuConfigIntegration.CreateFloatFactorEntry(entryBuilder, "yawDeltaSmoothingFactor", 0.8f, ModMenuConfigIntegration.ClampSmoothness(config.yawDeltaSmoothingFactor), value -> {
            config.yawDeltaSmoothingFactor = ModMenuConfigIntegration.ClampSmoothness(value.floatValue());
            return Float.valueOf(config.yawDeltaSmoothingFactor);
        }));
        general.addEntry((AbstractConfigListEntry)ModMenuConfigIntegration.CreateFloatFactorEntry(entryBuilder, "yawDeltaDecayFactor", 0.5f, ModMenuConfigIntegration.ClampSmoothness(config.yawDeltaDecayFactor), value -> {
            config.yawDeltaDecayFactor = ModMenuConfigIntegration.ClampSmoothness(value.floatValue());
            return Float.valueOf(config.yawDeltaDecayFactor);
        }));
        return builder;
    }

    private static float ClampSmoothness(float value) {
        return MathUtils.Clamp(value, 0.0f, 0.999f);
    }

    public static BooleanListEntry CreateBooleanEntry(ConfigEntryBuilder entryBuilder, String entryName, Boolean defaultValue, Boolean value, Function<Boolean, Boolean> setter) {
        String lowerCaseName = entryName.toLowerCase();
        String baseTranslationPath = "cameraoverhaul.config." + lowerCaseName;
        return entryBuilder.startBooleanToggle(TextAbstractions.CreateText(baseTranslationPath + ".name"), value.booleanValue()).setDefaultValue(defaultValue.booleanValue()).setTooltip(new class_2561[]{TextAbstractions.CreateText(baseTranslationPath + ".tooltip")}).setSaveConsumer(newValue -> setter.apply((Boolean)newValue)).build();
    }

    public static FloatListEntry CreateFloatFactorEntry(ConfigEntryBuilder entryBuilder, String entryName, float defaultValue, float value, Function<Float, Float> setter) {
        String lowerCaseName = entryName.toLowerCase();
        String baseTranslationPath = "cameraoverhaul.config." + lowerCaseName;
        return entryBuilder.startFloatField(TextAbstractions.CreateText(baseTranslationPath + ".name"), value).setDefaultValue(defaultValue).setTooltip(new class_2561[]{TextAbstractions.CreateText(baseTranslationPath + ".tooltip")}).setSaveConsumer(newValue -> setter.apply((Float)newValue)).build();
    }
}

