/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.bodyparts.mixin;

import com.zeydie.bodyparts.api.BodyPart;
import com.zeydie.bodyparts.api.BodyPartScaleData;
import net.minecraft.class_1007;
import net.minecraft.class_1657;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_922;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1007.class})
public abstract class PlayerEntityRendererMixin
extends class_922<class_742, class_591<class_742>> {
    private float originalHeadPivotY;
    private float originalRightArmPivotY;
    private float originalLeftArmPivotY;

    public PlayerEntityRendererMixin(class_5617.class_5618 ctx, class_591<class_742> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(method={"setModelPose"}, at={@At(value="TAIL")})
    private void onSetModelPose(class_742 player, CallbackInfo ci) {
        class_591 model = (class_591)this.method_4038();
        BodyPartScaleData data = BodyPartScaleData.get((class_1657)player);
        this.applyData(player);
        this.adjustBodyPartPositions(player);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void adjustModelOffset(class_742 player, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        class_591 model = (class_591)this.method_4038();
        BodyPartScaleData data = BodyPartScaleData.get((class_1657)player);
        float rightLegYScale = data.getScale(BodyPart.RIGHT_LEG).y();
        float leftLegYScale = data.getScale(BodyPart.LEFT_LEG).y();
        float maxLegYScale = Math.max(rightLegYScale, leftLegYScale);
        float offset = (maxLegYScale - 1.0f) * 0.75f;
        matrices.method_46416(0.0f, offset, 0.0f);
        this.originalHeadPivotY = model.field_3398.field_3656;
        this.originalRightArmPivotY = model.field_3401.field_3656;
        this.originalLeftArmPivotY = model.field_27433.field_3656;
        float torsoYScale = data.getScale(BodyPart.TORSO).y();
        if (torsoYScale != 1.0f) {
            float standardTorsoHeight = 12.0f;
            float deltaY = (torsoYScale - 1.0f) * standardTorsoHeight;
            model.field_3398.field_3656 += deltaY;
            model.field_3401.field_3656 += deltaY;
            model.field_27433.field_3656 += deltaY;
        }
    }

    private void applyData(class_742 abstractClientPlayerEntity) {
        class_591 model = (class_591)this.method_4038();
        BodyPartScaleData data = BodyPartScaleData.get((class_1657)abstractClientPlayerEntity);
        this.applyScale(model.field_3398, data.getScale(BodyPart.HEAD));
        this.applyScale(model.field_3391, data.getScale(BodyPart.TORSO));
        this.applyScale(model.field_3401, data.getScale(BodyPart.RIGHT_ARM));
        this.applyScale(model.field_27433, data.getScale(BodyPart.LEFT_ARM));
        this.applyScale(model.field_3392, data.getScale(BodyPart.RIGHT_LEG));
        this.applyScale(model.field_3397, data.getScale(BodyPart.LEFT_LEG));
    }

    private void applyScale(class_630 part, Vector3f scale) {
        part.field_37938 = scale.x();
        part.field_37939 = scale.y();
        part.field_37940 = scale.z();
    }

    private void adjustBodyPartPositions(class_742 player) {
        float legHorizontalOffset;
        class_591 model = (class_591)this.method_4038();
        BodyPartScaleData data = BodyPartScaleData.get((class_1657)player);
        Vector3f torsoScale = data.getScale(BodyPart.TORSO);
        model.field_3397.field_3657 = legHorizontalOffset = 2.0f * torsoScale.x();
        model.field_3392.field_3657 = -legHorizontalOffset;
    }
}

