/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.bodyparts.api;

import com.zeydie.bodyparts.BodyPartsMod;
import com.zeydie.bodyparts.api.BodyPart;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.joml.Vector3f;

public class BodyPartScaleData {
    private static final Map<UUID, BodyPartScaleData> SCALE_DATA = new HashMap<UUID, BodyPartScaleData>();
    private final UUID playerUuid;
    private final Map<BodyPart, Vector3f> scales = new HashMap<BodyPart, Vector3f>();

    public BodyPartScaleData(UUID uuid) {
        this.playerUuid = uuid;
        for (BodyPart part : BodyPart.values()) {
            this.scales.put(part, new Vector3f(1.0f, 1.0f, 1.0f));
        }
    }

    public static BodyPartScaleData get(class_1657 player) {
        return BodyPartScaleData.get(player.method_5667());
    }

    public static BodyPartScaleData get(UUID uuid) {
        return SCALE_DATA.computeIfAbsent(uuid, value -> new BodyPartScaleData((UUID)value));
    }

    public void setScale(BodyPart part, Vector3f scale) {
        this.scales.put(part, scale);
    }

    public Vector3f getScale(BodyPart part) {
        return this.scales.getOrDefault((Object)part, new Vector3f(1.0f, 1.0f, 1.0f));
    }

    public void readFromNbt(class_2487 tag) {
        for (BodyPart part : BodyPart.values()) {
            String key = part.name().toLowerCase();
            if (!tag.method_10545(key + "_x")) continue;
            float x = tag.method_10583(key + "_x");
            float y = tag.method_10583(key + "_y");
            float z = tag.method_10583(key + "_z");
            this.scales.put(part, new Vector3f(x, y, z));
        }
    }

    public void writeToNbt(class_2487 tag) {
        for (Map.Entry<BodyPart, Vector3f> entry : this.scales.entrySet()) {
            String key = entry.getKey().name().toLowerCase();
            tag.method_10548(key + "_x", entry.getValue().x());
            tag.method_10548(key + "_y", entry.getValue().y());
            tag.method_10548(key + "_z", entry.getValue().z());
        }
    }

    public static void sync(class_3222 player) {
        BodyPartScaleData data = BodyPartScaleData.get(player.method_5667());
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10797(player.method_5667());
        for (BodyPart part : BodyPart.values()) {
            Vector3f scale = data.getScale(part);
            buf.writeFloat(scale.x());
            buf.writeFloat(scale.y());
            buf.writeFloat(scale.z());
        }
        for (class_1657 otherPlayer : player.field_6002.method_18456()) {
            if (!(otherPlayer instanceof class_3222)) continue;
            class_3222 serverPlayerEntity = (class_3222)otherPlayer;
            ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_2960)BodyPartsMod.BODY_PART_UPDATE_PACKET, (class_2540)buf);
        }
    }
}

