/*
 * Decompiled with CFR 0.152.
 */
package com.example.biomskyclient;

import io.github.amerebagatelle.fabricskyboxes.SkyboxManager;
import io.github.amerebagatelle.fabricskyboxes.api.skyboxes.Skybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.AbstractSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.textured.SingleSpriteSquareTexturedSkybox;
import io.github.amerebagatelle.fabricskyboxes.util.object.Blend;
import io.github.amerebagatelle.fabricskyboxes.util.object.Conditions;
import io.github.amerebagatelle.fabricskyboxes.util.object.Decorations;
import io.github.amerebagatelle.fabricskyboxes.util.object.Fade;
import io.github.amerebagatelle.fabricskyboxes.util.object.Loop;
import io.github.amerebagatelle.fabricskyboxes.util.object.Properties;
import io.github.amerebagatelle.fabricskyboxes.util.object.RGBA;
import io.github.amerebagatelle.fabricskyboxes.util.object.Rotation;
import io.github.amerebagatelle.fabricskyboxes.util.object.Texture;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector3f;

public class BiomSkyClient
implements ClientModInitializer {
    private static final Logger LOGGER = LogManager.getLogger((String)"BiomSkyClient");
    private static final class_2960 CHANNEL = new class_2960("biomsky", "change_sky");
    private AbstractSkybox activeSkybox = null;
    private class_2960 activeSkyboxId = null;
    private Map<class_2960, AbstractSkybox> initialSkyboxes = new HashMap<class_2960, AbstractSkybox>();
    private boolean isInitialStateSaved = false;

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)CHANNEL, (client, handler, buf, responseSender) -> {
            byte length = buf.readByte();
            byte[] stringBytes = new byte[length];
            buf.readBytes(stringBytes);
            String command = new String(stringBytes, StandardCharsets.UTF_8);
            client.execute(() -> {
                if (command.equals("disable_sky")) {
                    this.disableSkybox();
                } else {
                    this.activateSkybox(command);
                }
            });
        });
        LOGGER.info("BiomSkyClient initialized, listening on channel: " + CHANNEL);
    }

    private void activateSkybox(String command) {
        AbstractSkybox newSkybox;
        String skyId;
        String[] parts;
        SkyboxManager skyboxManager = SkyboxManager.getInstance();
        if (!this.isInitialStateSaved) {
            this.saveInitialSkyboxes(skyboxManager);
            this.isInitialStateSaved = true;
        }
        if ((parts = command.split(":")).length != 2) {
            LOGGER.warn("Invalid command format: " + command);
            return;
        }
        String mode = parts[0];
        switch (skyId = parts[1]) {
            case "sky401": {
                newSkybox = this.createSkybox("sky401", new class_2960("minecraft", "optifine/sky/world1/end_sky_1.png"));
                break;
            }
            case "blood_moon": {
                newSkybox = this.createSkybox("blood_moon", new class_2960("minecraft", "optifine/sky/world1/blood_moon_skybox.png"));
                break;
            }
            case "sky403": {
                newSkybox = this.createSkybox("sky403", new class_2960("minecraft", "optifine/sky/world1/end_sky_3.png"));
                break;
            }
            default: {
                LOGGER.warn("Unknown skybox ID: " + skyId);
                return;
            }
        }
        if (newSkybox != null) {
            if (this.activeSkybox != null) {
                try {
                    Field activeSkyboxesField = SkyboxManager.class.getDeclaredField("activeSkyboxes");
                    activeSkyboxesField.setAccessible(true);
                    List activeSkyboxes = (List)activeSkyboxesField.get(skyboxManager);
                    activeSkyboxes.removeIf(skybox -> skybox == this.activeSkybox);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to remove previous skybox: " + this.activeSkyboxId, (Throwable)e);
                }
            }
            if (mode.equals("replace")) {
                skyboxManager.clearSkyboxes();
            }
            this.activeSkybox = newSkybox;
            this.activeSkyboxId = new class_2960("fabricskyboxes", "sky/" + skyId);
            skyboxManager.addSkybox(this.activeSkyboxId, (Skybox)this.activeSkybox);
            LOGGER.info("Activated skybox: " + skyId + " in mode " + mode);
        } else {
            LOGGER.warn("Failed to create skybox: " + skyId);
        }
    }

    private void disableSkybox() {
        SkyboxManager skyboxManager = SkyboxManager.getInstance();
        if (this.activeSkybox != null && this.activeSkyboxId != null) {
            skyboxManager.clearSkyboxes();
            for (Map.Entry<class_2960, AbstractSkybox> entry : this.initialSkyboxes.entrySet()) {
                skyboxManager.addSkybox(entry.getKey(), (Skybox)entry.getValue());
            }
            LOGGER.info("Disabled custom skybox: " + this.activeSkyboxId + " and restored " + this.initialSkyboxes.size() + " initial skyboxes");
            this.activeSkybox = null;
            this.activeSkyboxId = null;
        } else {
            LOGGER.info("No custom skybox to disable");
        }
    }

    private void saveInitialSkyboxes(SkyboxManager skyboxManager) {
        try {
            Field activeSkyboxesField = SkyboxManager.class.getDeclaredField("activeSkyboxes");
            activeSkyboxesField.setAccessible(true);
            List activeSkyboxes = (List)activeSkyboxesField.get(skyboxManager);
            Field skyboxMapField = SkyboxManager.class.getDeclaredField("skyboxMap");
            skyboxMapField.setAccessible(true);
            Map skyboxMap = (Map)skyboxMapField.get(skyboxManager);
            this.initialSkyboxes.clear();
            block2: for (AbstractSkybox skybox : activeSkyboxes) {
                for (Map.Entry entry : skyboxMap.entrySet()) {
                    if (entry.getValue() != skybox) continue;
                    this.initialSkyboxes.put((class_2960)entry.getKey(), skybox);
                    continue block2;
                }
            }
            LOGGER.info("Saved " + this.initialSkyboxes.size() + " initial skyboxes");
        }
        catch (Exception e) {
            LOGGER.error("Failed to save initial skyboxes", (Throwable)e);
        }
    }

    private AbstractSkybox createSkybox(String skyId, class_2960 textureId) {
        Texture texture;
        Blend blend;
        Decorations decorations;
        Conditions conditions;
        Properties properties;
        if (skyId.equals("sky401")) {
            Fade fade = new Fade(1000, 2000, 2000, 3000, true);
            properties = new Properties(1, fade, 1.0f, 500, 500, false, RGBA.DEFAULT, false, false, new Rotation(false, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0.0f, 0.0f));
            conditions = new Conditions(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), new Loop(0.0, Collections.emptyList()));
            decorations = new Decorations(new class_2960("minecraft", "optifine/sky/world1/tumannost_2.png"), new class_2960("minecraft", "optifine/sky/world1/tumannost_1.png"), false, false, false, new Rotation(false, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0.0f, 0.0f), new Blend("add", Blend.DEFAULT.getBlender()));
            blend = new Blend("alpha", Blend.DEFAULT.getBlender());
            texture = new Texture(textureId);
        } else if (skyId.equals("blood_moon")) {
            Fade fade = new Fade(12000, 12500, 23900, 23999, false);
            properties = new Properties(1, fade, 1.0f, 10, 10, true, new RGBA(0.1f, 0.0f, 0.0f, 0.1f), false, true, new Rotation(true, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0.0f, 0.0f));
            conditions = new Conditions(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), new Loop(0.0, Collections.emptyList()));
            decorations = new Decorations(new class_2960("minecraft", "optifine/sky/world1/blood_moon.png"), new class_2960("minecraft", "optifine/sky/world1/blood_moon.png"), true, false, false, new Rotation(true, new Vector3f(0.0f, 0.0f, 90.0f), new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0.0f, 1.0f), new Blend("alpha", Blend.DEFAULT.getBlender()));
            blend = new Blend("alpha", Blend.DEFAULT.getBlender());
            texture = new Texture(textureId);
        } else if (skyId.equals("sky403")) {
            Fade fade = new Fade(2000, 3000, 3000, 4000, true);
            properties = new Properties(3, fade, 0.9f, 1000, 1000, false, new RGBA(0.5f, 0.5f, 1.0f, 1.0f), false, true, new Rotation(false, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), 0.0f, 0.0f, 0.1f));
            conditions = new Conditions(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), new Loop(0.0, Collections.emptyList()));
            decorations = new Decorations(new class_2960("minecraft", "optifine/sky/world1/sun403.png"), new class_2960("minecraft", "optifine/sky/world1/moon403.png"), false, false, true, new Rotation(false, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), 0.0f, 0.0f, 0.2f), new Blend("overlay", Blend.DEFAULT.getBlender()));
            blend = new Blend("alpha", Blend.DEFAULT.getBlender());
            texture = new Texture(textureId);
        } else {
            Fade fade = new Fade(1000, 2000, 2000, 3000, true);
            properties = new Properties(1, fade, 1.0f, 500, 500, false, RGBA.DEFAULT, false, false, new Rotation(false, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0.0f, 0.0f));
            conditions = new Conditions(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), new Loop(0.0, Collections.emptyList()));
            decorations = new Decorations(new class_2960("minecraft", "optifine/sky/world1/tumannost_2.png"), new class_2960("minecraft", "optifine/sky/world1/tumannost_1.png"), false, false, false, new Rotation(false, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0.0f, 0.0f), new Blend("add", Blend.DEFAULT.getBlender()));
            blend = new Blend("alpha", Blend.DEFAULT.getBlender());
            texture = new Texture(textureId);
        }
        return new SingleSpriteSquareTexturedSkybox(properties, conditions, decorations, blend, texture);
    }
}

