/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TelemetryCache {
    protected final Pattern linePattern = Pattern.compile("^(\\w+)\\s+([0-9a-f]+)\\s*$");
    protected FileWriter writer;
    protected boolean available;
    protected final Map<String, Set<String>> cache = new HashMap<String, Set<String>>();
    protected final HashFunction hashFunction = Hashing.sipHash24();
    private boolean opened;

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void open() throws IOException {
        if (this.opened) {
            return;
        }
        this.opened = true;
        this.cache.clear();
        File dir = Paths.get(".cache", new String[0]).toFile();
        dir.mkdir();
        File file = Paths.get(".cache", "betterclouds-telemetry_cache-v2.bin").toFile();
        file.createNewFile();
        int lineCount = 0;
        int maxLines = 10000;
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                if (lineCount++ > 10000) {
                    break;
                }
                Matcher matcher = this.linePattern.matcher(line);
                if (!matcher.matches()) continue;
                String type = matcher.group(1).toLowerCase();
                String hash = matcher.group(2).toLowerCase();
                if (!this.cache.containsKey(type)) {
                    this.cache.put(type, new HashSet());
                }
                this.cache.get(type).add(hash);
            }
        }
        if (lineCount > 10000) {
            Files.write(file.toPath(), new byte[0], StandardOpenOption.TRUNCATE_EXISTING);
            this.cache.clear();
        }
        this.writer = new FileWriter(file, StandardCharsets.UTF_8, true);
        this.available = true;
    }

    public boolean contains(String type, String hash) {
        if (!this.available) {
            throw new UnsupportedOperationException("Cache it not available!");
        }
        type = type.toLowerCase();
        hash = hash.toLowerCase();
        if (!this.cache.containsKey(type)) {
            return false;
        }
        return this.cache.get(type).contains(hash);
    }

    public void add(String type, String hash) {
        if (!this.available) {
            throw new UnsupportedOperationException("Cache it not available!");
        }
        type = type.toLowerCase();
        hash = hash.toLowerCase();
        if (!this.cache.containsKey(type)) {
            this.cache.put(type, new HashSet());
        }
        this.cache.get(type).add(hash);
        try {
            this.writer.append(String.format("%s%s %s", System.lineSeparator(), type, hash));
            this.writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String hash(String str) {
        return this.hashFunction.hashString((CharSequence)str, StandardCharsets.UTF_8).toString();
    }
}

