/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds.shaders;

import com.mojang.blaze3d.platform.GlStateManager;
import com.qendolin.betterclouds.Main;
import com.qendolin.betterclouds.clouds.Resources;
import com.qendolin.betterclouds.clouds.shaders.Uniform;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_2973;
import net.minecraft.class_3300;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL32;

public class Shader
implements AutoCloseable {
    private final Map<String, String> defs;
    protected int programId;

    public Shader(class_3300 resMan, class_2960 vshId, class_2960 fshId, Map<String, String> defs) throws IOException {
        this.defs = defs;
        int vsh = this.compileShader(35633, vshId, resMan);
        int fsh = this.compileShader(35632, fshId, resMan);
        Main.glCompat.objectLabelDev(Main.glCompat.GL_SHADER, vsh, vshId.method_12832());
        Main.glCompat.objectLabelDev(Main.glCompat.GL_SHADER, fsh, fshId.method_12832());
        this.programId = GlStateManager.glCreateProgram();
        GL32.glAttachShader((int)this.programId, (int)vsh);
        GL32.glAttachShader((int)this.programId, (int)fsh);
        GL32.glLinkProgram((int)this.programId);
        if (GL32.glGetProgrami((int)this.programId, (int)35714) == 0) {
            String log = GL32.glGetProgramInfoLog((int)this.programId);
            throw new IllegalStateException("Failed to link program: " + log);
        }
        GlStateManager.glDeleteShader((int)vsh);
        GlStateManager.glDeleteShader((int)fsh);
    }

    protected int compileShader(int type, class_2960 resource, class_3300 resMan) throws IOException {
        String shaderSrc;
        try {
            InputStream stream = resMan.getResourceOrThrow(resource).method_14482();
            shaderSrc = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            shaderSrc = shaderSrc.strip();
        }
        catch (IOException ex) {
            class_2973 fileEx = class_2973.method_12856((Exception)ex);
            fileEx.method_12855(resource.toString());
            throw fileEx;
        }
        for (Map.Entry<String, String> entry : this.defs.entrySet()) {
            shaderSrc = shaderSrc.replace(entry.getKey(), entry.getValue());
        }
        int id = GlStateManager.glCreateShader((int)type);
        GlStateManager.glShaderSource((int)id, Collections.singletonList(shaderSrc));
        GlStateManager.glCompileShader((int)id);
        if (GlStateManager.glGetShaderi((int)id, (int)35713) == 0) {
            String log = StringUtils.trim((String)GlStateManager.glGetShaderInfoLog((int)id, (int)32768));
            class_2973 parseEx = new class_2973("Couldn't compile shader program (" + resource + "): \n" + log + "\n\nShader Source: \n" + shaderSrc);
            parseEx.method_12855(resource.toString());
            throw parseEx;
        }
        return id;
    }

    @Override
    public void close() {
        if (this.programId != 0) {
            GL32.glDeleteProgram((int)this.programId);
        }
        this.programId = 0;
    }

    public boolean isIncomplete() {
        return this.programId <= 0;
    }

    public void bind() {
        GL32.glUseProgram((int)this.programId);
    }

    public int glId() {
        return this.programId;
    }

    public void unbind() {
        Resources.unbindShader();
    }

    protected Uniform getUniform(String name, boolean cached) {
        int location = GL32.glGetUniformLocation((int)this.programId, (CharSequence)name);
        if (location < 0) {
            return new Uniform.Noop(name, location);
        }
        if (cached) {
            return new Uniform.Cached(name, location);
        }
        return new Uniform.Simple(name, location);
    }
}

