/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.qendolin.betterclouds.Config;
import com.qendolin.betterclouds.Main;
import com.qendolin.betterclouds.clouds.ChunkedGenerator;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.GlTimer;
import com.qendolin.betterclouds.clouds.Mesh;
import com.qendolin.betterclouds.clouds.shaders.CoverageShader;
import com.qendolin.betterclouds.clouds.shaders.DepthShader;
import com.qendolin.betterclouds.clouds.shaders.ShadingShader;
import com.qendolin.betterclouds.compat.Telemetry;
import com.qendolin.betterclouds.mixin.BufferRendererAccessor;
import com.qendolin.betterclouds.mixin.ShaderProgramAccessor;
import com.qendolin.betterclouds.mixin.VertexBufferAccessor;
import java.io.Closeable;
import java.io.IOException;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.lwjgl.opengl.GL32;

public class Resources
implements Closeable {
    public static final class_2960 NOISE_TEXTURE = new class_2960("betterclouds", "textures/environment/cloud_noise_rgb.png");
    public static final class_2960 LIGHTING_TEXTURE = new class_2960("betterclouds", "textures/environment/cloud_light_gradient.png");
    private static final int UNASSIGNED = 0;
    private DepthShader depthShader = null;
    private CoverageShader coverageShader = null;
    private ShadingShader shadingShader = null;
    private ChunkedGenerator generator = null;
    private int cubeVbo;
    private int cubeVao;
    private int oitFbo;
    private int oitCoverageDepthTexture;
    private int oitDataTexture;
    private int oitCoverageTexture;
    private int fboWidth;
    private int fboHeight;
    private GlTimer timer;

    public ChunkedGenerator generator() {
        return this.generator;
    }

    public DepthShader depthShader() {
        return this.depthShader;
    }

    public CoverageShader coverageShader() {
        return this.coverageShader;
    }

    public ShadingShader shadingShader() {
        return this.shadingShader;
    }

    public int cubeVao() {
        return this.cubeVao;
    }

    public int oitFbo() {
        return this.oitFbo;
    }

    public int oitCoverageDepthTexture() {
        return this.oitCoverageDepthTexture;
    }

    public int oitDataTexture() {
        return this.oitDataTexture;
    }

    public int oitCoverageTexture() {
        return this.oitCoverageTexture;
    }

    public GlTimer timer() {
        return this.timer;
    }

    public int fboWidth() {
        return this.fboWidth;
    }

    public int fboHeight() {
        return this.fboHeight;
    }

    public boolean failedToLoadCritical() {
        if (this.depthShader == null || this.coverageShader == null || this.shadingShader == null) {
            return true;
        }
        if (this.depthShader.isIncomplete() || this.coverageShader.isIncomplete() || this.shadingShader.isIncomplete()) {
            return true;
        }
        if (this.generator == null) {
            return true;
        }
        if (this.oitFbo == 0) {
            return true;
        }
        if (this.oitDataTexture == 0 || this.oitCoverageTexture == 0) {
            return true;
        }
        return this.cubeVao == 0 || this.cubeVbo == 0;
    }

    public void reloadTimer() {
        this.deleteTimer();
        if (!Main.isProfilingEnabled()) {
            return;
        }
        Debug.trace.ifPresent(snapshot -> snapshot.recordEvent("reloading timers"));
        this.timer = new GlTimer();
    }

    public void deleteTimer() {
        if (this.timer != null) {
            this.timer.close();
        }
        this.timer = null;
    }

    public void reloadMeshPrimitives() {
        this.deleteMeshPrimitives();
        Debug.trace.ifPresent(snapshot -> snapshot.recordEvent("reloading mesh primitives"));
        this.cubeVao = GL32.glGenVertexArrays();
        GL32.glBindVertexArray((int)this.cubeVao);
        Main.glCompat.objectLabelDev(Main.glCompat.GL_VERTEX_ARRAY, this.cubeVao, "cube");
        this.cubeVbo = GL32.glGenBuffers();
        GL32.glBindBuffer((int)34962, (int)this.cubeVbo);
        Main.glCompat.objectLabelDev(Main.glCompat.GL_BUFFER, this.cubeVbo, "cube");
        GL32.glBufferData((int)34962, (float[])Mesh.CUBE_MESH, (int)35044);
        GL32.glEnableVertexAttribArray((int)0);
        GL32.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)0, (long)0L);
        Resources.unbindVao();
        Resources.unbindVbo();
    }

    public void deleteMeshPrimitives() {
        if (this.cubeVbo != 0) {
            GL32.glDeleteBuffers((int)this.cubeVbo);
        }
        if (this.cubeVao != 0) {
            GL32.glDeleteVertexArrays((int)this.cubeVao);
        }
        this.cubeVbo = 0;
        this.cubeVao = 0;
    }

    public static void unbindVao() {
        VertexBufferAccessor buffer = (VertexBufferAccessor)BufferRendererAccessor.getCurrentVertexBuffer();
        if (buffer == null) {
            return;
        }
        int previousVaoId = buffer.getVertexArrayId();
        if (previousVaoId > 0) {
            GL32.glBindVertexArray((int)previousVaoId);
        }
    }

    public static void unbindVbo() {
        VertexBufferAccessor buffer = (VertexBufferAccessor)BufferRendererAccessor.getCurrentVertexBuffer();
        if (buffer == null) {
            return;
        }
        int previousVboId = buffer.getVertexBufferId();
        if (previousVboId > 0) {
            GL32.glBindBuffer((int)34962, (int)previousVboId);
        }
    }

    public void reloadTextures(class_310 client) {
        Debug.trace.ifPresent(snapshot -> snapshot.recordEvent("reloading textures"));
        int noiseTexture = client.method_1531().method_4619(NOISE_TEXTURE).method_4624();
        RenderSystem.activeTexture((int)33984);
        RenderSystem.bindTexture((int)noiseTexture);
        Main.glCompat.objectLabelDev(5890, noiseTexture, "noise");
        RenderSystem.texParameter((int)3553, (int)10242, (int)10497);
        RenderSystem.texParameter((int)3553, (int)10243, (int)10497);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        int lightingTexture = client.method_1531().method_4619(LIGHTING_TEXTURE).method_4624();
        RenderSystem.bindTexture((int)lightingTexture);
        Main.glCompat.objectLabelDev(5890, lightingTexture, "lighting");
        RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
        RenderSystem.texParameter((int)3553, (int)10243, (int)10497);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        RenderSystem.bindTexture((int)0);
    }

    public void reloadGenerator(boolean fancy) {
        this.deleteGenerator();
        Debug.trace.ifPresent(snapshot -> snapshot.recordEvent("reloading generator"));
        this.generator = new ChunkedGenerator();
        this.generator.allocate(Main.getConfig(), fancy);
        this.generator.clear();
        this.generator.unbind();
    }

    public void deleteGenerator() {
        if (this.generator != null) {
            this.generator.close();
        }
        this.generator = null;
    }

    public void reloadFramebuffer(int width, int height) {
        this.deleteFramebuffer();
        Debug.trace.ifPresent(snapshot -> snapshot.recordEvent("reloading framebuffer"));
        this.oitFbo = GL32.glGenFramebuffers();
        GlStateManager._glBindFramebuffer((int)36009, (int)this.oitFbo);
        Main.glCompat.objectLabelDev(36160, this.oitFbo, "coverage");
        this.fboWidth = width;
        this.fboHeight = height;
        this.oitDataTexture = GL32.glGenTextures();
        RenderSystem.activeTexture((int)33984);
        RenderSystem.bindTexture((int)this.oitDataTexture);
        Main.glCompat.objectLabelDev(5890, this.oitDataTexture, "coverage_color");
        Main.glCompat.texStorage2DFallback(3553, 1, 32849, this.fboWidth, this.fboHeight, 6407, 5120);
        GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL32.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.oitDataTexture, (int)0);
        GL32.glDrawBuffers((int[])new int[]{36064});
        if (Main.glCompat.useStencilTextureFallback) {
            this.oitCoverageTexture = GL32.glGenTextures();
            RenderSystem.bindTexture((int)this.oitCoverageTexture);
            Main.glCompat.objectLabelDev(5890, this.oitCoverageTexture, "coverage_color_fallback");
            Main.glCompat.texStorage2DFallback(3553, 1, 33321, this.fboWidth, this.fboHeight, 6403, 5121);
            GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL32.glFramebufferTexture2D((int)36160, (int)36065, (int)3553, (int)this.oitCoverageTexture, (int)0);
            GL32.glDrawBuffers((int[])new int[]{36064, 36065});
            this.oitCoverageDepthTexture = GL32.glGenTextures();
            GL32.glBindTexture((int)3553, (int)this.oitCoverageDepthTexture);
            Main.glCompat.objectLabelDev(5890, this.oitCoverageDepthTexture, "coverage_depth");
            Main.glCompat.texStorage2DFallback(3553, 1, 33190, this.fboWidth, this.fboHeight, 6402, 5126);
            GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL32.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)this.oitCoverageDepthTexture, (int)0);
        } else {
            this.oitCoverageTexture = GL32.glGenTextures();
            RenderSystem.bindTexture((int)this.oitCoverageTexture);
            Main.glCompat.objectLabelDev(5890, this.oitCoverageTexture, "coverage_stencil");
            Main.glCompat.texStorage2D(3553, 1, 35056, this.fboWidth, this.fboHeight);
            GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL32.glTexParameteri((int)3553, (int)Main.glCompat.GL_DEPTH_STENCIL_TEXTURE_MODE, (int)6401);
            GL32.glFramebufferTexture2D((int)36160, (int)33306, (int)3553, (int)this.oitCoverageTexture, (int)0);
            if (Main.glCompat.useDepthWriteFallback) {
                this.oitCoverageDepthTexture = this.oitCoverageTexture;
            } else {
                this.oitCoverageDepthTexture = GL32.glGenTextures();
                Main.glCompat.textureView(this.oitCoverageDepthTexture, 3553, this.oitCoverageTexture, 35056, 0, 1, 0, 1);
                GL32.glBindTexture((int)3553, (int)this.oitCoverageDepthTexture);
                Main.glCompat.objectLabelDev(5890, this.oitCoverageDepthTexture, "coverage_depth");
                GL32.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL32.glTexParameteri((int)3553, (int)10240, (int)9728);
                GL32.glTexParameteri((int)3553, (int)Main.glCompat.GL_DEPTH_STENCIL_TEXTURE_MODE, (int)6402);
            }
        }
        RenderSystem.bindTexture((int)0);
        int status = GL32.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            throw new RuntimeException("Better Clouds framebuffer incomplete, your GPU is likely incompatible, status: " + status);
        }
    }

    public void deleteFramebuffer() {
        if (this.oitFbo != 0) {
            GL32.glDeleteFramebuffers((int)this.oitFbo);
        }
        if (this.oitDataTexture != 0) {
            RenderSystem.deleteTexture((int)this.oitDataTexture);
        }
        if (this.oitCoverageTexture != 0) {
            RenderSystem.deleteTexture((int)this.oitCoverageTexture);
        }
        if (this.oitCoverageDepthTexture != 0) {
            RenderSystem.deleteTexture((int)this.oitCoverageDepthTexture);
        }
        this.oitFbo = 0;
        this.oitDataTexture = 0;
        this.oitCoverageTexture = 0;
        this.oitCoverageDepthTexture = 0;
    }

    public void reloadShaders(class_3300 manager) {
        Debug.trace.ifPresent(snapshot -> snapshot.recordEvent("reloading shaders"));
        try {
            this.reloadShadersInternal(manager, false);
        }
        catch (Exception ignored) {
            try {
                this.reloadShadersInternal(manager, true);
            }
            catch (Exception e) {
                Main.sendGpuIncompatibleChatMessage();
                Main.LOGGER.error(e);
                Telemetry.INSTANCE.sendShaderCompileError(e.toString());
                this.deleteShaders();
            }
        }
        Resources.unbindShader();
    }

    protected void reloadShadersInternal(class_3300 manager, boolean safeMode) throws IOException {
        this.deleteShaders();
        Config config = Main.getConfig();
        this.depthShader = DepthShader.create(manager);
        this.depthShader.bind();
        this.depthShader.uDepthTexture.setInt(6);
        Main.glCompat.objectLabelDev(Main.glCompat.GL_PROGRAM, this.depthShader.glId(), "depth");
        int edgeFade = (int)(config.fadeEdge * (float)config.blockDistance());
        this.coverageShader = CoverageShader.create(manager, config.sizeXZ, config.sizeY, edgeFade, Main.glCompat.useStencilTextureFallback);
        this.coverageShader.bind();
        this.coverageShader.uDepthTexture.setInt(0);
        this.coverageShader.uNoiseTexture.setInt(5);
        Main.glCompat.objectLabelDev(Main.glCompat.GL_PROGRAM, this.coverageShader.glId(), "coverage");
        this.shadingShader = ShadingShader.create(manager, Main.glCompat.useDepthWriteFallback, Main.glCompat.useStencilTextureFallback);
        this.shadingShader.bind();
        this.shadingShader.uDepthTexture.setInt(1);
        this.shadingShader.uDataTexture.setInt(2);
        this.shadingShader.uCoverageTexture.setInt(3);
        this.shadingShader.uLightTexture.setInt(4);
        Main.glCompat.objectLabelDev(Main.glCompat.GL_PROGRAM, this.shadingShader.glId(), "shading");
    }

    public void deleteShaders() {
        if (this.depthShader != null) {
            this.depthShader.close();
        }
        if (this.coverageShader != null) {
            this.coverageShader.close();
        }
        if (this.shadingShader != null) {
            this.shadingShader.close();
        }
        this.depthShader = null;
        this.coverageShader = null;
        this.shadingShader = null;
    }

    public static void unbindShader() {
        int previousProgramId = ShaderProgramAccessor.getActiveProgramGlRef();
        if (previousProgramId > 0) {
            GL32.glUseProgram((int)previousProgramId);
        }
    }

    @Override
    public void close() {
        this.deleteFramebuffer();
        this.deleteMeshPrimitives();
        this.deleteGenerator();
        this.deleteShaders();
        this.deleteTimer();
    }
}

