/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.clouds;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.qendolin.betterclouds.Main;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.class_1008;
import net.minecraft.class_238;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3545;
import net.minecraft.class_4588;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.apache.commons.lang3.NotImplementedException;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL32;
import org.lwjgl.opengl.GLDebugMessageCallback;

public class Debug {
    public static int profileInterval = 0;
    public static boolean frustumCulling = false;
    public static boolean generatorPause = false;
    public static int animationPause = -1;
    public static boolean generatorForceUpdate = false;
    @NotNull
    public static Optional<DebugTrace> trace = Optional.empty();
    public static final List<class_3545<class_238, Boolean>> frustumCulledBoxes = new ArrayList<class_3545<class_238, Boolean>>();

    public static void clearFrustumCulledBoxed() {
        if (frustumCulling) {
            frustumCulledBoxes.clear();
        } else if (!frustumCulledBoxes.isEmpty()) {
            frustumCulledBoxes.clear();
        }
    }

    public static void addFrustumCulledBox(class_238 box, boolean visible) {
        if (!frustumCulling) {
            return;
        }
        frustumCulledBoxes.add((class_3545<class_238, Boolean>)new class_3545((Object)box, (Object)visible));
    }

    public static void drawFrustumCulledBoxes(Vector3d cam) {
        if (!frustumCulling) {
            return;
        }
        class_287 vertices = class_289.method_1348().method_1349();
        vertices.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        class_5944 prevShader = RenderSystem.getShader();
        RenderSystem.setShader(class_757::method_34540);
        for (class_3545<class_238, Boolean> pair : frustumCulledBoxes) {
            class_238 box = (class_238)pair.method_15442();
            if (((Boolean)pair.method_15441()).booleanValue()) {
                Debug.drawBox(cam, (class_4588)vertices, box, 0.6f, 1.0f, 0.5f, 1.0f);
                continue;
            }
            Debug.drawBox(cam, (class_4588)vertices, box, 1.0f, 0.6f, 0.5f, 1.0f);
        }
        class_289.method_1348().method_1350();
        RenderSystem.setShader(() -> prevShader);
    }

    public static void drawBox(Vector3d cam, class_4588 vertexConsumer, class_238 box, float red, float green, float blue, float alpha) {
        float minX = (float)(box.field_1323 - cam.x);
        float minY = (float)(box.field_1322 - cam.y);
        float minZ = (float)(box.field_1321 - cam.z);
        float maxX = (float)(box.field_1320 - cam.x);
        float maxY = (float)(box.field_1325 - cam.y);
        float maxZ = (float)(box.field_1324 - cam.z);
        vertexConsumer.method_22912((double)minX, (double)minY, (double)minZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)maxX, (double)minY, (double)minZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)minX, (double)minY, (double)minZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)minX, (double)maxY, (double)minZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)minX, (double)minY, (double)minZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)minX, (double)minY, (double)maxZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)maxX, (double)minY, (double)minZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)maxX, (double)maxY, (double)minZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)maxX, (double)maxY, (double)minZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)minX, (double)maxY, (double)minZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)minX, (double)maxY, (double)minZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)minX, (double)maxY, (double)maxZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)minX, (double)maxY, (double)maxZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)minX, (double)minY, (double)maxZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)minX, (double)minY, (double)maxZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)maxX, (double)minY, (double)maxZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)maxX, (double)minY, (double)maxZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)maxX, (double)minY, (double)minZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)minX, (double)maxY, (double)maxZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)maxX, (double)maxY, (double)maxZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)maxX, (double)minY, (double)maxZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)maxX, (double)maxY, (double)maxZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)maxX, (double)maxY, (double)minZ).method_22915(red, green, blue, alpha).method_1344();
        vertexConsumer.method_22912((double)maxX, (double)maxY, (double)maxZ).method_22915(red, green, blue, alpha).method_1344();
    }

    public static File writeDebugTrace(DebugTrace snapshot) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HHmmss");
        String name = String.format("debug-trace-%s.zip", dateFormat.format(new Date()));
        Path path = Path.of("./better-clouds/", name);
        File file = path.toFile();
        try {
            file.getParentFile().mkdirs();
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            Main.LOGGER.error("Failed to write debug snapshot: ", (Throwable)e);
            return null;
        }
        try (FileOutputStream fos = new FileOutputStream(path.toFile());
             ZipOutputStream zip = new ZipOutputStream(fos);){
            zip.setLevel(8);
            Debug.writeDebugTrace(snapshot, zip);
        }
        catch (Exception e) {
            file.delete();
            Main.LOGGER.error("Failed to write debug snapshot: ", (Throwable)e);
            return null;
        }
        return file;
    }

    public static void writeDebugTrace(DebugTrace snapshot, ZipOutputStream zip) throws IOException {
        zip.putNextEntry(new ZipEntry("log.txt"));
        StringBuilder logText = new StringBuilder();
        ImmutableList log = ImmutableList.copyOf(snapshot.log);
        for (DebugTrace.Record record : log) {
            logText.append(record.description());
            logText.append("\n");
        }
        zip.write(logText.toString().getBytes(StandardCharsets.UTF_8));
        int frame = 0;
        for (DebugTrace.Record record : log) {
            if (record instanceof DebugTrace.FrameRecord) {
                DebugTrace.FrameRecord frameRecord = (DebugTrace.FrameRecord)record;
                frame = frameRecord.nr();
            }
            if (!record.hasAttachment()) continue;
            zip.putNextEntry(new ZipEntry(String.format("%03d-%s", frame, record.attachmentName())));
            record.writeAttachment(zip);
        }
        zip.close();
    }

    public static DebugTrace captureDebugTrace(Consumer<DebugTrace> onFinish) {
        DebugTrace snapshot = new DebugTrace(onFinish);
        Main.glCompat.debugMessageControl(4352, 4352, 4352, null, true);
        Main.glCompat.enableDebugOutputSynchronous();
        Main.glCompat.debugMessageCallback(snapshot::recordGlMessage);
        return snapshot;
    }

    public static class DebugTrace {
        public boolean captureEvents = true;
        public boolean captureFramebuffers = true;
        public boolean captureTextures = true;
        public boolean captureGlMessages = true;
        private final AtomicBoolean recording = new AtomicBoolean();
        private final AtomicBoolean finished = new AtomicBoolean();
        private int frame = 0;
        public final List<Record> log = new ArrayList<Record>();
        private final Consumer<DebugTrace> onFinish;

        public DebugTrace(Consumer<DebugTrace> onFinish) {
            this.onFinish = onFinish;
        }

        public void startRecording() {
            if (this.finished.get()) {
                return;
            }
            if (this.recording.getAndSet(true)) {
                return;
            }
            trace = Optional.of(this);
        }

        public void stopRecording() {
            if (!this.recording.getAndSet(false)) {
                return;
            }
            if (this.finished.getAndSet(true)) {
                return;
            }
            trace = Optional.empty();
            this.onFinish.accept(this);
        }

        public int getRecordedFrames() {
            return this.frame;
        }

        public boolean isRecording() {
            return this.recording.get();
        }

        public void recordFrame() {
            if (!this.recording.get()) {
                return;
            }
            ++this.frame;
            this.log.add(new FrameRecord(this.frame));
        }

        public void recordEvent(String name) {
            if (!this.recording.get()) {
                return;
            }
            if (!this.captureEvents) {
                return;
            }
            this.log.add(new EventRecord(name));
        }

        public void recordFramebuffer(String name, int id) {
            int attachmentId;
            int type;
            if (!this.recording.get()) {
                return;
            }
            if (!this.captureFramebuffers) {
                return;
            }
            if (!this.captureTextures) {
                return;
            }
            GL32.glBindFramebuffer((int)36008, (int)id);
            for (int i = 0; i < GL32.glGetInteger((int)36063); ++i) {
                type = GL32.glGetFramebufferAttachmentParameteri((int)36008, (int)(36064 + i), (int)36048);
                if (type != 5890 || (attachmentId = GL32.glGetFramebufferAttachmentParameteri((int)36008, (int)(36064 + i), (int)36049)) <= 0) continue;
                this.recordRGBATexture2D(String.format("%s-color%d", name, i), attachmentId);
            }
            type = GL32.glGetFramebufferAttachmentParameteri((int)36008, (int)36096, (int)36048);
            attachmentId = GL32.glGetFramebufferAttachmentParameteri((int)36008, (int)36096, (int)36049);
            if (type == 5890 && attachmentId > 0) {
                RenderSystem.bindTexture((int)attachmentId);
                GL32.glBindTexture((int)3553, (int)attachmentId);
                int width = GL32.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
                int height = GL32.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
                ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                GL32.glGetTexImage((int)3553, (int)0, (int)6402, (int)5126, (ByteBuffer)buffer);
                this.log.add(new TextureRecord(String.format("%s-depth", name), width, height, 1, buffer));
            }
        }

        public void recordRGBATexture2D(String name, int id) {
            if (!this.recording.get()) {
                return;
            }
            if (!this.captureTextures) {
                return;
            }
            RenderSystem.bindTexture((int)id);
            GL32.glBindTexture((int)3553, (int)id);
            int width = GL32.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int height = GL32.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * 4 * 4));
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            GL32.glGetTexImage((int)3553, (int)0, (int)6408, (int)5126, (ByteBuffer)buffer);
            this.log.add(new TextureRecord(name, width, height, 4, buffer));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void recordGlMessage(int source, int type, int id, int severity, int length, long messagePointer, long userParam) {
            if (!this.recording.get()) {
                return;
            }
            if (!this.captureGlMessages) {
                return;
            }
            List<Record> list = this.log;
            synchronized (list) {
                String message = GLDebugMessageCallback.getMessage((int)length, (long)messagePointer);
                this.log.add(new DebugMessageRecord(source, type, id, severity, message));
            }
        }

        public record FrameRecord(int nr) implements Record
        {
            @Override
            @NotNull
            public String description() {
                return String.format("frame: %d", this.nr);
            }
        }

        public record EventRecord(String name) implements Record
        {
            @Override
            @NotNull
            public String description() {
                return String.format("event: %s", this.name);
            }
        }

        public record TextureRecord(String name, int width, int height, int channels, ByteBuffer buffer) implements Record
        {
            @Override
            @NotNull
            public String description() {
                return String.format("texture: %s", this.name);
            }

            @Override
            public boolean hasAttachment() {
                return true;
            }

            @Override
            public String attachmentName() {
                return String.format("texture-%s.f32", this.name.replaceAll("\\s+", "-").replaceAll("[^A-Za-z0-9_-]", ""));
            }

            @Override
            public void writeAttachment(OutputStream out) throws IOException {
                WritableByteChannel channel = Channels.newChannel(out);
                ByteBuffer header = ByteBuffer.wrap(new byte[12]);
                header.order(ByteOrder.LITTLE_ENDIAN);
                IntBuffer intHeader = header.asIntBuffer();
                intHeader.put(this.width);
                intHeader.put(this.height);
                intHeader.put(this.channels);
                channel.write(header);
                channel.write(this.buffer);
            }
        }

        public record DebugMessageRecord(int source, int type, int id, int severity, String message) implements Record
        {
            @Override
            @NotNull
            public String description() {
                return String.format("debug_message: [%s] %s #%d from %s: %s", class_1008.method_4226((int)this.severity), class_1008.method_4228((int)this.type), this.id, class_1008.method_4222((int)this.source), this.message);
            }
        }

        public static interface Record {
            @NotNull
            public String description();

            default public boolean hasAttachment() {
                return false;
            }

            default public String attachmentName() {
                return null;
            }

            default public void writeAttachment(OutputStream out) throws IOException {
                throw new NotImplementedException();
            }
        }
    }
}

