/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds;

import com.mojang.brigadier.CommandDispatcher;
import com.qendolin.betterclouds.Commands;
import com.qendolin.betterclouds.Config;
import com.qendolin.betterclouds.NamedLogger;
import com.qendolin.betterclouds.ShaderPresetLoader;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.compat.GLCompat;
import com.qendolin.betterclouds.compat.Telemetry;
import dev.isxander.yacl.config.GsonConfigInstance;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.impl.util.version.StringVersion;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.opengl.GL32;

public class Main
implements ClientModInitializer {
    public static final String MODID = "betterclouds";
    public static final boolean IS_DEV = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static final boolean IS_CLIENT = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    public static final NamedLogger LOGGER = new NamedLogger(LogManager.getLogger((String)"betterclouds"), !IS_DEV);
    public static GLCompat glCompat;
    public static Version version;
    private static final Path CONFIG_PATH;
    private static final GsonConfigInstance<Config> CONFIG;

    public static void initGlCompat() {
        try {
            glCompat = new GLCompat(IS_DEV);
        }
        catch (Exception e) {
            Telemetry.INSTANCE.sendUnhandledException(e);
            throw e;
        }
        if (glCompat.isIncompatible()) {
            LOGGER.warn("Your GPU is not compatible with Better Clouds. Try updating your drivers?");
            LOGGER.info(" - Vendor:       {}", GL32.glGetString((int)7936));
            LOGGER.info(" - Renderer:     {}", GL32.glGetString((int)7937));
            LOGGER.info(" - GL Version:   {}", GL32.glGetString((int)7938));
            LOGGER.info(" - GLSL Version: {}", GL32.glGetString((int)35724));
            LOGGER.info(" - Extensions:   {}", String.join((CharSequence)", ", Main.glCompat.supportedCheckedExtensions));
            LOGGER.info(" - Functions:    {}", String.join((CharSequence)", ", Main.glCompat.supportedCheckedFunctions));
        } else if (glCompat.isPartiallyIncompatible()) {
            LOGGER.warn("Your GPU is not fully compatible with Better Clouds.");
            for (String fallback : Main.glCompat.usedFallbacks) {
                LOGGER.info("- Using {} fallback", fallback);
            }
        }
        if (Main.getConfig().lastTelemetryVersion < 2) {
            Telemetry.INSTANCE.sendSystemInfo().whenComplete((success, throwable) -> {
                class_310 client = class_310.method_1551();
                if (success.booleanValue() && client != null) {
                    client.execute(() -> {
                        Main.getConfig().lastTelemetryVersion = 2;
                        CONFIG.save();
                    });
                }
            });
        }
    }

    public static Config getConfig() {
        return (Config)CONFIG.getConfig();
    }

    public static boolean isProfilingEnabled() {
        return Debug.profileInterval > 0;
    }

    public static void debugChatMessage(String id, Object ... args) {
        Main.debugChatMessage((class_2561)class_2561.method_43469((String)Main.debugChatMessageKey(id), (Object[])args));
    }

    public static void debugChatMessage(class_2561 message) {
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1687 == null) {
            return;
        }
        client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43470((String)"\u00a7e[\u00a7bBC\u00a7b\u00a7e]\u00a7r ").method_10852(message));
    }

    public static String debugChatMessageKey(String id) {
        return "betterclouds.message." + id;
    }

    public static Version getVersion() {
        return version;
    }

    public static GsonConfigInstance<Config> getConfigInstance() {
        return CONFIG;
    }

    public void onInitializeClient() {
        if (!IS_CLIENT) {
            throw new IllegalStateException("Fabric environment is " + FabricLoader.getInstance().getEnvironmentType().name() + " but onInitializeClient was called");
        }
        this.loadConfig();
        ModContainer mod = FabricLoader.getInstance().getModContainer(MODID).orElse(null);
        version = mod != null ? mod.getMetadata().getVersion() : new StringVersion("unknown");
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> glCompat.enableDebugOutputSynchronousDev());
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (glCompat.isIncompatible()) {
                CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS).execute(() -> client.execute(Main::sendGpuIncompatibleChatMessage));
            } else if (glCompat.isPartiallyIncompatible()) {
                CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS).execute(() -> client.execute(Main::sendGpuPartiallyIncompatibleChatMessage));
            }
        });
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)ShaderPresetLoader.INSTANCE);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> Commands.register((CommandDispatcher<FabricClientCommandSource>)dispatcher));
        if (!IS_DEV) {
            return;
        }
        LOGGER.info("Initialized in dev mode, performance might vary");
    }

    private void loadConfig() {
        try {
            CONFIG.load();
            return;
        }
        catch (Exception loadException) {
            LOGGER.error("Failed to load config: ", (Throwable)loadException);
            File file = CONFIG.getPath().toFile();
            if (file.exists() && file.isFile()) {
                String backupName = FilenameUtils.getBaseName((String)file.getName()) + "-backup-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + "." + FilenameUtils.getExtension((String)file.getName());
                Path backup = Path.of(CONFIG.getPath().toAbsolutePath().getParent().toString(), backupName);
                try {
                    Files.copy(file.toPath(), backup, StandardCopyOption.REPLACE_EXISTING);
                    LOGGER.info("Created config backup at: {}", backup);
                }
                catch (Exception backupException) {
                    LOGGER.error("Failed to create config backup: ", (Throwable)backupException);
                }
            } else if (file.exists()) {
                file.delete();
                LOGGER.info("Deleted old config");
            }
            try {
                CONFIG.save();
                LOGGER.info("Created new config");
                CONFIG.load();
            }
            catch (Exception loadException2) {
                LOGGER.error("Failed to load config again, please report this issue: ", (Throwable)loadException2);
            }
            return;
        }
    }

    public static void sendGpuIncompatibleChatMessage() {
        if (!Main.getConfig().gpuIncompatibleMessageEnabled) {
            return;
        }
        Main.debugChatMessage((class_2561)class_2561.method_43471((String)Main.debugChatMessageKey("gpuIncompatible")).method_10852((class_2561)class_2561.method_43470((String)"\n - ")).method_10852((class_2561)class_2561.method_43471((String)Main.debugChatMessageKey("disable")).method_27694(style -> style.method_10978(Boolean.valueOf(true)).method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1080).method_10958(new class_2558(class_2558.class_2559.field_11750, "/betterclouds:config gpuIncompatibleMessage false")))));
    }

    public static void sendGpuPartiallyIncompatibleChatMessage() {
        if (!Main.getConfig().gpuIncompatibleMessageEnabled) {
            return;
        }
        Main.debugChatMessage((class_2561)class_2561.method_43471((String)Main.debugChatMessageKey("gpuPartiallyIncompatible")).method_10852((class_2561)class_2561.method_43470((String)"\n - ")).method_10852((class_2561)class_2561.method_43471((String)Main.debugChatMessageKey("disable")).method_27694(style -> style.method_10978(Boolean.valueOf(true)).method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1080).method_10958(new class_2558(class_2558.class_2559.field_11750, "/betterclouds:config gpuIncompatibleMessage false")))));
    }

    static {
        CONFIG_PATH = Path.of("config/betterclouds-v1.json", new String[0]);
        CONFIG = new GsonConfigInstance(Config.class, CONFIG_PATH);
    }
}

