/*
 * Decompiled with CFR 0.152.
 */
package eu.asangarin.arikeys.util;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_3675;

public enum ModifierKey {
    NONE(-1, -1),
    LEFT_CTRL(4, 341),
    LEFT_SHIFT(0, 340),
    LEFT_ALT(2, 342),
    RIGHT_CTRL(5, 345),
    RIGHT_SHIFT(1, 344),
    RIGHT_ALT(3, 346);

    public static final ModifierKey[] ALL;
    private final int id;
    private final int code;
    private final class_3675.class_306 key;
    private final String translationKey;

    private ModifierKey(int id, int code) {
        this.id = id;
        this.code = code;
        this.key = class_3675.class_307.field_1668.method_1447(code);
        this.translationKey = "arikeys.modifier." + this.name().toLowerCase();
    }

    public static Set<ModifierKey> getFromArray(int[] modifiers) {
        HashSet<ModifierKey> keys = new HashSet<ModifierKey>();
        for (int i : modifiers) {
            ModifierKey key = ModifierKey.fromCode(i);
            if (key == NONE) continue;
            keys.add(key);
        }
        return keys;
    }

    private static ModifierKey fromCode(int i) {
        for (ModifierKey key : ALL) {
            if (key.id != i) continue;
            return key;
        }
        return NONE;
    }

    public int getId() {
        return this.id;
    }

    public int getCode() {
        return this.code;
    }

    public class_3675.class_306 getKey() {
        return this.key;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    static {
        ALL = new ModifierKey[]{LEFT_CTRL, LEFT_SHIFT, LEFT_ALT, RIGHT_CTRL, RIGHT_SHIFT, RIGHT_ALT};
    }
}

