/*
 * Decompiled with CFR 0.152.
 */
package eu.asangarin.arikeys.util;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.io.Files;
import eu.asangarin.arikeys.AriKey;
import eu.asangarin.arikeys.AriKeys;
import eu.asangarin.arikeys.util.ModifierKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.class_2487;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AriKeysIO {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':').limit(2);
    private static final File KEYBIND_FILE = new File(class_310.method_1551().field_1697, "arikeys.txt");

    public static void load() {
        try {
            if (!KEYBIND_FILE.exists()) {
                return;
            }
            class_2487 nbtCompound = new class_2487();
            try (BufferedReader bufferedReader = Files.newReader((File)KEYBIND_FILE, (Charset)Charsets.UTF_8);){
                bufferedReader.lines().forEach(line -> {
                    try {
                        Iterator iterator = COLON_SPLITTER.split((CharSequence)line).iterator();
                        nbtCompound.method_10582((String)iterator.next(), (String)iterator.next());
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Skipping bad option: {}", line);
                    }
                });
            }
            for (AriKey ariKey : AriKeys.getKeybinds()) {
                String key = "arikey_" + ariKey.getId().toString().replace(":", "+");
                String defKey = ariKey.getBoundKeyCode().method_1441();
                String keybind = (String)MoreObjects.firstNonNull((Object)(nbtCompound.method_10545(key) ? nbtCompound.method_10558(key) : null), (Object)defKey);
                HashSet<ModifierKey> modifiers = new HashSet<ModifierKey>(ariKey.getModifiers());
                for (ModifierKey modifier : ModifierKey.ALL) {
                    String modKey = key + "_" + modifier.getId();
                    if (nbtCompound.method_10545(modKey)) {
                        modifiers.add(modifier);
                        continue;
                    }
                    modifiers.remove((Object)modifier);
                }
                if (defKey.equals(keybind) && modifiers.containsAll(ariKey.getModifiers())) continue;
                ariKey.setBoundKey(class_3675.method_15981((String)keybind), false);
                ariKey.setBoundModifiers(modifiers);
            }
            class_304.method_1426();
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load arikeys bindings", (Throwable)exception);
        }
    }

    public static void save() {
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(KEYBIND_FILE), StandardCharsets.UTF_8));){
            for (AriKey ariKey : AriKeys.getKeybinds()) {
                printWriter.print("arikey_" + ariKey.getId().toString().replace(":", "+"));
                printWriter.print(':');
                printWriter.println(ariKey.getBoundKeyCode().method_1441());
                for (ModifierKey modifier : ariKey.getBoundModifiers()) {
                    printWriter.print("arikey_" + ariKey.getId().toString().replace(":", "+") + "_" + modifier.getId());
                    printWriter.print(':');
                    printWriter.println("true");
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save arikeys bindings", (Throwable)exception);
        }
    }
}

