/*
 * Decompiled with CFR 0.152.
 */
package eu.asangarin.arikeys;

import eu.asangarin.arikeys.util.ModifierKey;
import eu.asangarin.arikeys.util.network.KeyAddData;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class AriKey {
    private final class_2960 id;
    private final String name;
    private final String category;
    private final class_3675.class_306 keyCode;
    private class_3675.class_306 boundKeyCode;
    private final Set<ModifierKey> modifiers;
    private Set<ModifierKey> boundModifiers;

    public AriKey(KeyAddData data) {
        this(data.getId(), data.getName(), data.getCategory(), class_3675.class_307.field_1668.method_1447(data.getDefKey()), data.getModifiers());
    }

    public AriKey(class_2960 id, String name, String category, class_3675.class_306 keyCode, int[] modifiers) {
        this.id = id;
        this.name = name;
        this.category = category;
        this.keyCode = keyCode;
        this.boundKeyCode = keyCode;
        this.modifiers = ModifierKey.getFromArray(modifiers);
        this.boundModifiers = new HashSet<ModifierKey>(this.modifiers);
    }

    public void setBoundKey(class_3675.class_306 key, boolean handleModifiers) {
        if (handleModifiers) {
            HashSet<ModifierKey> mods = new HashSet<ModifierKey>();
            for (ModifierKey modifier : ModifierKey.ALL) {
                if (!class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)modifier.getCode())) continue;
                mods.add(modifier);
            }
            this.setBoundModifiers(mods);
        }
        this.boundKeyCode = key;
    }

    public void setBoundModifiers(Set<ModifierKey> modifiers) {
        this.boundModifiers = modifiers;
    }

    public void resetBoundModifiers() {
        this.setBoundModifiers(new HashSet<ModifierKey>(this.modifiers));
    }

    public boolean hasChanged() {
        return !this.keyCode.equals((Object)this.boundKeyCode) || !this.testModifiers(this.modifiers);
    }

    public boolean isUnbound() {
        return this.boundKeyCode.equals((Object)class_3675.field_16237);
    }

    public boolean testModifiers() {
        for (ModifierKey key : this.boundModifiers) {
            if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)key.getCode())) continue;
            return false;
        }
        return true;
    }

    public boolean testModifiers(Set<ModifierKey> otherKeys) {
        return this.boundModifiers.containsAll(otherKeys) && otherKeys.containsAll(this.boundModifiers);
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public class_3675.class_306 getKeyCode() {
        return this.keyCode;
    }

    public class_3675.class_306 getBoundKeyCode() {
        return this.boundKeyCode;
    }

    public Set<ModifierKey> getModifiers() {
        return this.modifiers;
    }

    public Set<ModifierKey> getBoundModifiers() {
        return this.boundModifiers;
    }
}

