/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.registries;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface RegistrySupplier<T>
extends Supplier<T> {
    public RegistrarManager getRegistrarManager();

    public Registrar<T> getRegistrar();

    public class_2960 getRegistryId();

    default public class_5321<class_2378<T>> getRegistryKey() {
        return class_5321.method_29180((class_2960)this.getRegistryId());
    }

    public class_2960 getId();

    public boolean isPresent();

    @Nullable
    default public T getOrNull() {
        if (this.isPresent()) {
            return this.get();
        }
        return null;
    }

    default public Optional<T> toOptional() {
        return Optional.ofNullable(this.getOrNull());
    }

    default public void ifPresent(Consumer<? super T> action) {
        if (this.isPresent()) {
            action.accept(this.get());
        }
    }

    default public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        if (this.isPresent()) {
            action.accept(this.get());
        } else {
            emptyAction.run();
        }
    }

    default public Stream<T> stream() {
        if (!this.isPresent()) {
            return Stream.empty();
        }
        return Stream.of(this.get());
    }

    default public T orElse(T other) {
        return this.isPresent() ? this.get() : other;
    }

    default public T orElseGet(Supplier<? extends T> supplier) {
        return this.isPresent() ? this.get() : supplier.get();
    }

    default public void listen(Consumer<T> callback) {
        this.getRegistrar().listen(this, callback);
    }
}

