/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.animatica.animation.bakery;

import com.google.common.collect.ImmutableList;
import io.github.foundationgames.animatica.Animatica;
import io.github.foundationgames.animatica.animation.AnimationMeta;
import io.github.foundationgames.animatica.util.TextureUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3532;

public class AnimationBakery
implements AutoCloseable {
    public final Baking[] anims;
    private final class_1011 target;
    private int frame = 0;
    private final Deque<class_2960> frameIds = new ArrayDeque<class_2960>();
    private final class_2960 targetTexId;

    public AnimationBakery(class_3300 resources, class_2960 targetTex, List<AnimationMeta> metas) throws IOException {
        this.anims = new Baking[metas.size()];
        for (int i = 0; i < metas.size(); ++i) {
            this.anims[i] = new Baking(metas.get(i), resources);
        }
        try (InputStream target = resources.getResourceOrThrow(targetTex).method_14482();){
            this.target = class_1011.method_4309((InputStream)target);
        }
        this.targetTexId = targetTex;
    }

    public boolean hasNext() {
        for (Baking anim : this.anims) {
            if (anim.isOnFrameZero()) continue;
            return true;
        }
        return false;
    }

    public void advance() {
        class_1060 textures = class_310.method_1551().method_1531();
        boolean changed = this.frame <= 0;
        for (Baking anim : this.anims) {
            if (!anim.isChanged()) continue;
            changed = true;
            break;
        }
        if (changed) {
            class_1011 frameImg = new class_1011(this.target.method_4318(), this.target.method_4307(), this.target.method_4323(), false);
            frameImg.method_4317(this.target);
            for (Baking anim : this.anims) {
                Phase phase = anim.getCurrentPhase();
                if (phase instanceof InterpolatedPhase) {
                    InterpolatedPhase iPhase = (InterpolatedPhase)phase;
                    TextureUtil.blendCopy(anim.sourceTexture, 0, iPhase.prevV, 0, iPhase.v, anim.width, anim.height, frameImg, anim.targetX, anim.targetY, iPhase.blend.getBlend(anim.getPhaseFrame()));
                    continue;
                }
                TextureUtil.copy(anim.sourceTexture, 0, phase.v, anim.width, anim.height, frameImg, anim.targetX, anim.targetY);
            }
            class_2960 id = new class_2960(this.targetTexId.method_12836(), this.targetTexId.method_12832() + ".anim" + this.frameIds.size());
            textures.method_4616(id, (class_1044)new class_1043(frameImg));
            this.frameIds.addLast(id);
        } else {
            this.frameIds.addLast(this.frameIds.getLast());
        }
        for (Baking anim : this.anims) {
            anim.advance();
        }
        ++this.frame;
    }

    public class_2960[] bakeAndUpload() {
        int i = -1;
        do {
            this.advance();
        } while (this.hasNext() && (Animatica.CONFIG.maxAnimFrames == null || ++i < Animatica.CONFIG.maxAnimFrames));
        class_2960[] ids = new class_2960[this.frameIds.size()];
        this.frameIds.toArray(ids);
        return ids;
    }

    @Override
    public void close() {
        for (Baking anim : this.anims) {
            anim.close();
        }
        this.target.close();
    }

    public static class Baking
    implements AutoCloseable {
        private final List<Phase> phases;
        public final class_1011 sourceTexture;
        public final int targetX;
        public final int targetY;
        public final int width;
        public final int height;
        private final int duration;
        private int frame = 0;
        private Phase currentPhase = null;
        private int phaseFrame = 0;
        private boolean changed = true;

        public Baking(AnimationMeta meta, class_3300 resources) throws IOException {
            this.targetX = meta.targetX();
            this.targetY = meta.targetY();
            this.width = meta.width();
            this.height = meta.height();
            try (InputStream source = resources.getResourceOrThrow(meta.source()).method_14482();){
                this.sourceTexture = class_1011.method_4309((InputStream)source);
            }
            ImmutableList.Builder phases = ImmutableList.builder();
            int duration = 0;
            int textureFrameCount = (int)Math.floor((float)this.sourceTexture.method_4323() / (float)meta.height());
            int animFrameCount = Math.max(textureFrameCount, meta.getGreatestUsedFrame() + 1);
            ArrayList<int[]> frames = new ArrayList<int[]>();
            for (int f = 0; f < animFrameCount; ++f) {
                if (f >= textureFrameCount && !meta.frameMapping().containsKey(f)) continue;
                frames.add(new int[]{meta.frameMapping().getOrDefault(f, f), meta.frameDurations().getOrDefault(f, meta.defaultFrameDuration())});
            }
            for (int i = 0; i < frames.size(); ++i) {
                int[] frame = (int[])frames.get(i);
                int fMap = frame[0];
                int fDuration = frame[1];
                int v = this.getVForFrame(fMap, textureFrameCount);
                int nextV = this.getVForFrame(((int[])frames.get(Math.floorMod(i + 1, frames.size())))[0], textureFrameCount);
                if (meta.interpolate()) {
                    if (meta.interpolationDelay() > 0) {
                        phases.add((Object)new Phase(meta.interpolationDelay(), v));
                        duration += meta.interpolationDelay();
                    }
                    int interpolatedDuration = fDuration - meta.interpolationDelay();
                    phases.add((Object)new InterpolatedPhase(interpolatedDuration, v, nextV, phaseFrame -> (float)phaseFrame / (float)interpolatedDuration));
                    duration += interpolatedDuration;
                    continue;
                }
                phases.add((Object)new Phase(fDuration, v));
                duration += fDuration;
            }
            this.duration = duration;
            this.phases = phases.build();
            this.updateCurrentPhase();
        }

        public void updateCurrentPhase() {
            this.changed = false;
            int progress = this.frame;
            for (Phase phase : this.phases) {
                if ((progress -= phase.duration) >= 0) continue;
                if (this.currentPhase != phase) {
                    this.changed = true;
                }
                if (phase instanceof InterpolatedPhase) {
                    InterpolatedPhase iPhase = (InterpolatedPhase)phase;
                    this.changed = iPhase.hasChangingV();
                }
                this.currentPhase = phase;
                this.phaseFrame = phase.duration + progress;
                return;
            }
        }

        public Phase getCurrentPhase() {
            return this.currentPhase;
        }

        public int getPhaseFrame() {
            return this.phaseFrame;
        }

        public boolean isOnFrameZero() {
            return this.frame <= 0;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void advance() {
            ++this.frame;
            if (this.frame >= this.duration) {
                this.frame = 0;
            }
            this.updateCurrentPhase();
        }

        @Override
        public void close() {
            this.sourceTexture.close();
        }

        private int getVForFrame(int frame, int textureFrameCount) {
            return class_3532.method_15340((int)(frame * this.height), (int)0, (int)((textureFrameCount - 1) * this.height));
        }
    }

    public static class Phase {
        public final int duration;
        public final int v;

        public Phase(int duration, int v) {
            this.duration = duration;
            this.v = v;
        }

        public String toString() {
            return "Animation Bakery Phase { v: " + this.v + " }";
        }
    }

    public static class InterpolatedPhase
    extends Phase {
        public final int prevV;
        public final BlendInterpolator blend;

        public InterpolatedPhase(int duration, int v1, int v2, BlendInterpolator blend) {
            super(duration, v2);
            this.prevV = v1;
            this.blend = blend;
        }

        public boolean hasChangingV() {
            return this.prevV != this.v;
        }
    }

    @FunctionalInterface
    public static interface BlendInterpolator {
        public float getBlend(int var1);
    }
}

