/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.animatica.animation;

import io.github.foundationgames.animatica.Animatica;
import io.github.foundationgames.animatica.animation.AnimationMeta;
import io.github.foundationgames.animatica.animation.BakedTextureAnimation;
import io.github.foundationgames.animatica.util.Flags;
import io.github.foundationgames.animatica.util.Utilities;
import io.github.foundationgames.animatica.util.exception.PropertyParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public final class AnimationLoader
implements SimpleSynchronousResourceReloadListener {
    public static final String[] ANIM_PATHS = new String[]{"animatica/anim", "mcpatcher/anim", "optifine/anim"};
    private static final class_2960 ID = Animatica.id("animation_storage");
    public static final AnimationLoader INSTANCE = new AnimationLoader();
    private final Map<class_2960, BakedTextureAnimation> animatedTextures = new HashMap<class_2960, BakedTextureAnimation>();

    private AnimationLoader() {
    }

    private static void findAllMCPAnimations(class_3300 manager, BiConsumer<class_2960, class_3298> action) {
        for (String path : ANIM_PATHS) {
            manager.method_14488(path, p -> p.method_12832().endsWith(".properties")).forEach(action);
        }
    }

    public BakedTextureAnimation getAnimation(class_2960 id) {
        return this.animatedTextures.get(id);
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public void method_14491(class_3300 manager) {
        if (!Animatica.CONFIG.animatedTextures) {
            this.animatedTextures.clear();
            return;
        }
        Flags.ALLOW_INVALID_ID_CHARS = true;
        this.animatedTextures.clear();
        HashMap animations = new HashMap();
        AnimationLoader.findAllMCPAnimations(manager, (id, resource) -> {
            try (InputStream resourceInputStream = resource.method_14482();){
                Properties ppt = new Properties();
                ppt.load(resourceInputStream);
                AnimationMeta anim = AnimationMeta.of(id, ppt);
                class_2960 targetId = anim.target();
                if (!animations.containsKey(targetId)) {
                    animations.put(targetId, new ArrayList());
                }
                ((List)animations.get(targetId)).add(anim);
            }
            catch (PropertyParseException | IOException e) {
                Animatica.LOG.error(e.getMessage());
            }
        });
        int[] totalSize = new int[]{0};
        for (class_2960 targetId : animations.keySet()) {
            if (Animatica.CONFIG.safeMode) {
                try {
                    AnimationLoader.debugAnimation(totalSize, manager, targetId, (List)animations.get(targetId));
                }
                catch (IOException e) {
                    Animatica.LOG.error("Error printing Safe Mode debug for animation {}\n {}: {}", (Object)targetId, (Object)e.getClass().getName(), (Object)e.getMessage());
                }
                continue;
            }
            this.animatedTextures.put(targetId, BakedTextureAnimation.bake(manager, targetId, (List)animations.get(targetId)));
        }
        if (Animatica.CONFIG.safeMode) {
            Animatica.LOG.info("=== ESTIMATED TOTAL ANIMATION SIZE: {} BYTES ===", (Object)totalSize[0]);
        }
        Flags.ALLOW_INVALID_ID_CHARS = false;
    }

    public static void debugAnimation(int[] totalSize, class_3300 manager, class_2960 targetTex, List<AnimationMeta> anims) throws IOException {
        int bytesPerPix;
        int frameHeight;
        int frameWidth;
        int[] frameCounts;
        block21: {
            frameCounts = new int[anims.size()];
            Optional targetTexRes = manager.method_14486(targetTex);
            if (targetTexRes.isPresent()) {
                try (InputStream target = ((class_3298)targetTexRes.get()).method_14482();
                     class_1011 img = class_1011.method_4309((InputStream)target);){
                    frameWidth = img.method_4307();
                    frameHeight = img.method_4323();
                    bytesPerPix = img.method_4318().method_4335();
                    break block21;
                }
            }
            throw new FileNotFoundException(targetTex.toString());
        }
        for (int i = 0; i < anims.size(); ++i) {
            AnimationMeta meta = anims.get(i);
            Optional sourceTexRes = manager.method_14486(meta.source());
            if (sourceTexRes.isPresent()) {
                try (InputStream source = ((class_3298)sourceTexRes.get()).method_14482();){
                    class_1011 tex = class_1011.method_4309((InputStream)source);
                    frameCounts[i] = Math.max((int)Math.floor((float)tex.method_4323() / (float)meta.height()), meta.getGreatestUsedFrame() + 1);
                    continue;
                }
            }
            throw new FileNotFoundException(meta.source().toString());
        }
        int frameCount = Utilities.lcm(frameCounts);
        int animSizeEstimate = frameWidth * frameHeight * bytesPerPix * frameCount;
        totalSize[0] = totalSize[0] + animSizeEstimate;
        Animatica.LOG.info("--- ANIMATION DEBUG FOR TEXTURE '{}' ---", (Object)targetTex.toString());
        Animatica.LOG.info(" - Total Compiled Frame Count: {}", (Object)frameCount);
        Animatica.LOG.info(" - Frame Dimensions: {}px by {}px", (Object)frameWidth, (Object)frameHeight);
        Animatica.LOG.info(" - Estimated Animation Size: {} BYTES", (Object)animSizeEstimate);
    }
}

