/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dev.isxander.yacl.api.Binding;
import dev.isxander.yacl.api.Controller;
import dev.isxander.yacl.api.ListOption;
import dev.isxander.yacl.api.ListOptionEntry;
import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.api.OptionFlag;
import dev.isxander.yacl.impl.ListOptionEntryImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
@ApiStatus.Internal
public final class ListOptionImpl<T>
implements ListOption<T> {
    private final class_2561 name;
    private final class_2561 tooltip;
    private final Binding<List<T>> binding;
    private final T initialValue;
    private final List<ListOptionEntry<T>> entries;
    private final boolean collapsed;
    private boolean available;
    private final Class<T> typeClass;
    private final ImmutableSet<OptionFlag> flags;
    private final EntryFactory entryFactory;
    private final List<BiConsumer<Option<List<T>>, List<T>>> listeners;
    private final List<Runnable> refreshListeners;

    public ListOptionImpl(@NotNull class_2561 name, @NotNull class_2561 tooltip, @NotNull Binding<List<T>> binding, @NotNull T initialValue, @NotNull Class<T> typeClass, @NotNull Function<ListOptionEntry<T>, Controller<T>> controllerFunction, ImmutableSet<OptionFlag> flags, boolean collapsed, boolean available) {
        this.name = name;
        this.tooltip = tooltip;
        this.binding = binding;
        this.initialValue = initialValue;
        this.entryFactory = new EntryFactory(controllerFunction);
        this.entries = this.createEntries((Collection)this.binding().getValue());
        this.collapsed = collapsed;
        this.typeClass = typeClass;
        this.flags = flags;
        this.available = available;
        this.listeners = new ArrayList<BiConsumer<Option<List<T>>, List<T>>>();
        this.refreshListeners = new ArrayList<Runnable>();
        this.callListeners();
    }

    @Override
    @NotNull
    public class_2561 name() {
        return this.name;
    }

    @Override
    @NotNull
    public class_2561 tooltip() {
        return this.tooltip;
    }

    @Override
    @NotNull
    public ImmutableList<ListOptionEntry<T>> options() {
        return ImmutableList.copyOf(this.entries);
    }

    @Override
    @NotNull
    public Controller<List<T>> controller() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Binding<List<T>> binding() {
        return this.binding;
    }

    @Override
    @NotNull
    public Class<List<T>> typeClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Class<T> elementTypeClass() {
        return this.typeClass;
    }

    @Override
    public boolean collapsed() {
        return this.collapsed;
    }

    @Override
    @NotNull
    public ImmutableSet<OptionFlag> flags() {
        return this.flags;
    }

    @Override
    @NotNull
    public ImmutableList<T> pendingValue() {
        return ImmutableList.copyOf(this.entries.stream().map(Option::pendingValue).toList());
    }

    @Override
    public void insertEntry(int index, ListOptionEntry<?> entry) {
        this.entries.add(index, entry);
        this.onRefresh();
    }

    @Override
    public ListOptionEntry<T> insertNewEntryToTop() {
        ListOptionEntry newEntry = this.entryFactory.create(this.initialValue);
        this.entries.add(0, newEntry);
        this.onRefresh();
        return newEntry;
    }

    @Override
    public void removeEntry(ListOptionEntry<?> entry) {
        if (this.entries.remove(entry)) {
            this.onRefresh();
        }
    }

    @Override
    public int indexOf(ListOptionEntry<?> entry) {
        return this.entries.indexOf(entry);
    }

    @Override
    public void requestSet(List<T> value) {
        this.entries.clear();
        this.entries.addAll(this.createEntries(value));
        this.onRefresh();
    }

    @Override
    public boolean changed() {
        return !this.binding().getValue().equals(this.pendingValue());
    }

    @Override
    public boolean applyValue() {
        if (this.changed()) {
            this.binding().setValue((List<ImmutableList<T>>)this.pendingValue());
            return true;
        }
        return false;
    }

    @Override
    public void forgetPendingValue() {
        this.requestSet(this.binding().getValue());
    }

    @Override
    public void requestSetDefault() {
        this.requestSet(this.binding().defaultValue());
    }

    @Override
    public boolean isPendingValueDefault() {
        return this.binding().defaultValue().equals(this.pendingValue());
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    public void addListener(BiConsumer<Option<List<T>>, List<T>> changedListener) {
        this.listeners.add(changedListener);
    }

    @Override
    public void addRefreshListener(Runnable changedListener) {
        this.refreshListeners.add(changedListener);
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    private List<ListOptionEntry<T>> createEntries(Collection<T> values) {
        return values.stream().map(this.entryFactory::create).collect(Collectors.toList());
    }

    void callListeners() {
        ImmutableList<T> pendingValue = this.pendingValue();
        this.listeners.forEach(listener -> listener.accept(this, pendingValue));
    }

    private void onRefresh() {
        this.refreshListeners.forEach(Runnable::run);
        this.callListeners();
    }

    @Environment(value=EnvType.CLIENT)
    private class EntryFactory {
        private final Function<ListOptionEntry<T>, Controller<T>> controllerFunction;

        private EntryFactory(Function<ListOptionEntry<T>, Controller<T>> controllerFunction) {
            this.controllerFunction = controllerFunction;
        }

        public ListOptionEntry<T> create(T initialValue) {
            return new ListOptionEntryImpl(ListOptionImpl.this, initialValue, this.controllerFunction);
        }
    }

    @Environment(value=EnvType.CLIENT)
    @ApiStatus.Internal
    public static final class BuilderImpl<T>
    implements ListOption.Builder<T> {
        private class_2561 name = class_2561.method_43473();
        private final List<class_2561> tooltipLines = new ArrayList<class_2561>();
        private Function<ListOptionEntry<T>, Controller<T>> controllerFunction;
        private Binding<List<T>> binding = null;
        private final Set<OptionFlag> flags = new HashSet<OptionFlag>();
        private T initialValue;
        private boolean collapsed = false;
        private boolean available = true;
        private final Class<T> typeClass;

        public BuilderImpl(Class<T> typeClass) {
            this.typeClass = typeClass;
        }

        @Override
        public ListOption.Builder<T> name(@NotNull class_2561 name) {
            Validate.notNull((Object)name, (String)"`name` must not be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        @Override
        public ListOption.Builder<T> tooltip(class_2561 ... tooltips) {
            Validate.notEmpty((Object[])tooltips, (String)"`tooltips` cannot be empty", (Object[])new Object[0]);
            this.tooltipLines.addAll(List.of(tooltips));
            return this;
        }

        @Override
        public ListOption.Builder<T> initial(@NotNull T initialValue) {
            Validate.notNull(initialValue, (String)"`initialValue` cannot be empty", (Object[])new Object[0]);
            this.initialValue = initialValue;
            return this;
        }

        @Override
        public ListOption.Builder<T> controller(@NotNull Function<ListOptionEntry<T>, Controller<T>> control) {
            Validate.notNull(control, (String)"`control` cannot be null", (Object[])new Object[0]);
            this.controllerFunction = control;
            return this;
        }

        @Override
        public ListOption.Builder<T> binding(@NotNull Binding<List<T>> binding) {
            Validate.notNull(binding, (String)"`binding` cannot be null", (Object[])new Object[0]);
            this.binding = binding;
            return this;
        }

        @Override
        public ListOption.Builder<T> binding(@NotNull List<T> def, @NotNull @NotNull Supplier<@NotNull List<T>> getter, @NotNull @NotNull Consumer<@NotNull List<T>> setter) {
            Validate.notNull(def, (String)"`def` must not be null", (Object[])new Object[0]);
            Validate.notNull(getter, (String)"`getter` must not be null", (Object[])new Object[0]);
            Validate.notNull(setter, (String)"`setter` must not be null", (Object[])new Object[0]);
            this.binding = Binding.generic(def, getter, setter);
            return this;
        }

        @Override
        public ListOption.Builder<T> available(boolean available) {
            this.available = available;
            return this;
        }

        @Override
        public ListOption.Builder<T> flag(OptionFlag ... flag) {
            Validate.notNull((Object)flag, (String)"`flag` must not be null", (Object[])new Object[0]);
            this.flags.addAll(Arrays.asList(flag));
            return this;
        }

        @Override
        public ListOption.Builder<T> flags(@NotNull Collection<OptionFlag> flags) {
            Validate.notNull(flags, (String)"`flags` must not be null", (Object[])new Object[0]);
            this.flags.addAll(flags);
            return this;
        }

        @Override
        public ListOption.Builder<T> collapsed(boolean collapsible) {
            this.collapsed = collapsible;
            return this;
        }

        @Override
        public ListOption<T> build() {
            Validate.notNull(this.controllerFunction, (String)"`controller` must not be null", (Object[])new Object[0]);
            Validate.notNull(this.binding, (String)"`binding` must not be null", (Object[])new Object[0]);
            Validate.notNull(this.initialValue, (String)"`initialValue` must not be null", (Object[])new Object[0]);
            class_5250 concatenatedTooltip = class_2561.method_43473();
            boolean first = true;
            for (class_2561 line : this.tooltipLines) {
                if (!first) {
                    concatenatedTooltip.method_27693("\n");
                }
                first = false;
                concatenatedTooltip.method_10852(line);
            }
            return new ListOptionImpl<T>(this.name, (class_2561)concatenatedTooltip, this.binding, this.initialValue, this.typeClass, this.controllerFunction, (ImmutableSet<OptionFlag>)ImmutableSet.copyOf(this.flags), this.collapsed, this.available);
        }
    }
}

