/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.gui.controllers.string.number;

import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.api.utils.Dimension;
import dev.isxander.yacl.gui.AbstractWidget;
import dev.isxander.yacl.gui.YACLScreen;
import dev.isxander.yacl.gui.controllers.slider.ISliderController;
import dev.isxander.yacl.gui.controllers.string.IStringController;
import dev.isxander.yacl.gui.controllers.string.StringControllerElement;
import java.text.DecimalFormatSymbols;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public abstract class NumberFieldController<T extends Number>
implements ISliderController<T>,
IStringController<T> {
    private final Option<T> option;
    private final Function<T, class_2561> displayFormatter;

    public NumberFieldController(Option<T> option, Function<T, class_2561> displayFormatter) {
        this.option = option;
        this.displayFormatter = displayFormatter;
    }

    @Override
    public Option<T> option() {
        return this.option;
    }

    @Override
    public void setFromString(String value) {
        if (value.isEmpty() || value.equals(".") || value.equals("-")) {
            value = "0";
        }
        this.setPendingValue(class_3532.method_15350((double)Double.parseDouble(this.cleanupNumberString(value)), (double)this.min(), (double)this.max()));
    }

    @Override
    public double pendingValue() {
        return ((Number)this.option().pendingValue()).doubleValue();
    }

    @Override
    public boolean isInputValid(String input) {
        return input.matches("[+-]?([0-9]+([.][0-9]*)?|[.][0-9]+)|[.]||-");
    }

    @Override
    public class_2561 formatValue() {
        return this.displayFormatter.apply((Number)this.option().pendingValue());
    }

    @Override
    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new StringControllerElement(this, screen, widgetDimension, false);
    }

    protected String cleanupNumberString(String number) {
        return number.replace(String.valueOf(DecimalFormatSymbols.getInstance().getGroupingSeparator()), "");
    }

    @Override
    public double interval() {
        return -1.0;
    }
}

