/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.gui.controllers.string;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.isxander.yacl.api.utils.Dimension;
import dev.isxander.yacl.gui.YACLScreen;
import dev.isxander.yacl.gui.controllers.ControllerWidget;
import dev.isxander.yacl.gui.controllers.string.IStringController;
import dev.isxander.yacl.gui.utils.GuiUtils;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class StringControllerElement
extends ControllerWidget<IStringController<?>> {
    protected final boolean instantApply;
    protected String inputField;
    protected Dimension<Integer> inputFieldBounds;
    protected boolean inputFieldFocused;
    protected int caretPos;
    protected int selectionLength;
    protected int renderOffset;
    protected float ticks;
    private final class_2561 emptyText;

    public StringControllerElement(IStringController<?> control, YACLScreen screen, Dimension<Integer> dim, boolean instantApply) {
        super(control, screen, dim);
        this.instantApply = instantApply;
        this.inputField = control.getString();
        this.inputFieldFocused = false;
        this.selectionLength = 0;
        this.emptyText = class_2561.method_43470((String)"Click to type...").method_27692(class_124.field_1080);
        control.option().addListener((opt, val) -> {
            this.inputField = control.getString();
        });
        this.setDimension(dim);
    }

    @Override
    protected void drawHoveredControl(class_4587 matrices, int mouseX, int mouseY, float delta) {
    }

    @Override
    protected void drawValueText(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_2561 valueText = this.getValueText();
        if (!this.isHovered()) {
            valueText = class_2561.method_43470((String)GuiUtils.shortenString(valueText.getString(), this.textRenderer, this.getMaxUnwrapLength(), "...")).method_10862(valueText.method_10866());
        }
        matrices.method_22903();
        int textX = this.getDimension().xLimit() - this.textRenderer.method_27525((class_5348)valueText) + this.renderOffset - this.getXPadding();
        matrices.method_46416((float)textX, this.getTextY(), 0.0f);
        GuiUtils.enableScissor(this.inputFieldBounds.x(), this.inputFieldBounds.y() - 2, this.inputFieldBounds.width() + 1, this.inputFieldBounds.height() + 4);
        this.textRenderer.method_30881(matrices, valueText, 0.0f, 0.0f, this.getValueColor());
        matrices.method_22909();
        if (this.isHovered()) {
            this.ticks += delta;
            String text = this.getValueText().getString();
            class_332.method_25294((class_4587)matrices, (int)this.inputFieldBounds.x(), (int)this.inputFieldBounds.yLimit(), (int)this.inputFieldBounds.xLimit(), (int)(this.inputFieldBounds.yLimit() + 1), (int)-1);
            class_332.method_25294((class_4587)matrices, (int)(this.inputFieldBounds.x() + 1), (int)(this.inputFieldBounds.yLimit() + 1), (int)(this.inputFieldBounds.xLimit() + 1), (int)(this.inputFieldBounds.yLimit() + 2), (int)-12566464);
            if (this.inputFieldFocused || this.focused) {
                int caretX = textX + this.textRenderer.method_1727(text.substring(0, this.caretPos)) - 1;
                if (text.isEmpty()) {
                    caretX = this.inputFieldBounds.x() + this.inputFieldBounds.width() / 2;
                }
                if (this.ticks % 20.0f <= 10.0f) {
                    class_332.method_25294((class_4587)matrices, (int)caretX, (int)this.inputFieldBounds.y(), (int)(caretX + 1), (int)this.inputFieldBounds.yLimit(), (int)-1);
                }
                if (this.selectionLength != 0) {
                    int selectionX = textX + this.textRenderer.method_1727(text.substring(0, this.caretPos + this.selectionLength));
                    class_332.method_25294((class_4587)matrices, (int)caretX, (int)(this.inputFieldBounds.y() - 1), (int)selectionX, (int)this.inputFieldBounds.yLimit(), (int)-2144325377);
                }
            }
        }
        RenderSystem.disableScissor();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isAvailable() && this.getDimension().isPointInside((int)mouseX, (int)mouseY)) {
            this.inputFieldFocused = true;
            if (!this.inputFieldBounds.isPointInside((int)mouseX, (int)mouseY)) {
                this.caretPos = this.getDefaultCaretPos();
            } else {
                int textX = (int)mouseX - (this.inputFieldBounds.xLimit() - this.textRenderer.method_27525((class_5348)this.getValueText()));
                int pos = -1;
                int currentWidth = 0;
                for (char ch : this.inputField.toCharArray()) {
                    ++pos;
                    int charLength = this.textRenderer.method_1727(String.valueOf(ch));
                    if (currentWidth + charLength / 2 > textX) {
                        this.caretPos = pos;
                        break;
                    }
                    if (pos == this.inputField.length() - 1) {
                        this.caretPos = pos + 1;
                    }
                    currentWidth += charLength;
                }
                this.selectionLength = 0;
            }
            return true;
        }
        this.inputFieldFocused = false;
        return false;
    }

    protected int getDefaultCaretPos() {
        return this.inputField.length();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.inputFieldFocused) {
            return false;
        }
        switch (keyCode) {
            case 256: 
            case 257: {
                this.unfocus();
                return true;
            }
            case 263: {
                if (class_437.method_25442()) {
                    if (class_437.method_25441()) {
                        int spaceChar = this.findSpaceIndex(true);
                        this.selectionLength += this.caretPos - spaceChar;
                        this.caretPos = spaceChar;
                    } else if (this.caretPos > 0) {
                        --this.caretPos;
                        ++this.selectionLength;
                    }
                    this.checkRenderOffset();
                } else {
                    if (this.caretPos > 0) {
                        this.caretPos = this.selectionLength != 0 ? (this.caretPos += Math.min(this.selectionLength, 0)) : --this.caretPos;
                    }
                    this.checkRenderOffset();
                    this.selectionLength = 0;
                }
                return true;
            }
            case 262: {
                if (class_437.method_25442()) {
                    if (class_437.method_25441()) {
                        int spaceChar = this.findSpaceIndex(false);
                        this.selectionLength -= spaceChar - this.caretPos;
                        this.caretPos = spaceChar;
                    } else if (this.caretPos < this.inputField.length()) {
                        ++this.caretPos;
                        --this.selectionLength;
                    }
                    this.checkRenderOffset();
                } else {
                    if (this.caretPos < this.inputField.length()) {
                        this.caretPos = this.selectionLength != 0 ? (this.caretPos += Math.max(this.selectionLength, 0)) : ++this.caretPos;
                        this.checkRenderOffset();
                    }
                    this.selectionLength = 0;
                }
                return true;
            }
            case 259: {
                this.doBackspace();
                return true;
            }
            case 261: {
                this.doDelete();
                return true;
            }
        }
        if (class_437.method_25437((int)keyCode)) {
            return this.doPaste();
        }
        if (class_437.method_25438((int)keyCode)) {
            return this.doCopy();
        }
        if (class_437.method_25436((int)keyCode)) {
            return this.doCut();
        }
        if (class_437.method_25439((int)keyCode)) {
            return this.doSelectAll();
        }
        return false;
    }

    protected boolean doPaste() {
        this.write(this.client.field_1774.method_1460());
        return true;
    }

    protected boolean doCopy() {
        if (this.selectionLength != 0) {
            this.client.field_1774.method_1455(this.getSelection());
            return true;
        }
        return false;
    }

    protected boolean doCut() {
        if (this.selectionLength != 0) {
            this.client.field_1774.method_1455(this.getSelection());
            this.write("");
            return true;
        }
        return false;
    }

    protected boolean doSelectAll() {
        this.caretPos = this.inputField.length();
        this.checkRenderOffset();
        this.selectionLength = -this.caretPos;
        return true;
    }

    protected void checkRenderOffset() {
        if (this.textRenderer.method_1727(this.inputField) < this.getUnshiftedLength()) {
            this.renderOffset = 0;
            return;
        }
        int textX = this.getDimension().xLimit() - this.textRenderer.method_1727(this.inputField) - this.getXPadding();
        int caretX = textX + this.textRenderer.method_1727(this.inputField.substring(0, this.caretPos)) - 1;
        int minX = this.getDimension().xLimit() - this.getXPadding() - this.getUnshiftedLength();
        int maxX = minX + this.getUnshiftedLength();
        if (caretX + this.renderOffset < minX) {
            this.renderOffset = minX - caretX;
        } else if (caretX + this.renderOffset > maxX) {
            this.renderOffset = maxX - caretX;
        }
    }

    public boolean method_25400(char chr, int modifiers) {
        if (!this.inputFieldFocused) {
            return false;
        }
        this.write(Character.toString(chr));
        return true;
    }

    protected void doBackspace() {
        if (this.selectionLength != 0) {
            this.write("");
        } else if (this.caretPos > 0 && this.modifyInput(builder -> builder.deleteCharAt(this.caretPos - 1))) {
            --this.caretPos;
            this.checkRenderOffset();
        }
    }

    protected void doDelete() {
        if (this.selectionLength != 0) {
            this.write("");
        } else if (this.caretPos < this.inputField.length()) {
            this.modifyInput(builder -> builder.deleteCharAt(this.caretPos));
        }
    }

    public void write(String string) {
        if (this.selectionLength == 0) {
            if (this.modifyInput(builder -> builder.insert(this.caretPos, string))) {
                this.caretPos += string.length();
                this.checkRenderOffset();
            }
        } else {
            int end;
            int start = this.getSelectionStart();
            if (this.modifyInput(arg_0 -> StringControllerElement.lambda$write$4(start, end = this.getSelectionEnd(), string, arg_0))) {
                this.caretPos = start + string.length();
                this.selectionLength = 0;
                this.checkRenderOffset();
            }
        }
    }

    public boolean modifyInput(Consumer<StringBuilder> consumer) {
        StringBuilder temp = new StringBuilder(this.inputField);
        consumer.accept(temp);
        if (!((IStringController)this.control).isInputValid(temp.toString())) {
            return false;
        }
        this.inputField = temp.toString();
        if (this.instantApply) {
            this.updateControl();
        }
        return true;
    }

    public int getUnshiftedLength() {
        if (this.optionNameString.isEmpty()) {
            return this.getDimension().width() - this.getXPadding() * 2;
        }
        return this.getDimension().width() / 8 * 5;
    }

    public int getMaxUnwrapLength() {
        if (this.optionNameString.isEmpty()) {
            return this.getDimension().width() - this.getXPadding() * 2;
        }
        return this.getDimension().width() / 2;
    }

    public int getSelectionStart() {
        return Math.min(this.caretPos, this.caretPos + this.selectionLength);
    }

    public int getSelectionEnd() {
        return Math.max(this.caretPos, this.caretPos + this.selectionLength);
    }

    protected String getSelection() {
        return this.inputField.substring(this.getSelectionStart(), this.getSelectionEnd());
    }

    protected int findSpaceIndex(boolean reverse) {
        int i;
        int fromIndex = this.caretPos;
        if (reverse) {
            if (this.caretPos > 0) {
                --fromIndex;
            }
            if ((i = this.inputField.lastIndexOf(" ", fromIndex)) == -1) {
                i = 0;
            }
        } else {
            if (this.caretPos < this.inputField.length()) {
                ++fromIndex;
            }
            if ((i = this.inputField.indexOf(" ", fromIndex)) == -1) {
                i = this.inputField.length();
            }
        }
        return i;
    }

    @Override
    public boolean method_25407(boolean lookForwards) {
        this.inputFieldFocused = super.method_25407(lookForwards);
        return this.inputFieldFocused;
    }

    @Override
    public void unfocus() {
        super.unfocus();
        this.inputFieldFocused = false;
        this.renderOffset = 0;
        if (!this.instantApply) {
            this.updateControl();
        }
    }

    @Override
    public void setDimension(Dimension<Integer> dim) {
        super.setDimension(dim);
        int width = Math.max(6, Math.min(this.textRenderer.method_27525((class_5348)this.getValueText()), this.getUnshiftedLength()));
        int n = dim.xLimit() - this.getXPadding() - width;
        int n2 = dim.centerY();
        Objects.requireNonNull(this.textRenderer);
        int n3 = n2 - 9 / 2;
        Objects.requireNonNull(this.textRenderer);
        this.inputFieldBounds = Dimension.ofInt(n, n3, width, 9);
    }

    @Override
    public boolean isHovered() {
        return super.isHovered() || this.inputFieldFocused;
    }

    protected void updateControl() {
        ((IStringController)this.control).setFromString(this.inputField);
    }

    @Override
    protected int getUnhoveredControlWidth() {
        return !this.isHovered() ? Math.min(this.getHoveredControlWidth(), this.getMaxUnwrapLength()) : this.getHoveredControlWidth();
    }

    @Override
    protected int getHoveredControlWidth() {
        return Math.min(this.textRenderer.method_27525((class_5348)this.getValueText()), this.getUnshiftedLength());
    }

    @Override
    protected class_2561 getValueText() {
        if (!this.inputFieldFocused && this.inputField.isEmpty()) {
            return this.emptyText;
        }
        return this.instantApply || !this.inputFieldFocused ? ((IStringController)this.control).formatValue() : class_2561.method_30163((String)this.inputField);
    }

    private static /* synthetic */ void lambda$write$4(int start, int end, String string, StringBuilder builder) {
        builder.replace(start, end, string);
    }
}

