/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.gui.controllers.slider;

import dev.isxander.yacl.api.utils.Dimension;
import dev.isxander.yacl.gui.YACLScreen;
import dev.isxander.yacl.gui.controllers.ControllerWidget;
import dev.isxander.yacl.gui.controllers.slider.ISliderController;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class SliderControllerElement
extends ControllerWidget<ISliderController<?>> {
    private final double min;
    private final double max;
    private final double interval;
    private float interpolation;
    private Dimension<Integer> sliderBounds;
    private boolean mouseDown = false;

    public SliderControllerElement(ISliderController<?> option, YACLScreen screen, Dimension<Integer> dim, double min, double max, double interval) {
        super(option, screen, dim);
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.setDimension(dim);
    }

    @Override
    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.calculateInterpolation();
    }

    @Override
    protected void drawHoveredControl(class_4587 matrices, int mouseX, int mouseY, float delta) {
        class_332.method_25294((class_4587)matrices, (int)this.sliderBounds.x(), (int)(this.sliderBounds.centerY() - 1), (int)this.sliderBounds.xLimit(), (int)this.sliderBounds.centerY(), (int)-1);
        class_332.method_25294((class_4587)matrices, (int)(this.sliderBounds.x() + 1), (int)this.sliderBounds.centerY(), (int)(this.sliderBounds.xLimit() + 1), (int)(this.sliderBounds.centerY() + 1), (int)-12566464);
        class_332.method_25294((class_4587)matrices, (int)(this.getThumbX() - this.getThumbWidth() / 2 + 1), (int)(this.sliderBounds.y() + 1), (int)(this.getThumbX() + this.getThumbWidth() / 2 + 1), (int)(this.sliderBounds.yLimit() + 1), (int)-12566464);
        class_332.method_25294((class_4587)matrices, (int)(this.getThumbX() - this.getThumbWidth() / 2), (int)this.sliderBounds.y(), (int)(this.getThumbX() + this.getThumbWidth() / 2), (int)this.sliderBounds.yLimit(), (int)-1);
    }

    @Override
    protected void drawValueText(class_4587 matrices, int mouseX, int mouseY, float delta) {
        matrices.method_22903();
        if (this.isHovered()) {
            matrices.method_46416(-((float)(this.sliderBounds.width() + 6) + (float)this.getThumbWidth() / 2.0f), 0.0f, 0.0f);
        }
        super.drawValueText(matrices, mouseX, mouseY, delta);
        matrices.method_22909();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.isAvailable() || button != 0 || !this.sliderBounds.isPointInside((int)mouseX, (int)mouseY)) {
            return false;
        }
        this.mouseDown = true;
        this.setValueFromMouse(mouseX);
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isAvailable() || button != 0 || !this.mouseDown) {
            return false;
        }
        this.setValueFromMouse(mouseX);
        return true;
    }

    public void incrementValue(double amount) {
        ((ISliderController)this.control).setPendingValue(class_3532.method_15350((double)(((ISliderController)this.control).pendingValue() + this.interval * amount), (double)this.min, (double)this.max));
        this.calculateInterpolation();
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!this.isAvailable() || !this.method_25405(mouseX, mouseY) || !class_437.method_25442() && !class_437.method_25441()) {
            return false;
        }
        this.incrementValue(amount);
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.isAvailable() && this.mouseDown) {
            this.playDownSound();
        }
        this.mouseDown = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.focused) {
            return false;
        }
        switch (keyCode) {
            case 263: 
            case 264: {
                this.incrementValue(-1.0);
                break;
            }
            case 262: 
            case 265: {
                this.incrementValue(1.0);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return super.method_25405(mouseX, mouseY) || this.mouseDown;
    }

    protected void setValueFromMouse(double mouseX) {
        double value = (mouseX - (double)this.sliderBounds.x().intValue()) / (double)this.sliderBounds.width().intValue() * ((ISliderController)this.control).range();
        ((ISliderController)this.control).setPendingValue(this.roundToInterval(value));
        this.calculateInterpolation();
    }

    protected double roundToInterval(double value) {
        return class_3532.method_15350((double)(this.min + this.interval * (double)Math.round(value / this.interval)), (double)this.min, (double)this.max);
    }

    @Override
    protected int getHoveredControlWidth() {
        return this.sliderBounds.width() + this.getUnhoveredControlWidth() + 6 + this.getThumbWidth() / 2;
    }

    protected void calculateInterpolation() {
        this.interpolation = class_3532.method_15363((float)((float)((((ISliderController)this.control).pendingValue() - ((ISliderController)this.control).min()) * 1.0 / ((ISliderController)this.control).range())), (float)0.0f, (float)1.0f);
    }

    @Override
    public void setDimension(Dimension<Integer> dim) {
        super.setDimension(dim);
        int trackWidth = dim.width() / 3;
        if (this.optionNameString.isEmpty()) {
            trackWidth = dim.width() / 2;
        }
        this.sliderBounds = Dimension.ofInt(dim.xLimit() - this.getXPadding() - this.getThumbWidth() / 2 - trackWidth, dim.centerY() - 5, trackWidth, 10);
    }

    protected int getThumbX() {
        return (int)((float)this.sliderBounds.x().intValue() + (float)this.sliderBounds.width().intValue() * this.interpolation);
    }

    protected int getThumbWidth() {
        return 4;
    }

    @Override
    public void postRender(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (super.method_25405(mouseX, mouseY)) {
            super.postRender(matrices, mouseX, mouseY, delta);
        }
    }
}

