/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.gui.controllers.slider;

import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.gui.controllers.slider.ISliderController;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import org.apache.commons.lang3.Validate;

@Environment(value=EnvType.CLIENT)
public class LongSliderController
implements ISliderController<Long> {
    public static final Function<Long, class_2561> DEFAULT_FORMATTER = value -> class_2561.method_30163((String)String.format("%,d", value).replaceAll("[\u00a0\u202f]", " "));
    private final Option<Long> option;
    private final long min;
    private final long max;
    private final long interval;
    private final Function<Long, class_2561> valueFormatter;

    public LongSliderController(Option<Long> option, long min, long max, long interval) {
        this(option, min, max, interval, DEFAULT_FORMATTER);
    }

    public LongSliderController(Option<Long> option, long min, long max, long interval, Function<Long, class_2561> valueFormatter) {
        Validate.isTrue((max > min ? 1 : 0) != 0, (String)"`max` cannot be smaller than `min`", (Object[])new Object[0]);
        Validate.isTrue((interval > 0L ? 1 : 0) != 0, (String)"`interval` must be more than 0", (Object[])new Object[0]);
        Validate.notNull(valueFormatter, (String)"`valueFormatter` must not be null", (Object[])new Object[0]);
        this.option = option;
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.valueFormatter = valueFormatter;
    }

    @Override
    public Option<Long> option() {
        return this.option;
    }

    @Override
    public class_2561 formatValue() {
        return this.valueFormatter.apply(this.option().pendingValue());
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double max() {
        return this.max;
    }

    @Override
    public double interval() {
        return this.interval;
    }

    @Override
    public void setPendingValue(double value) {
        this.option().requestSet((long)value);
    }

    @Override
    public double pendingValue() {
        return this.option().pendingValue().longValue();
    }
}

