/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.gui.controllers;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.api.utils.Dimension;
import dev.isxander.yacl.api.utils.MutableDimension;
import dev.isxander.yacl.gui.AbstractWidget;
import dev.isxander.yacl.gui.YACLScreen;
import dev.isxander.yacl.gui.controllers.string.IStringController;
import dev.isxander.yacl.gui.controllers.string.StringControllerElement;
import java.awt.Color;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class ColorController
implements IStringController<Color> {
    private final Option<Color> option;
    private final boolean allowAlpha;

    public ColorController(Option<Color> option) {
        this(option, false);
    }

    public ColorController(Option<Color> option, boolean allowAlpha) {
        this.option = option;
        this.allowAlpha = allowAlpha;
    }

    @Override
    public Option<Color> option() {
        return this.option;
    }

    public boolean allowAlpha() {
        return this.allowAlpha;
    }

    @Override
    public String getString() {
        return this.formatValue().getString();
    }

    @Override
    public class_2561 formatValue() {
        class_5250 text = class_2561.method_43470((String)"#");
        text.method_10852((class_2561)class_2561.method_43470((String)this.toHex(this.option().pendingValue().getRed())).method_27692(class_124.field_1061));
        text.method_10852((class_2561)class_2561.method_43470((String)this.toHex(this.option().pendingValue().getGreen())).method_27692(class_124.field_1060));
        text.method_10852((class_2561)class_2561.method_43470((String)this.toHex(this.option().pendingValue().getBlue())).method_27692(class_124.field_1078));
        if (this.allowAlpha()) {
            text.method_27693(this.toHex(this.option().pendingValue().getAlpha()));
        }
        return text;
    }

    private String toHex(int value) {
        Object hex = Integer.toString(value, 16).toUpperCase();
        if (((String)hex).length() == 1) {
            hex = "0" + (String)hex;
        }
        return hex;
    }

    @Override
    public void setFromString(String value) {
        if (value.startsWith("#")) {
            value = value.substring(1);
        }
        int red = Integer.parseInt(value.substring(0, 2), 16);
        int green = Integer.parseInt(value.substring(2, 4), 16);
        int blue = Integer.parseInt(value.substring(4, 6), 16);
        if (this.allowAlpha()) {
            int alpha = Integer.parseInt(value.substring(6, 8), 16);
            this.option().requestSet(new Color(red, green, blue, alpha));
        } else {
            this.option().requestSet(new Color(red, green, blue));
        }
    }

    @Override
    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new ColorControllerElement(this, screen, widgetDimension);
    }

    @Environment(value=EnvType.CLIENT)
    public static class ColorControllerElement
    extends StringControllerElement {
        private final ColorController colorController;
        protected MutableDimension<Integer> colorPreviewDim;
        private final List<Character> allowedChars;

        public ColorControllerElement(ColorController control, YACLScreen screen, Dimension<Integer> dim) {
            super(control, screen, dim, true);
            this.colorController = control;
            this.allowedChars = ImmutableList.of((Object)Character.valueOf('0'), (Object)Character.valueOf('1'), (Object)Character.valueOf('2'), (Object)Character.valueOf('3'), (Object)Character.valueOf('4'), (Object)Character.valueOf('5'), (Object)Character.valueOf('6'), (Object)Character.valueOf('7'), (Object)Character.valueOf('8'), (Object)Character.valueOf('9'), (Object)Character.valueOf('a'), (Object)Character.valueOf('b'), (Object[])new Character[]{Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f')});
        }

        @Override
        protected void drawValueText(class_4587 matrices, int mouseX, int mouseY, float delta) {
            if (this.isHovered()) {
                this.colorPreviewDim.move(-((Integer)this.inputFieldBounds.width()).intValue() - 5, 0);
                super.drawValueText(matrices, mouseX, mouseY, delta);
            }
            class_332.method_25294((class_4587)matrices, (int)((Integer)this.colorPreviewDim.x()), (int)((Integer)this.colorPreviewDim.y()), (int)((Integer)this.colorPreviewDim.xLimit()), (int)((Integer)this.colorPreviewDim.yLimit()), (int)this.colorController.option().pendingValue().getRGB());
            this.drawOutline(matrices, (Integer)this.colorPreviewDim.x(), (Integer)this.colorPreviewDim.y(), (Integer)this.colorPreviewDim.xLimit(), (Integer)this.colorPreviewDim.yLimit(), 1, -16777216);
        }

        @Override
        public void write(String string) {
            if (string.startsWith("0x")) {
                string = string.substring(2);
            }
            for (char chr : string.toCharArray()) {
                if (this.allowedChars.contains(Character.valueOf(Character.toLowerCase(chr)))) continue;
                return;
            }
            if (this.caretPos == 0) {
                return;
            }
            String trimmed = string.substring(0, Math.min(this.inputField.length() - this.caretPos, string.length()));
            if (this.modifyInput(builder -> builder.replace(this.caretPos, this.caretPos + trimmed.length(), trimmed))) {
                this.caretPos += trimmed.length();
                this.setSelectionLength();
                this.updateControl();
            }
        }

        @Override
        protected void doBackspace() {
            if (this.caretPos > 1 && this.modifyInput(builder -> builder.setCharAt(this.caretPos - 1, '0'))) {
                --this.caretPos;
                this.updateControl();
            }
        }

        @Override
        protected void doDelete() {
            if (this.caretPos >= 1 && this.modifyInput(builder -> builder.setCharAt(this.caretPos, '0'))) {
                this.updateControl();
            }
        }

        @Override
        protected boolean doCut() {
            return false;
        }

        @Override
        protected boolean doCopy() {
            return false;
        }

        @Override
        protected boolean doSelectAll() {
            return false;
        }

        protected void setSelectionLength() {
            this.selectionLength = this.caretPos < this.inputField.length() && this.caretPos > 0 ? 1 : 0;
        }

        @Override
        protected int getDefaultCaretPos() {
            return this.colorController.allowAlpha() ? 3 : 1;
        }

        @Override
        public void setDimension(Dimension<Integer> dim) {
            super.setDimension(dim);
            int previewSize = (dim.height() - this.getYPadding() * 2) / 2;
            this.colorPreviewDim = Dimension.ofInt(dim.xLimit() - this.getXPadding() - previewSize, dim.centerY() - previewSize / 2, previewSize, previewSize);
        }

        @Override
        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            int prevSelectionLength = this.selectionLength;
            this.selectionLength = 0;
            if (super.method_25404(keyCode, scanCode, modifiers)) {
                this.caretPos = Math.max(1, this.caretPos);
                this.setSelectionLength();
                return true;
            }
            this.selectionLength = prevSelectionLength;
            return false;
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (super.method_25402(mouseX, mouseY, button)) {
                this.caretPos = Math.max(1, this.caretPos);
                this.setSelectionLength();
                return true;
            }
            return false;
        }
    }
}

