/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.config;

import dev.isxander.yacl.config.ConfigEntry;
import dev.isxander.yacl.config.ConfigInstance;
import dev.isxander.yacl.impl.utils.YACLConstants;
import java.awt.Color;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2507;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

@Deprecated
public class NbtConfigInstance<T>
extends ConfigInstance<T> {
    private final Path path;
    private final boolean compressed;
    private final NbtSerializerHolder nbtSerializerHolder;

    public NbtConfigInstance(Class<T> configClass, Path path) {
        this(configClass, path, holder -> holder, true);
    }

    public NbtConfigInstance(Class<T> configClass, Path path, UnaryOperator<NbtSerializerHolder> serializerHolderBuilder, boolean compressed) {
        super(configClass);
        this.path = path;
        this.compressed = compressed;
        this.nbtSerializerHolder = (NbtSerializerHolder)serializerHolderBuilder.apply(new NbtSerializerHolder());
    }

    @Override
    public void save() {
        class_2487 nbt;
        YACLConstants.LOGGER.info("Saving {}...", (Object)this.getConfigClass().getSimpleName());
        try {
            nbt = (class_2487)NbtConfigInstance.serializeObject(this.getConfig(), this.nbtSerializerHolder, field -> field.isAnnotationPresent(ConfigEntry.class));
        }
        catch (IllegalAccessException e) {
            YACLConstants.LOGGER.error("Failed to convert '{}' -> NBT", (Object)this.getConfigClass().getName(), (Object)e);
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(this.path.toFile());){
            if (Files.notExists(this.path, new LinkOption[0])) {
                Files.createFile(this.path, new FileAttribute[0]);
            }
            if (this.compressed) {
                class_2507.method_10634((class_2487)nbt, (OutputStream)fos);
            } else {
                class_2507.method_10628((class_2487)nbt, (DataOutput)new DataOutputStream(fos));
            }
        }
        catch (IOException e) {
            YACLConstants.LOGGER.error("Failed to write NBT to '{}'", (Object)this.path, (Object)e);
        }
    }

    @Override
    public void load() {
        class_2487 nbt;
        if (Files.notExists(this.path, new LinkOption[0])) {
            this.save();
            return;
        }
        YACLConstants.LOGGER.info("Loading {}...", (Object)this.getConfigClass().getSimpleName());
        try {
            nbt = this.compressed ? class_2507.method_30613((File)this.path.toFile()) : class_2507.method_10633((File)this.path.toFile());
        }
        catch (IOException e) {
            YACLConstants.LOGGER.error("Failed to read NBT file '{}'", (Object)this.path, (Object)e);
            return;
        }
        try {
            this.setConfig(NbtConfigInstance.deserializeObject((class_2520)nbt, this.getConfigClass(), this.nbtSerializerHolder, field -> field.isAnnotationPresent(ConfigEntry.class)));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            YACLConstants.LOGGER.error("Failed to convert NBT -> '{}'", (Object)this.getConfigClass().getName(), (Object)e);
        }
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isUsingCompression() {
        return this.compressed;
    }

    private static class_2520 serializeObject(Object object, NbtSerializerHolder serializerHolder, Predicate<Field> topLevelPredicate) throws IllegalAccessException {
        Field[] fields;
        if (serializerHolder.hasSerializer(object.getClass())) {
            return serializerHolder.serialize(object);
        }
        if (object instanceof Object[]) {
            Object[] ol = (Object[])object;
            class_2499 nbtList = new class_2499();
            for (Object obj : ol) {
                nbtList.add((Object)NbtConfigInstance.serializeObject(obj, serializerHolder, field -> true));
            }
            return nbtList;
        }
        class_2487 compound = new class_2487();
        for (Field field2 : fields = object.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field2.getModifiers()) || !topLevelPredicate.test(field2)) continue;
            System.out.println(field2.getName());
            field2.setAccessible(true);
            String key = NbtConfigInstance.toCamelCase(field2.getName());
            class_2520 value = NbtConfigInstance.serializeObject(field2.get(object), serializerHolder, f -> true);
            compound.method_10566(key, value);
        }
        return compound;
    }

    private static <T> T deserializeObject(class_2520 element, Class<T> type, NbtSerializerHolder serializerHolder, Predicate<Field> topLevelPredicate) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Field[] fields;
        if (serializerHolder.hasSerializer(type)) {
            return serializerHolder.get(type).deserialize(element, type);
        }
        if (type == Array.class) {
            ArrayList list = new ArrayList();
            Class<?> arrayType = Array.newInstance(type.getComponentType(), 0).getClass();
            class_2499 nbtList = (class_2499)element;
            for (class_2520 nbtElement : nbtList) {
                list.add(NbtConfigInstance.deserializeObject(nbtElement, arrayType, serializerHolder, field -> true));
            }
            return (T)list.toArray();
        }
        if (!(element instanceof class_2487)) {
            throw new IllegalStateException("Cannot deserialize " + type.getName());
        }
        class_2487 compound = (class_2487)element;
        T object = type.getConstructor(new Class[0]).newInstance(new Object[0]);
        for (Field field2 : fields = type.getDeclaredFields()) {
            if (Modifier.isStatic(field2.getModifiers()) || !topLevelPredicate.test(field2)) continue;
            field2.setAccessible(true);
            String key = NbtConfigInstance.toCamelCase(field2.getName());
            if (!compound.method_10545(key)) continue;
            field2.set(object, NbtConfigInstance.deserializeObject(compound.method_10580(key), field2.getType(), serializerHolder, f -> true));
        }
        return object;
    }

    private static String toCamelCase(String name) {
        StringBuilder translation = new StringBuilder();
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char character = name.charAt(i);
            if (Character.isUpperCase(character) && translation.length() != 0) {
                translation.append('_');
            }
            translation.append(character);
        }
        return translation.toString().toLowerCase(Locale.ENGLISH);
    }

    public static class NbtSerializerHolder {
        private final Map<Class<?>, NbtSerializer<?>> serializerMap = new HashMap();

        private NbtSerializerHolder() {
            this.register(Boolean.TYPE, NbtSerializer.simple(b -> b != false ? class_2481.field_21027 : class_2481.field_21026, nbt -> nbt.method_10698() != 0));
            this.register(Boolean.class, NbtSerializer.simple(b -> b != false ? class_2481.field_21027 : class_2481.field_21026, nbt -> nbt.method_10698() != 0));
            this.register(Integer.TYPE, NbtSerializer.simple(class_2497::method_23247, class_2497::method_10701));
            this.register(Integer.class, NbtSerializer.simple(class_2497::method_23247, class_2497::method_10701));
            this.register(int[].class, NbtSerializer.simple(class_2495::new, class_2495::method_10588));
            this.register(Float.TYPE, NbtSerializer.simple(class_2494::method_23244, class_2494::method_10700));
            this.register(Float.class, NbtSerializer.simple(class_2494::method_23244, class_2494::method_10700));
            this.register(Double.TYPE, NbtSerializer.simple(class_2489::method_23241, class_2489::method_10697));
            this.register(Double.class, NbtSerializer.simple(class_2489::method_23241, class_2489::method_10697));
            this.register(Short.TYPE, NbtSerializer.simple(class_2516::method_23254, class_2516::method_10696));
            this.register(Short.class, NbtSerializer.simple(class_2516::method_23254, class_2516::method_10696));
            this.register(Byte.TYPE, NbtSerializer.simple(class_2481::method_23233, class_2481::method_10698));
            this.register(Byte.class, NbtSerializer.simple(class_2481::method_23233, class_2481::method_10698));
            this.register(byte[].class, NbtSerializer.simple(class_2479::new, class_2479::method_10521));
            this.register(Long.TYPE, NbtSerializer.simple(class_2503::method_23251, class_2503::method_10699));
            this.register(Long.class, NbtSerializer.simple(class_2503::method_23251, class_2503::method_10699));
            this.register(long[].class, NbtSerializer.simple(class_2501::new, class_2501::method_10615));
            this.register(String.class, NbtSerializer.simple(class_2519::method_23256, class_2519::method_10714));
            this.register(Enum.class, NbtSerializer.simple(e -> class_2519.method_23256((String)e.name()), (nbt, type) -> Arrays.stream((Enum[])type.getEnumConstants()).filter(e -> e.name().equals(nbt.method_10714())).findFirst().orElseThrow()));
            this.register(Color.class, new ColorSerializer());
        }

        public <T> NbtSerializerHolder register(Class<T> clazz, NbtSerializer<T> serializer) {
            this.serializerMap.put(clazz, serializer);
            return this;
        }

        public <T> NbtSerializer<T> get(Class<T> clazz) {
            return this.search(clazz).findFirst().orElseThrow().getValue();
        }

        public boolean hasSerializer(Class<?> clazz) {
            return this.search(clazz).findAny().isPresent();
        }

        public class_2520 serialize(Object object) {
            return this.get(object.getClass()).serialize(object);
        }

        private Stream<Map.Entry<Class<?>, NbtSerializer<?>>> search(Class<?> type) {
            return this.serializerMap.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(type));
        }
    }

    public static interface NbtSerializer<T> {
        public class_2520 serialize(T var1);

        public T deserialize(class_2520 var1, Class<T> var2);

        public static <T, U extends class_2520> NbtSerializer<T> simple(Function<T, U> serializer, Function<U, T> deserializer) {
            return NbtSerializer.simple(serializer, (U nbt, Class<T> type) -> deserializer.apply(nbt));
        }

        public static <T, U extends class_2520> NbtSerializer<T> simple(final Function<T, U> serializer, final BiFunction<U, Class<T>, T> deserializer) {
            return new NbtSerializer<T>(){

                @Override
                public class_2520 serialize(T object) {
                    return (class_2520)serializer.apply(object);
                }

                @Override
                public T deserialize(class_2520 element, Class<T> type) {
                    return deserializer.apply(element, type);
                }
            };
        }
    }

    public static class ColorSerializer
    implements NbtSerializer<Color> {
        @Override
        public class_2520 serialize(Color object) {
            return class_2497.method_23247((int)object.getRGB());
        }

        @Override
        public Color deserialize(class_2520 element, Class<Color> type) {
            return new Color(((class_2497)element).method_10701(), true);
        }
    }
}

