/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.render.shapes;

import java.util.List;
import org.enginehub.worldeditcui.event.listeners.CUIRenderContext;
import org.enginehub.worldeditcui.render.LineStyle;
import org.enginehub.worldeditcui.render.RenderStyle;
import org.enginehub.worldeditcui.render.points.PointRectangle;
import org.enginehub.worldeditcui.render.shapes.RenderRegion;
import org.enginehub.worldeditcui.util.Vector2;

public class Render2DGrid
extends RenderRegion {
    private final List<PointRectangle> points;
    private final int min;
    private final int max;

    public Render2DGrid(RenderStyle style, List<PointRectangle> points, int min, int max) {
        super(style);
        this.points = points;
        this.min = min;
        this.max = max;
    }

    @Override
    public void render(CUIRenderContext ctx) {
        double off = 0.03;
        for (double height = (double)this.min; height <= (double)(this.max + 1); height += 1.0) {
            this.drawPoly(ctx, height + off);
        }
    }

    protected void drawPoly(CUIRenderContext ctx, double height) {
        for (LineStyle line : this.style.getLines()) {
            if (!ctx.apply(line, this.style.getRenderType())) continue;
            ctx.color(line);
            ctx.beginLineLoop();
            for (PointRectangle point : this.points) {
                if (point == null) continue;
                Vector2 pos = point.getPoint();
                double x = pos.getX() - ctx.cameraPos().getX();
                double z = pos.getY() - ctx.cameraPos().getZ();
                ctx.vertex(x + 0.5, height - ctx.cameraPos().getY(), z + 0.5);
            }
            ctx.endLineLoop();
        }
    }
}

