/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.votiverp.mods.xaerosminimap;

import com.zeydie.sgson.SGsonBase;
import com.zeydie.votiverp.VotiveRPMod;
import com.zeydie.votiverp.mods.xaerosminimap.packets.WaypointPacket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Predicate;
import lombok.NonNull;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.minimap.XaeroMinimap;

public final class XaerosMinimap {
    @NotNull
    private static final class_2960 channel = VotiveRPMod.createIdentifier("minimap");
    private static final int VISIBILITY_WORLD_MAP_GLO = 1;

    public static void register() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)channel, (client, handler, buf, responseSender) -> {
            String jsonString = new String(buf.method_36132(), StandardCharsets.UTF_8);
            WaypointPacket waypointPacket = (WaypointPacket)SGsonBase.create().fromJsonToObject(jsonString, (Object)new WaypointPacket());
            XaerosMinimap.handle(waypointPacket);
        });
    }

    public static void handle(@NonNull WaypointPacket packet) {
        WaypointsManager waypointsManager;
        WaypointSet waypointSet;
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        XaeroMinimapSession session = XaeroMinimapSession.getCurrentSession();
        if (session == null) {
            session = XaeroMinimap.INSTANCE.createSession();
        }
        if ((waypointSet = (waypointsManager = session.getWaypointsManager()).getWaypoints()) != null) {
            ArrayList waypoints = waypointSet.getList();
            String name = packet.getName();
            String symbol = packet.getSymbol();
            final int x = packet.getX();
            final int y = packet.getY();
            final int z = packet.getZ();
            int color = packet.getColor();
            boolean active = packet.isActive();
            Waypoint waypoint = new Waypoint(x, y, z, name, symbol, color, 2, true, true);
            waypoint.setVisibilityType(1);
            Predicate<Waypoint> filter = new Predicate<Waypoint>(){

                @Override
                public boolean test(@Nullable Waypoint input) {
                    if (input == null) {
                        return false;
                    }
                    return input.getX() == x && input.getY() == y && input.getZ() == z;
                }
            };
            waypoints.stream().filter(filter).findFirst().ifPresentOrElse(arg_0 -> XaerosMinimap.lambda$handle$1(active, name, symbol, color, waypoints, filter, arg_0), () -> {
                if (active) {
                    waypoints.add(waypoint);
                }
            });
        }
    }

    private static /* synthetic */ void lambda$handle$1(boolean active, String name, String symbol, int color, ArrayList waypoints, 1 filter, Waypoint present) {
        if (active) {
            present.setName(name);
            present.setSymbol(symbol);
            present.setColor(color);
            present.setVisibilityType(1);
        } else {
            waypoints.removeIf(filter);
        }
    }
}

