/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.votiverp.mixins.broadcast;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1060;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_809;
import net.minecraft.class_918;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_918.class})
public abstract class ItemRendererMixin {
    private static final class_2960 BROADCAST_TEXTURE_RED = new class_2960("minecraft", "textures/item/broadcast_red.png");
    private static final class_2960 BROADCAST_TEXTURE_GREEN = new class_2960("minecraft", "textures/item/broadcast_green.png");
    private static final class_2960 BROADCAST_TEXTURE_VIOLET = new class_2960("minecraft", "textures/item/broadcast_violet.png");
    private static final class_2960 BROADCAST_TEXTURE_WANTED = new class_2960("minecraft", "textures/item/broadcast_wanted.png");
    private static final class_2960 BROADCAST_TEXTURE_SHORT = new class_2960("minecraft", "textures/item/broadcast_short.png");
    private static final Map<String, class_2960> imageCache = new ConcurrentHashMap<String, class_2960>();
    private static final Map<String, CompletableFuture<class_1011>> loadingFutures = new ConcurrentHashMap<String, CompletableFuture<class_1011>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/render/model/json/ModelTransformation$Mode;ZLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/client/render/model/BakedModel;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderBroadcastItem(class_1799 stack, class_809.class_811 renderMode, boolean leftHanded, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay, class_1087 model, CallbackInfo ci) {
        if (stack.method_31574(class_1802.field_8407) && stack.method_7985() && stack.method_7969().method_10545("broadcast_text")) {
            float[] startXs;
            int[] lineHeights;
            int[] maxLines;
            int capColor;
            class_2960 texture;
            String text = stack.method_7969().method_10558("broadcast_text");
            String[] parts = text.split("/");
            String btype = stack.method_7969().method_10558("broadcast_type");
            if (btype.isEmpty()) {
                btype = "red";
            }
            float[] startYs = switch (btype) {
                case "green" -> {
                    texture = BROADCAST_TEXTURE_GREEN;
                    capColor = 1133337;
                    maxLines = new int[]{17, 4, 4};
                    lineHeights = new int[]{11, 11, 11};
                    startXs = new float[]{-65.0f, -65.0f, -65.0f};
                    yield new float[]{-81.0f, -25.0f, 27.0f};
                }
                case "violet" -> {
                    texture = BROADCAST_TEXTURE_VIOLET;
                    capColor = 0x4B114B;
                    maxLines = new int[]{17, 4, 4};
                    lineHeights = new int[]{11, 11, 11};
                    startXs = new float[]{-65.0f, -65.0f, -65.0f};
                    yield new float[]{-98.0f, -51.0f, 8.0f};
                }
                case "wanted" -> {
                    texture = BROADCAST_TEXTURE_WANTED;
                    capColor = 0;
                    maxLines = new int[]{2, 2};
                    lineHeights = new int[]{11, 11};
                    startXs = new float[]{-75.0f, -75.0f};
                    yield new float[]{-110.0f, 70.0f};
                }
                case "short" -> {
                    texture = BROADCAST_TEXTURE_SHORT;
                    capColor = 4210230;
                    maxLines = new int[]{7};
                    lineHeights = new int[]{11};
                    startXs = new float[]{-65.0f};
                    yield new float[]{10.0f};
                }
                default -> {
                    texture = BROADCAST_TEXTURE_RED;
                    capColor = 4921617;
                    maxLines = new int[]{17, 4, 4};
                    lineHeights = new int[]{11, 11, 11};
                    startXs = new float[]{-75.0f, -75.0f, -75.0f};
                    yield new float[]{-98.0f, -51.0f, 8.0f};
                }
            };
            int numBlocks = maxLines.length;
            ArrayList<List<Object>> blockLines = new ArrayList<List<Object>>();
            class_327 textRenderer = class_310.method_1551().field_1772;
            int maxWidthPixels = 150;
            int continuousMaxLines = 0;
            for (int ml : maxLines) {
                continuousMaxLines += ml;
            }
            if (parts.length == 1) {
                if (stack.method_7969().method_10545("max_lines")) {
                    continuousMaxLines = stack.method_7969().method_10550("max_lines");
                }
                maxLines = new int[]{continuousMaxLines};
                lineHeights = new int[]{lineHeights[0]};
                startXs = new float[]{startXs[0]};
                startYs = new float[]{startYs[0]};
                numBlocks = 1;
                List<String> allLines = this.wrapText(parts[0].trim(), maxWidthPixels, textRenderer);
                ArrayList<String> thisBlock = new ArrayList<String>();
                for (int l = 0; l < continuousMaxLines && l < allLines.size(); ++l) {
                    thisBlock.add(allLines.get(l));
                }
                blockLines.add(thisBlock);
            } else {
                int maxParts = Math.min(parts.length, numBlocks);
                for (int b = 0; b < maxParts; ++b) {
                    List<String> lines = this.wrapText(parts[b].trim(), maxWidthPixels, textRenderer);
                    blockLines.add(lines);
                }
            }
            int blocksToRender = blockLines.size();
            matrices.method_22903();
            float tx = 0.0f;
            float ty = 0.0f;
            float tz = 0.0f;
            float rx = 0.0f;
            float ry = 0.0f;
            float rz = 0.0f;
            float sx = 1.0f;
            float sy = 1.0f;
            float sz = 1.0f;
            if (renderMode == class_809.class_811.field_4322) {
                ty = 7.5f;
                sz = 1.5f;
                sy = 1.5f;
                sx = 1.5f;
            } else if (renderMode == class_809.class_811.field_4321) {
                ty = 7.5f;
                ry = 180.0f;
                sz = 1.5f;
                sy = 1.5f;
                sx = 1.5f;
            } else if (renderMode == class_809.class_811.field_4320) {
                ty = 3.5f;
                tz = -0.05f;
            } else if (renderMode == class_809.class_811.field_4323) {
                ty = 2.0f;
                tz = -0.05f;
                ry = 180.0f;
            } else if (renderMode == class_809.class_811.field_4316) {
                ry = 180.0f;
                sz = 2.5f;
                sy = 2.5f;
                sx = 2.5f;
            } else if (renderMode == class_809.class_811.field_4317) {
                sz = 1.5f;
                sy = 1.5f;
                sx = 1.5f;
            } else if (renderMode == class_809.class_811.field_4318) {
                ty = 5.0f;
            } else if (renderMode == class_809.class_811.field_4319) {
                tz = -0.25f;
                ry = 180.0f;
                sz = 3.5f;
                sy = 3.5f;
                sx = 3.5f;
                if (btype.equals("short")) {
                    ty = 5.0f;
                }
            }
            matrices.method_46416(tx / 16.0f, ty / 16.0f, tz / 16.0f);
            matrices.method_22907(new Quaternionf().rotateX((float)Math.toRadians(rx)));
            matrices.method_22907(new Quaternionf().rotateY((float)Math.toRadians(ry)));
            matrices.method_22907(new Quaternionf().rotateZ((float)Math.toRadians(rz)));
            matrices.method_22905(sx, sy, sz);
            class_1921 renderLayer = class_1921.method_23689((class_2960)texture);
            class_4588 consumer = vertexConsumers.getBuffer(renderLayer);
            float z = 1.0E-5f;
            this.vertex(consumer, matrices, -0.5f, -0.5f, -z, 0.0f, 1.0f, light, overlay, 0.0f, 1.0f, 0.0f);
            this.vertex(consumer, matrices, 0.5f, -0.5f, -z, 1.0f, 1.0f, light, overlay, 0.0f, 1.0f, 0.0f);
            this.vertex(consumer, matrices, 0.5f, 0.5f, -z, 1.0f, 0.0f, light, overlay, 0.0f, 1.0f, 0.0f);
            this.vertex(consumer, matrices, -0.5f, 0.5f, -z, 0.0f, 0.0f, light, overlay, 0.0f, 1.0f, 0.0f);
            this.vertex(consumer, matrices, -0.5f, 0.5f, z, 0.0f, 0.0f, light, overlay, 0.0f, -1.0f, 0.0f);
            this.vertex(consumer, matrices, 0.5f, 0.5f, z, 1.0f, 0.0f, light, overlay, 0.0f, -1.0f, 0.0f);
            this.vertex(consumer, matrices, 0.5f, -0.5f, z, 1.0f, 1.0f, light, overlay, 0.0f, -1.0f, 0.0f);
            this.vertex(consumer, matrices, -0.5f, -0.5f, z, 0.0f, 1.0f, light, overlay, 0.0f, -1.0f, 0.0f);
            float textScale = 0.002f;
            int color = 0;
            int shadowColor = 12169630;
            float firstLetterScale = 1.5f;
            float firstLetterXOffset = 0.0f;
            float firstLetterYOffset = -3.0f;
            float shadowOffsetX = 1.0f;
            float shadowOffsetY = 1.0f;
            float shadowZOffset = -5.0E-4f;
            float boldOffset = 1.0f;
            float boldZOffset = 1.0E-4f;
            float restTextScale = 1.0f;
            float restXOffset = 0.0f;
            float restYOffset = 0.0f;
            float maxTextWidth = 150.0f;
            boolean centerText = false;
            if (btype.equals("wanted")) {
                String firstPart;
                String string = firstPart = parts.length > 0 ? parts[0].trim() : "";
                if (firstPart.equals("\u0420\u043e\u0437\u044b\u0441\u043a") || firstPart.equals("\u041f\u0440\u043e\u043f\u0430\u0432\u0448\u0438\u0439")) {
                    capColor = 2888194;
                    firstLetterScale = 4.5f;
                    firstLetterXOffset = 0.0f;
                    firstLetterYOffset = 0.0f;
                    startXs[0] = -70.0f;
                    startYs[0] = -120.0f;
                    restTextScale = 3.0f;
                    restXOffset = -4.0f;
                    restYOffset = 10.0f;
                    centerText = true;
                    if (firstPart.equals("\u0420\u043e\u0437\u044b\u0441\u043a")) {
                        restXOffset -= 5.0f;
                    }
                    boldZOffset = 0.01f;
                    shadowZOffset = -0.01f;
                }
            }
            boolean depthMaskDisabled = false;
            if (renderMode == class_809.class_811.field_4322 || renderMode == class_809.class_811.field_4321) {
                RenderSystem.depthMask((boolean)false);
                depthMaskDisabled = true;
            }
            try {
                matrices.method_22903();
                try {
                    matrices.method_22904(0.0, 0.0, (double)(-z) + 0.001);
                    matrices.method_22905(textScale, -textScale, textScale);
                    class_2960 imageId = null;
                    String imageUrl = "";
                    boolean isSkin = false;
                    if (btype.equals("wanted") && stack.method_7969().method_10545("broadcast_image")) {
                        imageUrl = stack.method_7969().method_10558("broadcast_image");
                        isSkin = imageUrl.startsWith("https://skins.votive-rp.com/SKIN/STORAGE/");
                        imageId = ItemRendererMixin.getOrLoadImageTexture(imageUrl);
                        if (imageId != null) {
                            try {
                                class_1060 texManager = class_310.method_1551().method_1531();
                                if (texManager == null || texManager.method_4619(imageId) == null) {
                                    System.err.println("[VotiveRP] Texture ID is invalid or deleted: " + imageId + " for URL: " + imageUrl);
                                    imageCache.remove(imageUrl);
                                    imageId = null;
                                }
                            }
                            catch (Exception e) {
                                System.err.println("[VotiveRP] Exception while validating texture: " + imageId);
                                e.printStackTrace();
                                imageId = null;
                            }
                        }
                        if (imageId != null) {
                            try {
                                float imgX = -59.0f;
                                float imgY = -70.0f;
                                float imgWidth = 129.0f;
                                float imgHeight = 129.0f;
                                class_1921 imgLayer = class_1921.method_23689((class_2960)imageId);
                                class_4588 imgConsumer = vertexConsumers.getBuffer(imgLayer);
                                if (isSkin) {
                                    float minU_base = 0.125f;
                                    float maxU_base = 0.25f;
                                    float minV = 0.125f;
                                    float maxV = 0.25f;
                                    this.vertex(imgConsumer, matrices, imgX, imgY + imgHeight, 0.001f, minU_base, maxV, light, overlay, 0.0f, -1.0f, 0.0f);
                                    this.vertex(imgConsumer, matrices, imgX + imgWidth, imgY + imgHeight, 1.0E-4f, maxU_base, maxV, light, overlay, 0.0f, -1.0f, 0.0f);
                                    this.vertex(imgConsumer, matrices, imgX + imgWidth, imgY, 0.001f, maxU_base, minV, light, overlay, 0.0f, -1.0f, 0.0f);
                                    this.vertex(imgConsumer, matrices, imgX, imgY, 0.001f, minU_base, minV, light, overlay, 0.0f, -1.0f, 0.0f);
                                    float minU_hat = 0.625f;
                                    float maxU_hat = 0.75f;
                                    this.vertex(imgConsumer, matrices, imgX, imgY + imgHeight, 0.002f, minU_hat, maxV, light, overlay, 0.0f, -1.0f, 0.0f);
                                    this.vertex(imgConsumer, matrices, imgX + imgWidth, imgY + imgHeight, 0.002f, maxU_hat, maxV, light, overlay, 0.0f, -1.0f, 0.0f);
                                    this.vertex(imgConsumer, matrices, imgX + imgWidth, imgY, 0.002f, maxU_hat, minV, light, overlay, 0.0f, -1.0f, 0.0f);
                                    this.vertex(imgConsumer, matrices, imgX, imgY, 0.002f, minU_hat, minV, light, overlay, 0.0f, -1.0f, 0.0f);
                                } else {
                                    this.vertex(imgConsumer, matrices, imgX, imgY + imgHeight, 0.001f, 0.0f, 1.0f, light, overlay, 0.0f, -1.0f, 0.0f);
                                    this.vertex(imgConsumer, matrices, imgX + imgWidth, imgY + imgHeight, 0.001f, 1.0f, 1.0f, light, overlay, 0.0f, -1.0f, 0.0f);
                                    this.vertex(imgConsumer, matrices, imgX + imgWidth, imgY, 0.001f, 1.0f, 0.0f, light, overlay, 0.0f, -1.0f, 0.0f);
                                    this.vertex(imgConsumer, matrices, imgX, imgY, 0.001f, 0.0f, 0.0f, light, overlay, 0.0f, -1.0f, 0.0f);
                                }
                            }
                            catch (Exception e) {
                                System.err.println("[VotiveRP] Exception while rendering image texture: " + imageId);
                                e.printStackTrace();
                            }
                        }
                    }
                    for (int block = 0; block < blocksToRender; ++block) {
                        boolean useDropCap = btype.equals("wanted") ? block == 0 : parts.length > 1 || block == 0;
                        List lines = (List)blockLines.get(block);
                        this.drawTextBlock(lines, startXs[block], startYs[block], maxLines[block], lineHeights[block], textRenderer, matrices, vertexConsumers, color, shadowColor, capColor, shadowOffsetX, shadowOffsetY, light, firstLetterScale, firstLetterXOffset, firstLetterYOffset, shadowZOffset, boldOffset, boldZOffset, useDropCap, block == 0 ? restTextScale : 1.0f, block == 0 ? restXOffset : 0.0f, block == 0 ? restYOffset : 0.0f, maxTextWidth, centerText);
                    }
                }
                finally {
                    matrices.method_22909();
                }
            }
            finally {
                if (depthMaskDisabled) {
                    RenderSystem.depthMask((boolean)true);
                }
            }
            matrices.method_22909();
            ci.cancel();
        }
    }

    private static class_2960 getOrLoadImageTexture(String url) {
        CompletableFuture<Object> existingFuture;
        class_2960 id = imageCache.get(url);
        if (id != null) {
            try {
                class_1060 texManager = class_310.method_1551().method_1531();
                if (texManager != null && texManager.method_4619(id) != null) {
                    return id;
                }
                imageCache.remove(url);
            }
            catch (Exception e) {
                imageCache.remove(url);
            }
        }
        if ((existingFuture = loadingFutures.putIfAbsent(url, CompletableFuture.completedFuture(null))) == null) {
            ItemRendererMixin.loadImageAsync(url);
        }
        return null;
    }

    private static void loadImageAsync(String url) {
        CompletableFuture<byte[]> future = CompletableFuture.supplyAsync(() -> {
            try (InputStream in = new URL(url).openStream();){
                byte[] bytes = in.readAllBytes();
                if (bytes == null || bytes.length == 0) {
                    System.err.println("[VotiveRP] Failed to read bytes from URL: " + url);
                    byte[] byArray2 = null;
                    return byArray2;
                }
                byte[] byArray = bytes;
                return byArray;
            }
            catch (IOException e) {
                System.err.println("[VotiveRP] IOException while loading bytes from URL: " + url);
                e.printStackTrace();
                return null;
            }
            catch (Exception e) {
                System.err.println("[VotiveRP] Unexpected exception while loading bytes from URL: " + url);
                e.printStackTrace();
                return null;
            }
        });
        future.thenAccept(bytes -> {
            try {
                if (bytes != null && ((byte[])bytes).length > 0) {
                    class_310.method_1551().execute(() -> {
                        block16: {
                            String threadName = Thread.currentThread().getName();
                            System.out.println("[VotiveRP] [" + threadName + "] Starting texture creation for URL: " + url);
                            class_1011 image = null;
                            try {
                                if (imageCache.containsKey(url)) {
                                    System.out.println("[VotiveRP] Texture already registered for URL (skipping): " + url);
                                    return;
                                }
                                if (((byte[])bytes).length > 0xA00000) {
                                    System.err.println("[VotiveRP] Image too large: " + ((byte[])bytes).length + " bytes for URL: " + url);
                                    return;
                                }
                                System.out.println("[VotiveRP] [" + Thread.currentThread().getName() + "] Loading image from bytes for URL: " + url);
                                BufferedImage bufferedImage = null;
                                try {
                                    bufferedImage = ImageIO.read(new ByteArrayInputStream((byte[])bytes));
                                    if (bufferedImage == null) {
                                        System.err.println("[VotiveRP] ImageIO.read() returned null for URL: " + url);
                                        return;
                                    }
                                    System.out.println("[VotiveRP] Successfully loaded BufferedImage: " + bufferedImage.getWidth() + "x" + bufferedImage.getHeight());
                                    image = ItemRendererMixin.convertToNativeImage(bufferedImage);
                                    System.out.println("[VotiveRP] Successfully converted to NativeImage");
                                }
                                catch (Exception readEx) {
                                    System.err.println("[VotiveRP] Failed to load/convert image for URL: " + url);
                                    readEx.printStackTrace();
                                    return;
                                }
                                if (image == null) {
                                    System.err.println("[VotiveRP] NativeImage.read() returned null for URL: " + url);
                                    return;
                                }
                                if (image.method_4307() <= 0 || image.method_4323() <= 0) {
                                    System.err.println("[VotiveRP] Invalid image dimensions: " + image.method_4307() + "x" + image.method_4323() + " for URL: " + url);
                                    image.close();
                                    return;
                                }
                                class_1011.class_1012 format = image.method_4318();
                                if (format == null) {
                                    System.err.println("[VotiveRP] Invalid image format (null) for URL: " + url);
                                    image.close();
                                    return;
                                }
                                class_1060 texManager = class_310.method_1551().method_1531();
                                if (texManager == null) {
                                    System.err.println("[VotiveRP] TextureManager is null, cannot register texture for URL: " + url);
                                    image.close();
                                    return;
                                }
                                class_1043 texture = new class_1043(image);
                                String textureName = "broadcast_image_" + Integer.toHexString(url.hashCode());
                                class_2960 id = texManager.method_4617(textureName, texture);
                                if (id == null) {
                                    System.err.println("[VotiveRP] Failed to register dynamic texture for URL: " + url + " - registerDynamicTexture returned null");
                                    texture.close();
                                    return;
                                }
                                class_2960 existingId = imageCache.putIfAbsent(url, id);
                                if (existingId != null) {
                                    System.out.println("[VotiveRP] Texture was registered by another thread, cleaning up duplicate for URL: " + url);
                                    texture.close();
                                } else {
                                    System.out.println("[VotiveRP] Successfully registered texture: " + id + " for URL: " + url);
                                }
                            }
                            catch (Exception e) {
                                System.err.println("[VotiveRP] Exception while creating/registering texture for URL: " + url);
                                e.printStackTrace();
                                if (image == null) break block16;
                                try {
                                    image.close();
                                }
                                catch (Exception closeEx) {
                                    System.err.println("[VotiveRP] Failed to close NativeImage after failure");
                                    closeEx.printStackTrace();
                                }
                            }
                        }
                    });
                }
            }
            finally {
                loadingFutures.remove(url);
            }
        });
    }

    private void drawTextBlock(List<String> lines, float startX, float startY, int maxLines, int lineHeight, class_327 textRenderer, class_4587 matrices, class_4597 vertexConsumers, int color, int shadowColor, int capColor, float shadowOffsetX, float shadowOffsetY, int light, float firstLetterScale, float firstLetterXOffset, float firstLetterYOffset, float shadowZOffset, float boldOffset, float boldZOffset, boolean useDropCap, float restTextScale, float restXOffset, float restYOffset, float maxTextWidth, boolean center) {
        for (int i = 0; i < Math.min(maxLines, lines.size()); ++i) {
            String line = lines.get(i);
            if (line.isEmpty()) continue;
            float y = startY + (float)(i * lineHeight);
            float x = startX;
            if (i == 0 && !line.isEmpty() && useDropCap) {
                String firstChar = line.substring(0, 1);
                String shadowFirstChar = this.stripMCFormatting(firstChar);
                class_5250 firstText = class_2561.method_43470((String)firstChar).method_27694(style -> style.method_27703(class_5251.method_27717((int)capColor)));
                class_5250 firstShadow = class_2561.method_43470((String)shadowFirstChar).method_27694(style -> style.method_27703(class_5251.method_27717((int)shadowColor)));
                float origWidth = textRenderer.method_27525((class_5348)firstText);
                float scaledWidth = origWidth * firstLetterScale + boldOffset * firstLetterScale;
                String rest = line.substring(1);
                float restWidth = (float)textRenderer.method_1727(rest) * restTextScale;
                if (center) {
                    float totalWidth = scaledWidth + restWidth;
                    x = startX + (maxTextWidth - totalWidth) / 2.0f;
                }
                matrices.method_22903();
                matrices.method_46416(x + firstLetterXOffset + shadowOffsetX + boldOffset, y + firstLetterYOffset + shadowOffsetY, shadowZOffset);
                matrices.method_22905(firstLetterScale, firstLetterScale, 1.0f);
                textRenderer.method_30882((class_2561)firstShadow, 0.0f, 0.0f, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, false, 0, light);
                matrices.method_22909();
                matrices.method_22903();
                matrices.method_46416(x + firstLetterXOffset + shadowOffsetX, y + firstLetterYOffset + shadowOffsetY, shadowZOffset + boldZOffset);
                matrices.method_22905(firstLetterScale, firstLetterScale, 1.0f);
                textRenderer.method_30882((class_2561)firstShadow, 0.0f, 0.0f, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, false, 0, light);
                matrices.method_22909();
                matrices.method_22903();
                matrices.method_46416(x + firstLetterXOffset + boldOffset, y + firstLetterYOffset, 0.001f);
                matrices.method_22905(firstLetterScale, firstLetterScale, 1.0f);
                textRenderer.method_30882((class_2561)firstText, 0.0f, 0.0f, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, false, 0, light);
                matrices.method_22909();
                matrices.method_22903();
                matrices.method_46416(x + firstLetterXOffset, y + firstLetterYOffset, boldZOffset + 0.001f);
                matrices.method_22905(firstLetterScale, firstLetterScale, 1.0f);
                textRenderer.method_30882((class_2561)firstText, 0.0f, 0.0f, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, false, 0, light);
                matrices.method_22909();
                String shadowRest = this.stripMCFormatting(rest);
                if (rest.isEmpty()) continue;
                class_5250 restText = class_2561.method_43470((String)rest).method_27694(style -> style.method_27703(class_5251.method_27717((int)color)));
                class_5250 restShadow = class_2561.method_43470((String)shadowRest).method_27694(style -> style.method_27703(class_5251.method_27717((int)shadowColor)));
                float restX = x + scaledWidth + restXOffset;
                float restY = y + restYOffset;
                matrices.method_22903();
                matrices.method_46416(0.0f, 0.0f, shadowZOffset);
                matrices.method_22905(restTextScale, restTextScale, 1.0f);
                textRenderer.method_30882((class_2561)restShadow, (restX + shadowOffsetX) / restTextScale, (restY + shadowOffsetY) / restTextScale, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, false, 0, light);
                matrices.method_22909();
                matrices.method_22903();
                matrices.method_22905(restTextScale, restTextScale, 1.0f);
                textRenderer.method_30882((class_2561)restText, restX / restTextScale, restY / restTextScale, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, false, 0, light);
                matrices.method_22909();
                continue;
            }
            String shadowLine = this.stripMCFormatting(line);
            float lineWidth = textRenderer.method_1727(shadowLine);
            if (center) {
                x = startX + (maxTextWidth - lineWidth) / 2.0f;
            }
            matrices.method_22903();
            matrices.method_46416(0.0f, 0.0f, shadowZOffset);
            class_5250 lineShadow = class_2561.method_43470((String)shadowLine).method_27694(style -> style.method_27703(class_5251.method_27717((int)shadowColor)));
            textRenderer.method_30882((class_2561)lineShadow, x + shadowOffsetX, y + shadowOffsetY, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, false, 0, light);
            matrices.method_22909();
            class_5250 lineText = class_2561.method_43470((String)line).method_27694(style -> style.method_27703(class_5251.method_27717((int)color)));
            textRenderer.method_30882((class_2561)lineText, x, y, 0xFFFFFF, false, matrices.method_23760().method_23761(), vertexConsumers, false, 0, light);
        }
    }

    private List<String> wrapText(String text, int maxWidth, class_327 renderer) {
        String[] paragraphs;
        ArrayList<String> lines = new ArrayList<String>();
        for (String para : paragraphs = text.split("\\^")) {
            if (para.isEmpty()) {
                lines.add("");
                continue;
            }
            String[] words = para.split(" ");
            StringBuilder currentLine = new StringBuilder();
            for (String word : words) {
                String temp;
                if (word.isEmpty()) continue;
                String string = temp = currentLine.length() > 0 ? currentLine + " " + word : word;
                if (renderer.method_1727(temp) <= maxWidth) {
                    currentLine = new StringBuilder(temp);
                    continue;
                }
                if (currentLine.length() > 0) {
                    lines.add(currentLine.toString());
                }
                currentLine = new StringBuilder(word);
            }
            if (currentLine.length() <= 0) continue;
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private String stripMCFormatting(String input) {
        return input.replaceAll("\u00a7[0-9a-fk-orA-FK-OR]", "");
    }

    private static class_1011 convertToNativeImage(BufferedImage bufferedImage) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        class_1011 nativeImage = new class_1011(class_1011.class_1012.field_4997, width, height, false);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int rgb = bufferedImage.getRGB(x, y);
                int alpha = rgb >> 24 & 0xFF;
                int red = rgb >> 16 & 0xFF;
                int green = rgb >> 8 & 0xFF;
                int blue = rgb & 0xFF;
                if (bufferedImage.getColorModel().hasAlpha()) {
                    nativeImage.method_4305(x, y, alpha << 24 | blue << 16 | green << 8 | red);
                    continue;
                }
                nativeImage.method_4305(x, y, 0xFF000000 | blue << 16 | green << 8 | red);
            }
        }
        return nativeImage;
    }

    private void vertex(class_4588 consumer, class_4587 matrices, float x, float y, float z, float u, float v, int light, int overlay, float nx, float ny, float nz) {
        class_4587.class_4665 entry = matrices.method_23760();
        consumer.method_22918(entry.method_23761(), x, y, z).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(u, v).method_22922(overlay).method_22916(light).method_23763(entry.method_23762(), nx, ny, nz).method_1344();
    }
}

