/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.votiverpequipments.common.scanner;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.zeydie.votiverpequipments.common.config.ConfigManager;
import com.zeydie.votiverpequipments.common.config.ItemConfig;
import com.zeydie.votiverpequipments.common.config.ItemConfigParser;
import com.zeydie.votiverpequipments.common.config.ItemsConfigJson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1304;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceScanner.class);
    private static final String GEO_PATH_PREFIX = "geo/item/";
    private static final String ANIMATION_PATH_PREFIX = "animations/item/";
    private static final String GEO_SUFFIX = ".geo.json";
    private static final String ANIMATION_SUFFIX = ".animation.json";
    private static final List<String> STANDARD_ANIMATIONS = List.of("swing", "walk", "idle");
    private static final Map<String, ItemConfig> ITEM_CONFIGS = new HashMap<String, ItemConfig>();
    private static boolean initialized = false;

    private static void loadConfigFromFileInternal() {
        LOGGER.info("Loading item configurations from config file...");
        try {
            ITEM_CONFIGS.clear();
            ItemsConfigJson config = ConfigManager.loadItemsConfig();
            if (config == null || config.getItems() == null || config.getItems().isEmpty()) {
                LOGGER.warn("Config is empty or invalid");
                return;
            }
            for (ItemsConfigJson.ItemConfigJson itemJson : config.getItems()) {
                try {
                    ItemConfig itemConfig = ItemConfigParser.parseFromJson(itemJson);
                    ITEM_CONFIGS.put(itemConfig.getItemId(), itemConfig);
                    LOGGER.debug("Loaded item config: {}", (Object)itemConfig.getItemId());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to parse item: {}", (Object)itemJson.getId(), (Object)e);
                }
            }
            initialized = true;
            LOGGER.info("Loaded {} item configurations from config file", (Object)ITEM_CONFIGS.size());
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config from file", (Throwable)e);
        }
    }

    public static void loadConfigFromFile() {
        ResourceScanner.loadConfigFromFileInternal();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadConfigFromBuiltinJson() {
        try {
            InputStream resourceStream = ResourceScanner.class.getResourceAsStream("/assets/votiverpequipments/items_config.json");
            if (resourceStream == null) {
                LOGGER.debug("Built-in items_config.json not found");
                return false;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));){
                Gson gson = new GsonBuilder().create();
                ItemsConfigJson config = (ItemsConfigJson)gson.fromJson((Reader)reader, ItemsConfigJson.class);
                if (config == null || config.getItems() == null) {
                    LOGGER.warn("Invalid JSON config structure");
                    boolean bl = false;
                    return bl;
                }
                for (ItemsConfigJson.ItemConfigJson itemJson : config.getItems()) {
                    try {
                        ItemConfig itemConfig = ItemConfigParser.parseFromJson(itemJson);
                        ITEM_CONFIGS.put(itemConfig.getItemId(), itemConfig);
                        LOGGER.debug("Loaded item config: {}", (Object)itemConfig.getItemId());
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to parse item: {}", (Object)itemJson.getId(), (Object)e);
                    }
                }
                boolean bl = !ITEM_CONFIGS.isEmpty();
                return bl;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load built-in JSON config", (Throwable)e);
            return false;
        }
    }

    private static void createDefaultConfigs() {
        ResourceScanner.createHandItemConfig("hlust", false, null, 54141);
        ResourceScanner.createArmorConfig("arbalet_oh_my", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("backpack_1", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("backpack_2", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("basar_demon_wings", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("basar_rostochki", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("cepeshh_axe", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("crossbow_kolchan", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("crow", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("ears_blue", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("ears_lapis", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("ears_red", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("fairy_wings_gray", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("fur_cape", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("gecko_armor", class_1304.field_6169, false, null);
        ResourceScanner.createArmorConfig("gold_shield", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("gold_shoulders", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("inferno_chains", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("iron_sholuders", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("khaghorn_donate_votive_axe", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("klinok_vova_offhand", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("magic_belt", "belt_magic", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("maks_nakidka1", "maks_nakidka", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("maks_nakidka2", "maks_nakidka", class_1304.field_6172, false, null);
        ResourceScanner.createArmorConfig("maks_nakidka3", "maks_nakidka", class_1304.field_6169, false, null);
        ResourceScanner.createArmorConfig("maks_nakidka4", "maks_nakidka", class_1304.field_6166, false, null);
        ResourceScanner.createArmorConfig("maliket_matiz_sword", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("owl_basar", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("rafail", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("rat_normal", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("red_nakidka", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("ring_blue", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("ring_red", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("samokrutka_1", class_1304.field_6169, false, null);
        ResourceScanner.createArmorConfig("samokrutka_2", class_1304.field_6169, false, null);
        ResourceScanner.createArmorConfig("samokrutka_3", class_1304.field_6169, false, null);
        ResourceScanner.createArmorConfig("sarah_offhand", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("serp", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("serp_2", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("shoulders", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("suspension_feniks", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tatoo_1", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tatoo_2", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tatoo_3", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tatoo_4", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tatoo_5", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tatoo_6", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tatoo_7", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tourney_sholuders", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("wallet_belt", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("war_of_roses_sholuders", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("wreath", class_1304.field_6169, false, null);
        ResourceScanner.createArmorConfig("belt_magic", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("wallet_belt", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tatoo_1", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tatoo_2", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tatoo_3", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tatoo_4", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tatoo_5", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tatoo_6", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("tatoo_7", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("maks_nakidka1", "maks_nakidka", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("maks_nakidka2", "maks_nakidka", class_1304.field_6172, false, null);
        ResourceScanner.createArmorConfig("maks_nakidka3", "maks_nakidka", class_1304.field_6169, false, null);
        ResourceScanner.createArmorConfig("maks_nakidka4", "maks_nakidka", class_1304.field_6166, false, null);
        ResourceScanner.createArmorConfig("wreath", class_1304.field_6169, false, null);
        ResourceScanner.createArmorConfig("suspension_feniks", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("backpack_1", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("backpack_2", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("samokrutka_1", class_1304.field_6169, false, null);
        ResourceScanner.createArmorConfig("samokrutka_2", class_1304.field_6169, false, null);
        ResourceScanner.createArmorConfig("samokrutka_3", class_1304.field_6169, false, null);
        ResourceScanner.createArmorConfig("fairy_wings_gray_1", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("fairy_wings_gray_2", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("fairy_wings_gray_3", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("fairy_wings_gray_4", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("fur_cape", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("ears_blue", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("ears_lapis", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("ears_red", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("ring_blue", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfig("ring_red", class_1304.field_6174, false, null);
        ResourceScanner.createArmorConfigWithDefault("arbalet_oh_my", class_1304.field_6174, true, List.of("static"), "static");
        ResourceScanner.createHandItemConfig("hlust", true, List.of("swing", "walk", "idle"), 54141);
        ResourceScanner.createHandItemConfig("sword", true, List.of("swing", "idle"), 54142);
    }

    private static void createArmorConfig(String itemId, class_1304 slot, boolean hasAnimations, List<String> animations) {
        ResourceScanner.createArmorConfig(itemId, itemId, slot, hasAnimations, animations);
    }

    private static void createArmorConfig(String itemId, String modelName, class_1304 slot, boolean hasAnimations, List<String> animations) {
        ItemConfig config = ItemConfig.builder().itemId(itemId).modelPath("armor/" + modelName).itemType(ItemConfig.ItemType.ARMOR).armorSlot(slot).hasAnimations(hasAnimations).animations(animations != null ? animations : List.of()).build();
        ITEM_CONFIGS.put(itemId, config);
    }

    private static void createArmorConfigWithDefault(String itemId, class_1304 slot, boolean hasAnimations, List<String> animations, String defaultAnimation) {
        ItemConfig config = ItemConfig.builder().itemId(itemId).modelPath("armor/" + itemId).itemType(ItemConfig.ItemType.ARMOR).armorSlot(slot).hasAnimations(hasAnimations).animations(animations != null ? animations : List.of()).defaultAnimation(defaultAnimation).build();
        ITEM_CONFIGS.put(itemId, config);
    }

    private static void createHandItemConfig(String itemId, boolean hasAnimations, List<String> animations, Integer customModelData) {
        ItemConfig config = ItemConfig.builder().itemId(itemId).modelPath(itemId).itemType(ItemConfig.ItemType.HAND_ITEM).hasAnimations(hasAnimations).animations(animations != null ? animations : List.of()).customModelData(customModelData).build();
        ITEM_CONFIGS.put(itemId, config);
    }

    public static void registerResourceListener() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("votiverpequipments", "resource_scanner");
            }

            public void method_14491(@NonNull class_3300 manager) {
                if (manager == null) {
                    throw new NullPointerException("manager is marked non-null but is null");
                }
                LOGGER.info("=== RESOURCE RELOAD DETECTED (F3+T) ===");
                LOGGER.info("Reloading item configurations from config file...");
                ResourceScanner.loadConfigFromFile();
                LOGGER.info("Resource reload complete! Loaded {} item configurations", (Object)ITEM_CONFIGS.size());
            }
        });
    }

    @Deprecated
    public static void scanResources(@NonNull class_3300 resourceManager) {
        if (resourceManager == null) {
            throw new NullPointerException("resourceManager is marked non-null but is null");
        }
        LOGGER.info("Starting resource scanning for dynamic item generation...");
        ITEM_CONFIGS.clear();
        try {
            List<String> geoFiles = ResourceScanner.findAllGeoFiles(resourceManager);
            LOGGER.info("Found {} geo files", (Object)geoFiles.size());
            for (String geoPath : geoFiles) {
                ResourceScanner.processGeoFile(resourceManager, geoPath);
            }
            LOGGER.info("Resource scanning complete! Generated {} item configurations", (Object)ITEM_CONFIGS.size());
        }
        catch (Exception e) {
            LOGGER.error("Error during resource scanning", (Throwable)e);
        }
    }

    private static List<String> findAllGeoFiles(@NonNull class_3300 resourceManager) {
        if (resourceManager == null) {
            throw new NullPointerException("resourceManager is marked non-null but is null");
        }
        ArrayList<String> geoFiles = new ArrayList<String>();
        class_2960 armorGeoId = new class_2960("votiverpequipments", "geo/item/armor");
        ResourceScanner.scanDirectory(resourceManager, armorGeoId, "armor/", geoFiles);
        class_2960 itemGeoId = new class_2960("votiverpequipments", GEO_PATH_PREFIX);
        ResourceScanner.scanDirectory(resourceManager, itemGeoId, "", geoFiles);
        return geoFiles;
    }

    private static void scanDirectory(@NonNull class_3300 resourceManager, @NonNull class_2960 baseId, @NonNull String subPath, @NonNull List<String> output) {
        if (resourceManager == null) {
            throw new NullPointerException("resourceManager is marked non-null but is null");
        }
        if (baseId == null) {
            throw new NullPointerException("baseId is marked non-null but is null");
        }
        if (subPath == null) {
            throw new NullPointerException("subPath is marked non-null but is null");
        }
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        List<String> knownArmorItems = List.of("arbalet_oh_my", "backpack_1", "backpack_2", "belt_magic", "ears_blue", "ears_lapis", "ears_red", "fairy_wings_gray_1", "fairy_wings_gray_2", "fairy_wings_gray_3", "fairy_wings_gray_4", "fur_cape", "gecko_armor", "gold_shoulders", "iron_sholuders", "iron_shoulders", "maks_nakidka", "ring_blue", "ring_red", "samokrutka_1", "samokrutka_2", "samokrutka_3", "shoulders", "suspension_feniks", "tatoo_1", "tatoo_2", "tatoo_3", "tatoo_4", "tatoo_5", "tatoo_6", "tatoo_7", "tourney_sholuders", "wallet_belt", "war_of_roses_sholuders", "wreath");
        List<String> knownHandItems = List.of("hlust", "sword");
        if (subPath.equals("armor/")) {
            for (String itemName : knownArmorItems) {
                String path = subPath + itemName;
                if (!ResourceScanner.resourceExists(resourceManager, GEO_PATH_PREFIX + path + GEO_SUFFIX)) continue;
                output.add(path);
            }
        } else {
            for (String itemName : knownHandItems) {
                if (!ResourceScanner.resourceExists(resourceManager, GEO_PATH_PREFIX + itemName + GEO_SUFFIX)) continue;
                output.add(itemName);
            }
        }
    }

    private static boolean resourceExists(@NonNull class_3300 resourceManager, @NonNull String path) {
        if (resourceManager == null) {
            throw new NullPointerException("resourceManager is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try {
            class_2960 identifier = new class_2960("votiverpequipments", path);
            return resourceManager.method_14486(identifier).isPresent();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void processGeoFile(@NonNull class_3300 resourceManager, @NonNull String geoPath) {
        if (resourceManager == null) {
            throw new NullPointerException("resourceManager is marked non-null but is null");
        }
        if (geoPath == null) {
            throw new NullPointerException("geoPath is marked non-null but is null");
        }
        try {
            Integer customModelData;
            boolean isArmor = geoPath.startsWith("armor/");
            String itemName = geoPath.replace("armor/", "").replace(GEO_SUFFIX, "");
            Object modelPath = isArmor ? "armor/" + itemName : itemName;
            LOGGER.debug("Processing geo file: {} (armor: {})", (Object)geoPath, (Object)isArmor);
            List<String> animations = ResourceScanner.findAnimationsForItem(resourceManager, geoPath);
            boolean hasAnimations = !animations.isEmpty();
            class_1304 armorSlot = ResourceScanner.determineArmorSlot(itemName);
            ItemConfig.ItemConfigBuilder configBuilder = ItemConfig.builder().itemId(itemName).modelPath((String)modelPath).itemType(isArmor ? ItemConfig.ItemType.ARMOR : ItemConfig.ItemType.HAND_ITEM).animations(animations).hasAnimations(hasAnimations);
            if (isArmor) {
                configBuilder.armorSlot(armorSlot);
            }
            if ("arbalet_oh_my".equals(itemName)) {
                configBuilder.defaultAnimation("static");
            }
            if (!isArmor && (customModelData = ResourceScanner.getCustomModelDataForItem(itemName)) != null) {
                configBuilder.customModelData(customModelData);
            }
            ItemConfig config = configBuilder.build();
            ITEM_CONFIGS.put(itemName, config);
            LOGGER.info("Created config for '{}': type={}, animations={}, slot={}", new Object[]{itemName, config.getItemType(), animations.size(), armorSlot});
        }
        catch (Exception e) {
            LOGGER.error("Error processing geo file: {}", (Object)geoPath, (Object)e);
        }
    }

    private static List<String> findAnimationsForItem(@NonNull class_3300 resourceManager, @NonNull String geoPath) {
        if (resourceManager == null) {
            throw new NullPointerException("resourceManager is marked non-null but is null");
        }
        if (geoPath == null) {
            throw new NullPointerException("geoPath is marked non-null but is null");
        }
        ArrayList<String> animations = new ArrayList<String>();
        String animationPath = geoPath.replace(GEO_SUFFIX, ANIMATION_SUFFIX);
        class_2960 identifier = new class_2960("votiverpequipments", ANIMATION_PATH_PREFIX + animationPath);
        try {
            Optional resourceOptional = resourceManager.method_14486(identifier);
            if (resourceOptional.isEmpty()) {
                return animations;
            }
            class_3298 resource = (class_3298)resourceOptional.get();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8));){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (json.has("animations")) {
                    JsonObject animationsObj = json.getAsJsonObject("animations");
                    for (String animName : STANDARD_ANIMATIONS) {
                        if (!animationsObj.has(animName)) continue;
                        animations.add(animName);
                    }
                }
            }
            LOGGER.debug("Found {} animations for {}: {}", new Object[]{animations.size(), geoPath, animations});
        }
        catch (Exception e) {
            LOGGER.debug("No animations found for {}", (Object)geoPath);
        }
        return animations;
    }

    private static class_1304 determineArmorSlot(@NonNull String itemName) {
        if (itemName == null) {
            throw new NullPointerException("itemName is marked non-null but is null");
        }
        if (itemName.contains("helmet") || itemName.contains("wreath") || itemName.contains("samokrutka") || itemName.equals("maks_nakidka3")) {
            return class_1304.field_6169;
        }
        if (itemName.contains("leggings") || itemName.contains("pants") || itemName.equals("maks_nakidka2")) {
            return class_1304.field_6172;
        }
        if (itemName.contains("boots") || itemName.contains("shoes") || itemName.equals("maks_nakidka4")) {
            return class_1304.field_6166;
        }
        return class_1304.field_6174;
    }

    private static Integer getCustomModelDataForItem(@NonNull String itemName) {
        if (itemName == null) {
            throw new NullPointerException("itemName is marked non-null but is null");
        }
        return switch (itemName) {
            case "hlust" -> 54141;
            case "sword" -> 54142;
            default -> null;
        };
    }

    public static Optional<ItemConfig> getItemConfig(@NonNull String itemId) {
        if (itemId == null) {
            throw new NullPointerException("itemId is marked non-null but is null");
        }
        return Optional.ofNullable(ITEM_CONFIGS.get(itemId));
    }

    public static Collection<ItemConfig> getAllItemConfigs() {
        return Collections.unmodifiableCollection(ITEM_CONFIGS.values());
    }

    public static List<ItemConfig> getArmorConfigs() {
        return ITEM_CONFIGS.values().stream().filter(config -> config.getItemType() == ItemConfig.ItemType.ARMOR).toList();
    }

    public static List<ItemConfig> getHandItemConfigs() {
        return ITEM_CONFIGS.values().stream().filter(config -> config.getItemType() == ItemConfig.ItemType.HAND_ITEM).toList();
    }

    @Generated
    private ResourceScanner() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        LOGGER.info("=== STATIC INITIALIZATION ===");
        ConfigManager.initialize();
        ResourceScanner.loadConfigFromFileInternal();
    }
}

