/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.votiverpequipments.common.registry;

import com.zeydie.votiverpequipments.common.config.ItemConfig;
import com.zeydie.votiverpequipments.common.items.armor.dynamic.DynamicEquipmentsArmorItem;
import com.zeydie.votiverpequipments.common.items.item.dynamic.DynamicEquipmentsHandItem;
import com.zeydie.votiverpequipments.common.scanner.ResourceScanner;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.bernie.geckolib.animatable.GeoItem;

public final class ItemRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemRegistry.class);
    private static final Map<String, class_1792> REGISTERED_ITEMS = new HashMap<String, class_1792>();
    private static final Map<Integer, class_1792> CMD_TO_ITEM = new HashMap<Integer, class_1792>();

    @NotNull
    public static class_1799 getItemStackOfCMD(@NonNull class_1799 itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (itemStack.method_7985()) {
            int customModelData;
            class_1792 item;
            @NonNull class_2487 nbt = itemStack.method_7969();
            @NonNull String customModelDataNBT = "CustomModelData";
            if (nbt.method_10545("CustomModelData") && (item = CMD_TO_ITEM.get(customModelData = nbt.method_10550("CustomModelData"))) != null) {
                return item.method_7854();
            }
        }
        return class_1799.field_8037;
    }

    public static void registerItems() {
        LOGGER.info("Starting automatic item registration from resources...");
        Collection<ItemConfig> allConfigs = ResourceScanner.getAllItemConfigs();
        LOGGER.info("Found {} item configurations to register", (Object)allConfigs.size());
        for (ItemConfig config : allConfigs) {
            ItemRegistry.registerItemFromConfig(config);
        }
        LOGGER.info("Item registration complete! Registered {} items", (Object)REGISTERED_ITEMS.size());
    }

    private static void registerItemFromConfig(@NonNull ItemConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        try {
            Object item;
            String itemId = config.getItemId();
            class_2960 identifier = ItemRegistry.getIdentifier(itemId);
            if (config.getItemType() == ItemConfig.ItemType.ARMOR) {
                item = new DynamicEquipmentsArmorItem(config, "votiverpequipments");
                LOGGER.debug("Creating armor item: {} (slot: {})", (Object)itemId, (Object)config.getArmorSlot());
            } else {
                item = new DynamicEquipmentsHandItem(config, "votiverpequipments");
                LOGGER.debug("Creating hand item: {}", (Object)itemId);
            }
            class_1792 registeredItem = com.zeydie.equipmentlib.common.registry.ItemRegistry.registerItem((class_2960)identifier, (class_1792)item);
            REGISTERED_ITEMS.put(itemId, registeredItem);
            if (registeredItem instanceof GeoItem) {
                GeoItem geoItem = (GeoItem)registeredItem;
                com.zeydie.equipmentlib.common.registry.ItemRegistry.ITEMS.add(geoItem);
            }
            if (config.getCustomModelData() != null) {
                CMD_TO_ITEM.put(config.getCustomModelData(), registeredItem);
                LOGGER.debug("Registered CMD {} for item {}", (Object)config.getCustomModelData(), (Object)itemId);
            }
            LOGGER.info("Successfully registered item: {} (type: {}, animations: {})", new Object[]{itemId, config.getItemType(), config.getAnimations().size()});
        }
        catch (Exception e) {
            LOGGER.error("Failed to register item from config: {}", (Object)config.getItemId(), (Object)e);
        }
    }

    @Nullable
    public static class_1792 getItem(@NonNull class_2960 identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        return (class_1792)class_7923.field_41178.method_10223(identifier);
    }

    @Nullable
    public static class_1792 getRegisteredItem(@NonNull String itemId) {
        if (itemId == null) {
            throw new NullPointerException("itemId is marked non-null but is null");
        }
        return REGISTERED_ITEMS.get(itemId);
    }

    @NotNull
    public static class_2960 getIdentifier(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return new class_2960("votiverpequipments", name);
    }

    public static Map<String, class_1792> getAllRegisteredItems() {
        return Map.copyOf(REGISTERED_ITEMS);
    }
}

