/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.votiverpequipments.common.mixins.player;

import com.zeydie.equipmentlib.api.EquipmentLibAPI;
import com.zeydie.equipmentlib.common.items.EquipmentsHandItem;
import com.zeydie.votiverpequipments.common.items.item.basic.animated.AbstractAnimatedEquipmentsHandItem;
import com.zeydie.votiverpequipments.common.proxy.PlayerEntityProxy;
import com.zeydie.votiverpequipments.common.registry.ItemRegistry;
import lombok.NonNull;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements PlayerEntityProxy {
    @Unique
    @NotNull
    private final EquipmentLibAPI api = EquipmentLibAPI.getInstance();
    @Unique
    @Nullable
    private AbstractAnimatedEquipmentsHandItem mainHandItem;
    @Unique
    @Nullable
    private AbstractAnimatedEquipmentsHandItem offHandItem;
    @Unique
    @NotNull
    private class_243 lastPos = new class_243(0.0, 0.0, 0.0);
    @Unique
    private boolean walking = false;
    @Unique
    private boolean attacking = false;

    @Shadow
    public abstract float method_7261(float var1);

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(@NonNull CallbackInfo ci) {
        if (ci == null) {
            throw new NullPointerException("ci is marked non-null but is null");
        }
        @NonNull class_1657 player = (class_1657)this;
        if (this.lastPos == null) {
            this.lastPos = this.method_19538();
        }
        @NonNull class_243 pos = this.method_19538();
        @NonNull Vector3f movementVector = new Vector3f((float)(pos.field_1352 - this.lastPos.field_1352), 0.0f, (float)(pos.field_1350 - this.lastPos.field_1350));
        this.walking = movementVector.length() > 0.0f;
        this.lastPos = pos;
        this.attacking = (double)this.method_7261(0.5f) < 1.0;
        this.updateHands();
    }

    public void method_6104(@NonNull class_1268 hand) {
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        super.method_6104(hand);
    }

    public double method_26825(@NonNull class_1320 attribute) {
        AbstractAnimatedEquipmentsHandItem itemStack;
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        if (attribute == class_5134.field_23723 && (itemStack = this.mainHandItem) != null) {
            return itemStack.getAttackingAnimationDelay();
        }
        return super.method_26825(attribute);
    }

    @Override
    @Nullable
    public AbstractAnimatedEquipmentsHandItem getMainHandItem() {
        return this.mainHandItem;
    }

    @Override
    @Nullable
    public AbstractAnimatedEquipmentsHandItem getOffHandItem() {
        return this.offHandItem;
    }

    private void updateHands() {
        boolean mainHandUpdated = this.updateHand(this.method_5998(class_1268.field_5808), class_1268.field_5808);
        boolean offHandUpdated = this.updateHand(this.method_5998(class_1268.field_5810), class_1268.field_5810);
        if (!mainHandUpdated && this.api.getMainHandItem() != null) {
            this.api.setMainHandItem(null);
            this.mainHandItem = null;
        } else if (this.mainHandItem != null) {
            this.mainHandItem.setWalkingAnimation(this.walking);
            this.mainHandItem.setAttackingAnimation(this.attacking);
        }
        if (!offHandUpdated && this.api.getOffHandItem() != null) {
            this.api.setOffHandItem(null);
            this.offHandItem = null;
        } else if (this.offHandItem != null) {
            this.offHandItem.setWalkingAnimation(this.walking);
        }
    }

    private boolean updateHand(@NonNull class_1799 itemStack, @NonNull class_1268 hand) {
        if (itemStack == null) {
            throw new NullPointerException("itemStack is marked non-null but is null");
        }
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        if (!itemStack.method_7960() && itemStack.method_7985()) {
            class_1799 itemstackOfCMD;
            class_1792 class_17922;
            @NonNull class_2487 nbt = itemStack.method_7969();
            @NonNull String customModelDataNBT = "CustomModelData";
            if (nbt.method_10545("CustomModelData") && (class_17922 = (itemstackOfCMD = ItemRegistry.getItemStackOfCMD(itemStack)).method_7909()) instanceof AbstractAnimatedEquipmentsHandItem) {
                @NonNull AbstractAnimatedEquipmentsHandItem abstractAnimatedEquipmentsHandItem = (AbstractAnimatedEquipmentsHandItem)class_17922;
                switch (hand) {
                    case field_5808: {
                        this.api.setMainHandItem((EquipmentsHandItem)abstractAnimatedEquipmentsHandItem);
                        this.mainHandItem = abstractAnimatedEquipmentsHandItem;
                        return true;
                    }
                    case field_5810: {
                        this.api.setOffHandItem((EquipmentsHandItem)abstractAnimatedEquipmentsHandItem);
                        this.offHandItem = abstractAnimatedEquipmentsHandItem;
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }
}

