/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.votiverpequipments.common.items.item.basic.animated;

import com.zeydie.equipmentlib.common.items.EquipmentsHandItem;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public abstract class AbstractAnimatedEquipmentsHandItem
extends EquipmentsHandItem {
    private boolean walkingAnimation;
    private boolean attackingAnimation;
    private double attackingAnimationDelay;
    private long attackingAnimationMillis;
    @Nullable
    private String defaultAnimation;
    @NotNull
    private final List<String> animations = Lists.newArrayList();

    public AbstractAnimatedEquipmentsHandItem(@NonNull class_2960 identifier, @NonNull class_1792.class_1793 properties) {
        this(identifier, properties, null);
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
    }

    public AbstractAnimatedEquipmentsHandItem(@NonNull class_2960 identifier, @NonNull class_1792.class_1793 properties, @Nullable String defaultAnimation) {
        super(identifier, properties);
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.defaultAnimation = defaultAnimation;
        this.animations.add(defaultAnimation);
    }

    public <T extends class_1309> void renderItem(@NonNull T entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        @Nullable AnimationController controller = (AnimationController)this.getAnimationsControllers().get(this.defaultAnimation);
        if (controller != null && controller.getAnimationState() == AnimationController.State.STOPPED) {
            controller.setAnimation(RawAnimation.begin().thenPlay(this.defaultAnimation));
        }
    }

    @NotNull
    public List<String> getAnimations() {
        if (this.animations.isEmpty() && this.defaultAnimation != null) {
            this.animations.add(this.defaultAnimation);
        }
        return this.animations;
    }

    public boolean canAttacking() {
        return this.attackingAnimationMillis < System.currentTimeMillis();
    }

    @NotNull
    public abstract String getItemAnimationName();

    @Generated
    public void setWalkingAnimation(boolean walkingAnimation) {
        this.walkingAnimation = walkingAnimation;
    }

    @Generated
    public boolean isWalkingAnimation() {
        return this.walkingAnimation;
    }

    @Generated
    public void setAttackingAnimation(boolean attackingAnimation) {
        this.attackingAnimation = attackingAnimation;
    }

    @Generated
    public boolean isAttackingAnimation() {
        return this.attackingAnimation;
    }

    @Generated
    public void setAttackingAnimationDelay(double attackingAnimationDelay) {
        this.attackingAnimationDelay = attackingAnimationDelay;
    }

    @Generated
    public double getAttackingAnimationDelay() {
        return this.attackingAnimationDelay;
    }

    @Generated
    public void setAttackingAnimationMillis(long attackingAnimationMillis) {
        this.attackingAnimationMillis = attackingAnimationMillis;
    }

    @Generated
    public long getAttackingAnimationMillis() {
        return this.attackingAnimationMillis;
    }

    @Generated
    public void setDefaultAnimation(@Nullable String defaultAnimation) {
        this.defaultAnimation = defaultAnimation;
    }

    @Nullable
    @Generated
    public String getDefaultAnimation() {
        return this.defaultAnimation;
    }
}

