/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.votiverpequipments.common.items.armor.dynamic;

import com.zeydie.votiverpequipments.common.config.ItemConfig;
import com.zeydie.votiverpequipments.common.items.armor.basic.animated.AbstractAnimatedEquipmentsArmorItem;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public final class DynamicEquipmentsArmorItem
extends AbstractAnimatedEquipmentsArmorItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicEquipmentsArmorItem.class);
    @NotNull
    private final ItemConfig config;
    @NotNull
    private final String itemAnimationName;

    public DynamicEquipmentsArmorItem(@NonNull ItemConfig config, @NonNull String modId) {
        super(config.getModelIdentifier(modId), config.getArmorMaterial(), config.getArmorSlot(), new class_1792.class_1793());
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (modId == null) {
            throw new NullPointerException("modId is marked non-null but is null");
        }
        this.config = config;
        this.itemAnimationName = config.getItemId();
        if (config.getStartingAnimation() != null) {
            this.setDefaultAnimation(config.getStartingAnimation());
        }
    }

    public void registerControllers(@NonNull AnimatableManager.ControllerRegistrar controllers) {
        if (controllers == null) {
            throw new NullPointerException("controllers is marked non-null but is null");
        }
        super.registerControllers(controllers);
        if (!this.config.isHasAnimations()) {
            return;
        }
        if (this.config.getStartingAnimation() != null) {
            this.registerAnimation(this.config.getStartingAnimation(), new AnimationController((GeoAnimatable)this, this.config.getStartingAnimation(), 0, state -> {
                AnimationController controller = state.getController();
                AnimationProcessor.QueuedAnimation currentAnim = controller.getCurrentAnimation();
                if (currentAnim == null || controller.getAnimationState() == AnimationController.State.STOPPED) {
                    controller.setAnimation(RawAnimation.begin().thenPlay(this.config.getStartingAnimation()));
                }
                return PlayState.CONTINUE;
            }));
        }
        if (this.config.hasAnimation("swing") || this.config.hasAnimation("walk") || this.config.hasAnimation("idle")) {
            this.registerAnimation("dynamic_controller", new AnimationController((GeoAnimatable)this, "dynamic_controller", 20, state -> {
                if (this.config.hasAnimation("swing")) {
                    state.setAnimation(DefaultAnimations.ATTACK_SWING);
                } else if (this.config.hasAnimation("walk")) {
                    state.setAnimation(DefaultAnimations.WALK);
                } else if (this.config.hasAnimation("idle")) {
                    state.setAnimation(DefaultAnimations.IDLE);
                }
                return PlayState.CONTINUE;
            }));
        }
    }

    @Override
    public <T extends class_1309> void renderArmorItem(@NonNull T entity) {
        AnimationController controller;
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        super.renderArmorItem(entity);
        if (this.config.getStartingAnimation() != null && (controller = (AnimationController)this.getAnimationsControllers().get(this.config.getStartingAnimation())) != null && controller.getAnimationState() != AnimationController.State.RUNNING) {
            controller.setAnimation(RawAnimation.begin().thenPlay(this.config.getStartingAnimation()));
        }
    }

    @NotNull
    @Generated
    public ItemConfig getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    @Generated
    public String getItemAnimationName() {
        return this.itemAnimationName;
    }
}

