/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.votiverpequipments.common.config;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.zeydie.votiverpequipments.common.config.ItemConfig;
import com.zeydie.votiverpequipments.common.config.ItemsConfigJson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.class_1304;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItemConfigParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemConfigParser.class);
    private static final List<String> STANDARD_ANIMATIONS = List.of("swing", "walk", "idle", "static", "starting");

    public static ItemConfig parseFromJson(@NonNull ItemsConfigJson.ItemConfigJson json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        try {
            List<String> animations;
            if (json.getAnimations() != null && !json.getAnimations().isEmpty()) {
                animations = json.getAnimations();
                LOGGER.debug("Using animations from JSON for {}: {}", (Object)json.getId(), animations);
            } else {
                animations = ItemConfigParser.loadAnimationsFromFile(json.getModel());
                if (!animations.isEmpty()) {
                    LOGGER.debug("Auto-loaded animations for {}: {}", (Object)json.getId(), animations);
                }
            }
            boolean hasAnimations = !animations.isEmpty() || json.getStartingAnimation() != null;
            ItemConfig.ItemConfigBuilder builder = ItemConfig.builder().itemId(json.getId()).modelPath(json.getModel()).hasAnimations(hasAnimations).animations(animations);
            ItemConfig.ItemType type = ItemConfigParser.parseItemType(json.getType());
            builder.itemType(type);
            if (type == ItemConfig.ItemType.ARMOR) {
                builder.armorSlot(ItemConfigParser.parseArmorSlot(json.getSlot()));
                builder.armorMaterial(ItemConfigParser.parseArmorMaterial(json.getMaterial()));
            }
            if (json.getStartingAnimation() != null) {
                builder.startingAnimation(json.getStartingAnimation());
            }
            if (json.getCustomModelData() != null) {
                builder.customModelData(json.getCustomModelData());
            }
            return builder.build();
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse item config for ID: {}", (Object)json.getId(), (Object)e);
            throw new RuntimeException("Failed to parse item config", e);
        }
    }

    private static ItemConfig.ItemType parseItemType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return switch (type.toLowerCase()) {
            case "armor" -> ItemConfig.ItemType.ARMOR;
            case "hand", "hand_item" -> ItemConfig.ItemType.HAND_ITEM;
            default -> throw new IllegalArgumentException("Unknown item type: " + type);
        };
    }

    private static class_1304 parseArmorSlot(String slot) {
        if (slot == null) {
            LOGGER.warn("Armor slot not specified, defaulting to CHEST");
            return class_1304.field_6174;
        }
        return switch (slot.toLowerCase()) {
            case "head", "helmet" -> class_1304.field_6169;
            case "chest", "chestplate" -> class_1304.field_6174;
            case "legs", "leggings" -> class_1304.field_6172;
            case "feet", "boots" -> class_1304.field_6166;
            default -> {
                LOGGER.warn("Unknown armor slot: {}, defaulting to CHEST", (Object)slot);
                yield class_1304.field_6174;
            }
        };
    }

    private static class_1741 parseArmorMaterial(String material) {
        if (material == null) {
            return class_1740.field_21977;
        }
        return switch (material.toLowerCase()) {
            case "leather" -> class_1740.field_7897;
            case "iron" -> class_1740.field_7892;
            case "gold", "golden" -> class_1740.field_7895;
            case "diamond" -> class_1740.field_7889;
            case "netherite" -> class_1740.field_21977;
            case "turtle" -> class_1740.field_7890;
            default -> {
                LOGGER.warn("Unknown armor material: {}, defaulting to NETHERITE", (Object)material);
                yield class_1740.field_21977;
            }
        };
    }

    private static List<String> loadAnimationsFromFile(@NonNull String modelPath) {
        if (modelPath == null) {
            throw new NullPointerException("modelPath is marked non-null but is null");
        }
        ArrayList<String> animations = new ArrayList<String>();
        try {
            String animationPath = "/assets/votiverpequipments/animations/item/" + modelPath + ".animation.json";
            InputStream resourceStream = ItemConfigParser.class.getResourceAsStream(animationPath);
            if (resourceStream == null) {
                LOGGER.trace("Animation file not found: {}", (Object)animationPath);
                return animations;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (json.has("animations")) {
                    JsonObject animationsObj = json.getAsJsonObject("animations");
                    for (String animName : STANDARD_ANIMATIONS) {
                        if (!animationsObj.has(animName)) continue;
                        animations.add(animName);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Could not load animations from file for model: {}", (Object)modelPath, (Object)e);
        }
        return animations;
    }

    @Generated
    private ItemConfigParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

