/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.votiverpequipments.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.zeydie.votiverpequipments.common.config.ItemsConfigJson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import lombok.Generated;
import lombok.NonNull;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigManager.class);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_DIR_NAME = "votiverpequipments";
    private static final String ITEMS_CONFIG_FILE = "items.json";
    private static Path configDirectory;
    private static Path itemsConfigPath;

    public static void initialize() {
        try {
            configDirectory = FabricLoader.getInstance().getConfigDir().resolve(CONFIG_DIR_NAME);
            itemsConfigPath = configDirectory.resolve(ITEMS_CONFIG_FILE);
            if (!Files.exists(configDirectory, new LinkOption[0])) {
                Files.createDirectories(configDirectory, new FileAttribute[0]);
                LOGGER.info("Created config directory: {}", (Object)configDirectory);
            }
            LOGGER.info("Config manager initialized at: {}", (Object)configDirectory);
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize config manager", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ItemsConfigJson loadItemsConfig() {
        try {
            if (!Files.exists(itemsConfigPath, new LinkOption[0])) {
                LOGGER.warn("Items config not found at {}, creating default", (Object)itemsConfigPath);
                ConfigManager.createDefaultConfig();
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(itemsConfigPath.toFile()), StandardCharsets.UTF_8));){
                ItemsConfigJson config222 = (ItemsConfigJson)GSON.fromJson((Reader)reader, ItemsConfigJson.class);
                if (config222 == null || config222.getItems() == null) {
                    LOGGER.error("Invalid config file structure, recreating default");
                    ConfigManager.createDefaultConfig();
                    ItemsConfigJson itemsConfigJson = ConfigManager.loadItemsConfig();
                    return itemsConfigJson;
                }
                LOGGER.info("Successfully loaded config with {} items from: {}", (Object)config222.getItems().size(), (Object)itemsConfigPath);
                ItemsConfigJson throwable = config222;
                return throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load items config", (Throwable)e);
            ItemsConfigJson fallback = new ItemsConfigJson();
            fallback.setItems(new ArrayList<ItemsConfigJson.ItemConfigJson>());
            return fallback;
        }
    }

    private static void createDefaultConfig() {
        try {
            ItemsConfigJson defaultConfig = ConfigManager.createDefaultItemsConfig();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(itemsConfigPath.toFile()), StandardCharsets.UTF_8));){
                GSON.toJson((Object)defaultConfig, (Appendable)writer);
                LOGGER.info("Created default config file at: {}", (Object)itemsConfigPath);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create default config", (Throwable)e);
        }
    }

    private static ItemsConfigJson createDefaultItemsConfig() {
        ItemsConfigJson config = new ItemsConfigJson();
        ArrayList<ItemsConfigJson.ItemConfigJson> items = new ArrayList<ItemsConfigJson.ItemConfigJson>();
        items.add(ConfigManager.createHandItem("hlust", "hand/hlust", 54141));
        items.add(ConfigManager.createArmorItem("arbalet_oh_my", "armor/arbalet_oh_my", "chest", "starting"));
        items.add(ConfigManager.createArmorItem("backpack_1", "armor/backpack_1", "chest", null));
        items.add(ConfigManager.createArmorItem("backpack_2", "armor/backpack_2", "chest", null));
        items.add(ConfigManager.createArmorItem("basar_demon_wings", "armor/basar_demon_wings", "chest", null));
        items.add(ConfigManager.createArmorItem("basar_rostochki", "armor/basar_rostochki", "chest", "starting"));
        items.add(ConfigManager.createArmorItem("cepeshh_axe", "armor/cepeshh_axe", "chest", "starting"));
        items.add(ConfigManager.createArmorItem("crossbow_kolchan", "armor/crossbow_kolchan", "chest", "starting"));
        items.add(ConfigManager.createArmorItem("crow", "armor/crow", "chest", "starting"));
        items.add(ConfigManager.createArmorItem("ears_blue", "armor/ears_blue", "chest", null));
        items.add(ConfigManager.createArmorItem("ears_lapis", "armor/ears_lapis", "chest", null));
        items.add(ConfigManager.createArmorItem("ears_red", "armor/ears_red", "chest", null));
        items.add(ConfigManager.createArmorItem("fairy_wings_gray", "armor/fairy_wings_gray", "chest", null));
        items.add(ConfigManager.createArmorItem("fur_cape", "armor/fur_cape", "chest", null));
        items.add(ConfigManager.createArmorItem("gecko_armor", "armor/gecko_armor", "head", null));
        items.add(ConfigManager.createArmorItem("gold_shield", "armor/gold_shield", "chest", null));
        items.add(ConfigManager.createArmorItem("gold_shoulders", "armor/gold_shoulders", "chest", null));
        items.add(ConfigManager.createArmorItem("inferno_chains", "armor/inferno_chains", "chest", null));
        items.add(ConfigManager.createArmorItem("iron_sholuders", "armor/iron_sholuders", "chest", null));
        items.add(ConfigManager.createArmorItem("khaghorn_donate_votive_axe", "armor/khaghorn_donate_votive_axe", "chest", "starting"));
        items.add(ConfigManager.createArmorItem("klinok_vova_offhand", "armor/klinok_vova_offhand", "chest", "starting"));
        items.add(ConfigManager.createArmorItem("magic_belt", "armor/magic_belt", "chest", null));
        items.add(ConfigManager.createArmorItem("maks_nakidka1", "armor/maks_nakidka", "chest", null));
        items.add(ConfigManager.createArmorItem("maks_nakidka2", "armor/maks_nakidka", "legs", null));
        items.add(ConfigManager.createArmorItem("maks_nakidka3", "armor/maks_nakidka", "head", null));
        items.add(ConfigManager.createArmorItem("maks_nakidka4", "armor/maks_nakidka", "feet", null));
        items.add(ConfigManager.createArmorItem("maliket_matiz_sword", "armor/maliket_matiz_sword", "chest", "starting"));
        items.add(ConfigManager.createArmorItem("owl_basar", "armor/owl_basar", "chest", "starting"));
        items.add(ConfigManager.createArmorItem("rafail", "armor/rafail", "chest", null));
        items.add(ConfigManager.createArmorItem("rat_normal", "armor/rat_normal", "chest", "starting"));
        items.add(ConfigManager.createArmorItem("red_nakidka", "armor/red_nakidka", "chest", null));
        items.add(ConfigManager.createArmorItem("ring_blue", "armor/ring_blue", "chest", null));
        items.add(ConfigManager.createArmorItem("ring_red", "armor/ring_red", "chest", null));
        items.add(ConfigManager.createArmorItem("samokrutka_1", "armor/samokrutka_1", "head", null));
        items.add(ConfigManager.createArmorItem("samokrutka_2", "armor/samokrutka_2", "head", null));
        items.add(ConfigManager.createArmorItem("samokrutka_3", "armor/samokrutka_3", "head", null));
        items.add(ConfigManager.createArmorItem("sarah_offhand", "armor/sarah_offhand", "chest", "starting"));
        items.add(ConfigManager.createArmorItem("serp", "armor/serp", "chest", "starting"));
        items.add(ConfigManager.createArmorItem("serp_2", "armor/serp_2", "chest", "starting"));
        items.add(ConfigManager.createArmorItem("shoulders", "armor/shoulders", "chest", "starting"));
        items.add(ConfigManager.createArmorItem("suspension_feniks", "armor/suspension_feniks", "chest", null));
        items.add(ConfigManager.createArmorItem("tatoo_1", "armor/tatoo_1", "chest", null));
        items.add(ConfigManager.createArmorItem("tatoo_2", "armor/tatoo_2", "chest", null));
        items.add(ConfigManager.createArmorItem("tatoo_3", "armor/tatoo_3", "chest", null));
        items.add(ConfigManager.createArmorItem("tatoo_4", "armor/tatoo_4", "chest", null));
        items.add(ConfigManager.createArmorItem("tatoo_5", "armor/tatoo_5", "chest", null));
        items.add(ConfigManager.createArmorItem("tatoo_6", "armor/tatoo_6", "chest", null));
        items.add(ConfigManager.createArmorItem("tatoo_7", "armor/tatoo_7", "chest", null));
        items.add(ConfigManager.createArmorItem("tourney_sholuders", "armor/tourney_sholuders", "chest", null));
        items.add(ConfigManager.createArmorItem("wallet_belt", "armor/wallet_belt", "chest", null));
        items.add(ConfigManager.createArmorItem("war_of_roses_sholuders", "armor/war_of_roses_sholuders", "chest", null));
        items.add(ConfigManager.createArmorItem("wreath", "armor/wreath", "head", null));
        config.setItems(items);
        return config;
    }

    private static ItemsConfigJson.ItemConfigJson createArmorItem(String id, String model, String slot, String startingAnimation) {
        ItemsConfigJson.ItemConfigJson item = new ItemsConfigJson.ItemConfigJson();
        item.setId(id);
        item.setType("armor");
        item.setModel(model);
        item.setSlot(slot);
        if (startingAnimation != null) {
            item.setStartingAnimation(startingAnimation);
        }
        return item;
    }

    private static ItemsConfigJson.ItemConfigJson createHandItem(String id, String model, Integer customModelData) {
        ItemsConfigJson.ItemConfigJson item = new ItemsConfigJson.ItemConfigJson();
        item.setId(id);
        item.setType("hand");
        item.setModel(model);
        if (customModelData != null) {
            item.setCustomModelData(customModelData);
        }
        return item;
    }

    public static void saveConfig(@NonNull ItemsConfigJson config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(itemsConfigPath.toFile()), StandardCharsets.UTF_8));){
            GSON.toJson((Object)config, (Appendable)writer);
            LOGGER.info("Config saved to: {}", (Object)itemsConfigPath);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static Path getConfigPath() {
        return itemsConfigPath;
    }

    @Generated
    private ConfigManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

