/*
 * Decompiled with CFR 0.152.
 */
package com.zeydie.votiverpequipments.client;

import com.zeydie.equipmentlib.api.EquipmentLibAPI;
import com.zeydie.sgson.SGsonBase;
import com.zeydie.votiverpequipments.api.ModelPacketData;
import com.zeydie.votiverpequipments.common.items.armor.basic.animated.AnimatedEquipmentsArmorItem;
import com.zeydie.votiverpequipments.common.items.item.basic.animated.AnimatedEquipmentsItem;
import com.zeydie.votiverpequipments.common.registry.ItemRegistry;
import com.zeydie.votiverpequipments.common.scanner.ResourceScanner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class VotiveRPEquipmentsClient
implements ClientModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(VotiveRPEquipmentsClient.class);
    @NotNull
    private final class_2960 channel = new class_2960("votiverpequipments", "chat");

    public void onInitializeClient() {
        LOGGER.info("Initializing VotiveRP Equipments Client...");
        ResourceScanner.registerResourceListener();
        LOGGER.info("Resource scanner registered");
        ClientPlayNetworking.registerGlobalReceiver((class_2960)this.channel, (client, handler, buf, responseSender) -> this.handle((ModelPacketData)SGsonBase.create().fromJsonToObject(new String(buf.method_36132()), (Object)new ModelPacketData())));
    }

    public void handle(@NonNull ModelPacketData modelPacketData) {
        if (modelPacketData == null) {
            throw new NullPointerException("modelPacketData is marked non-null but is null");
        }
        Map renderingEquipments = EquipmentLibAPI.getInstance().getRenderingEquipmentsOfUUID();
        HashMap newModels = new HashMap();
        HashSet uuidsInPacket = new HashSet();
        modelPacketData.getModels().forEach(modelPacket -> {
            UUID uuid = modelPacket.getUuid();
            uuidsInPacket.add(uuid);
            class_1792 item = ItemRegistry.getItem(new class_2960(modelPacket.getMod(), modelPacket.getName()));
            if (item == null || modelPacket.getName().isEmpty()) {
                newModels.put(uuid, new ArrayList());
            } else if (item instanceof GeoItem) {
                @NonNull GeoItem geoItem = (GeoItem)item;
                newModels.computeIfAbsent(uuid, k -> new ArrayList()).add(geoItem);
                @NonNull List<String> animations = modelPacket.getAnimations();
                if (item instanceof AnimatedEquipmentsArmorItem) {
                    @NonNull AnimatedEquipmentsArmorItem animatedEquipmentsArmorItem = (AnimatedEquipmentsArmorItem)item;
                    @NotNull List<String> animationsItem = animatedEquipmentsArmorItem.getAnimations();
                    animations.forEach(anim -> {
                        if (!animationsItem.contains(anim)) {
                            animationsItem.add((String)anim);
                        }
                    });
                    @NonNull Map animationControllers = animatedEquipmentsArmorItem.getAnimationsControllers();
                    animationsItem.forEach(animation -> {
                        @NonNull AnimationController controller = (AnimationController)animationControllers.get(animation);
                        if (controller != null && controller.getAnimationState() != AnimationController.State.RUNNING) {
                            controller.setAnimation(RawAnimation.begin().thenPlay(animation));
                        }
                    });
                } else if (item instanceof AnimatedEquipmentsItem) {
                    @NonNull AnimatedEquipmentsItem animatedEquipmentsItem = (AnimatedEquipmentsItem)item;
                    @NotNull List<String> animationsItem = animatedEquipmentsItem.getAnimations();
                    animations.forEach(anim -> {
                        if (!animationsItem.contains(anim)) {
                            animationsItem.add((String)anim);
                        }
                    });
                    @NonNull Map animationControllers = animatedEquipmentsItem.getAnimationsControllers();
                    animationsItem.forEach(animation -> {
                        @NonNull AnimationController controller = (AnimationController)animationControllers.get(animation);
                        if (controller != null && controller.getAnimationState() != AnimationController.State.RUNNING) {
                            controller.setAnimation(RawAnimation.begin().thenPlay(animation));
                        }
                    });
                }
            }
        });
        uuidsInPacket.forEach(uuid -> renderingEquipments.put(uuid, (List)newModels.getOrDefault(uuid, new ArrayList())));
    }
}

