/*
 * Decompiled with CFR 0.152.
 */
package ignis.bubblechat.rpchat;

import com.google.common.collect.Maps;
import com.zeydie.sgson.SGsonBase;
import ignis.bubblechat.rpchat.packets.ChatPacket;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public final class RPChat {
    @NotNull
    private static final class_2960 channel = new class_2960("votivemods", "chat");
    @NotNull
    private static final Map<UUID, Boolean> chatsOpened = Maps.newHashMap();
    private static boolean isTyping = false;
    private static boolean wasTyping = false;
    private static long lastTextChangeTime = 0L;
    private static final long TYPING_TIMEOUT_MS = 2000L;

    public static void register() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)channel, (client, handler, buf, responseSender) -> {
            try {
                String jsonString = new String(buf.method_36132(), StandardCharsets.UTF_8);
                ChatPacket chatPacket = (ChatPacket)SGsonBase.create().fromJsonToObject(jsonString, (Object)new ChatPacket());
                RPChat.handle(chatPacket);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            class_746 player = client.field_1724;
            if (player != null) {
                long timeSinceLastChange;
                if (isTyping && lastTextChangeTime > 0L && (timeSinceLastChange = System.currentTimeMillis() - lastTextChangeTime) > 2000L) {
                    isTyping = false;
                }
                if (isTyping != wasTyping) {
                    wasTyping = isTyping;
                    RPChat.sendChatPacket(player.method_5667(), isTyping);
                }
            }
        });
    }

    public static void onTextChanged(boolean hasText) {
        isTyping = hasText;
        lastTextChangeTime = System.currentTimeMillis();
    }

    @Deprecated
    public static void updateTypingState(boolean hasText) {
    }

    private static void sendChatPacket(@NonNull UUID uuid, boolean isOpened) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        try {
            class_2540 packet = PacketByteBufs.create();
            String json = SGsonBase.create().fromObjectToJson((Object)new ChatPacket(uuid.toString(), isOpened));
            packet.method_10814(json);
            ClientPlayNetworking.send((class_2960)channel, (class_2540)packet);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static void handle(@NonNull ChatPacket packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        UUID uuid = UUID.fromString(packet.getUuid());
        boolean chat = packet.isChatOpened();
        System.out.println("[RPChat DEBUG] \u041f\u043e\u043b\u0443\u0447\u0435\u043d typing packet: UUID=" + String.valueOf(uuid) + ", chatOpened=" + chat);
        if (!chat) {
            chatsOpened.remove(uuid);
            System.out.println("[RPChat DEBUG] \u0423\u0431\u0440\u0430\u043d\u044b \u0442\u0440\u0438 \u0442\u043e\u0447\u043a\u0438 \u0434\u043b\u044f: " + String.valueOf(uuid));
        } else {
            chatsOpened.put(uuid, true);
            System.out.println("[RPChat DEBUG] \u041f\u043e\u043a\u0430\u0437\u0430\u043d\u044b \u0442\u0440\u0438 \u0442\u043e\u0447\u043a\u0438 \u0434\u043b\u044f: " + String.valueOf(uuid));
        }
    }

    @Generated
    @NotNull
    public static class_2960 getChannel() {
        return channel;
    }

    @Generated
    @NotNull
    public static Map<UUID, Boolean> getChatsOpened() {
        return chatsOpened;
    }
}

