/*
 * Decompiled with CFR 0.152.
 */
package ignis.bubblechat.renders;

import ignis.bubblechat.animations.AnimatedTextRendererV8;
import ignis.bubblechat.animations.AnimationTokens;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_898;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public final class BubbleChatRender {
    private static int f1Mode = 0;
    @NotNull
    private final List<String> messages;
    @NotNull
    private final class_898 dispatcher;
    @NotNull
    private final class_327 textRenderer;
    private boolean initiallyVisible = false;
    private boolean renderBlocked = false;
    private final int maxLines = 3;
    private long startTime;
    private static final int CHARS_PER_SECOND = 10;
    private static final long HOLD_TIME_MS = 6000L;
    private static final long GROUP_HOLD_TIME_MS = 6000L;
    private long lastRenderTime = 0L;

    public BubbleChatRender(@NonNull List<String> messages, @NonNull class_898 dispatcher, @NonNull class_327 textRenderer, @NonNull class_1297 entity) {
        boolean isVisible;
        if (dispatcher == null) {
            throw new NullPointerException("dispatcher is marked non-null but is null");
        }
        if (textRenderer == null) {
            throw new NullPointerException("textRenderer is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        if (dispatcher == null) {
            throw new NullPointerException("dispatcher is marked non-null but is null");
        }
        if (textRenderer == null) {
            throw new NullPointerException("textRenderer is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        this.messages = messages;
        this.dispatcher = dispatcher;
        this.textRenderer = textRenderer;
        this.startTime = System.currentTimeMillis();
        class_310 client = class_310.method_1551();
        this.initiallyVisible = isVisible = this.hasLineOfSight(client.field_1719, entity) && this.dispatcher.method_23168(entity) <= 4096.0;
        boolean bl = this.renderBlocked = !isVisible;
        if (!isVisible) {
            this.messages.clear();
        } else {
            if (this.messages.size() > 3) {
                for (int i = 0; i < this.messages.size(); ++i) {
                    if ((i + 1) % 3 != 0 || i + 1 >= this.messages.size()) continue;
                    String msg = this.messages.get(i);
                    this.messages.set(i, msg + "...");
                }
            }
            this.applyColorCarryOver();
        }
    }

    public void updateMessages(@NonNull List<String> newMessages, @NonNull class_1297 entity) {
        boolean isVisible;
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (newMessages == null) {
            throw new NullPointerException("newMessages is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        this.messages.clear();
        this.messages.addAll(newMessages);
        this.startTime = System.currentTimeMillis();
        class_310 client = class_310.method_1551();
        this.initiallyVisible = isVisible = this.hasLineOfSight(client.field_1719, entity) && this.dispatcher.method_23168(entity) <= 4096.0;
        boolean bl = this.renderBlocked = !isVisible;
        if (!isVisible) {
            this.messages.clear();
        } else {
            if (this.messages.size() > 3) {
                for (int i = 0; i < this.messages.size(); ++i) {
                    if ((i + 1) % 3 != 0 || i + 1 >= this.messages.size()) continue;
                    String msg = this.messages.get(i);
                    this.messages.set(i, msg + "...");
                }
            }
            this.applyColorCarryOver();
        }
    }

    public boolean isRendered() {
        return this.messages.isEmpty();
    }

    private AnimationState calculateAnimationState() {
        long elapsedMs = System.currentTimeMillis() - this.startTime;
        if (this.messages.isEmpty()) {
            return new AnimationState(true, 0, 0, false);
        }
        int linesToShow = Math.min(this.messages.size(), 3);
        int totalCharsInGroup = 0;
        for (int i = 0; i < linesToShow; ++i) {
            totalCharsInGroup += this.getSuffixLength(this.messages.get(i));
        }
        int msPerChar = 100;
        long animationTime = (long)totalCharsInGroup * (long)msPerChar;
        if (elapsedMs >= animationTime) {
            if (elapsedMs >= animationTime + 6000L) {
                if (this.messages.size() > 3) {
                    if (elapsedMs >= animationTime + 6000L + 6000L) {
                        return new AnimationState(false, linesToShow - 1, Integer.MAX_VALUE, true);
                    }
                    return new AnimationState(false, linesToShow - 1, Integer.MAX_VALUE, false);
                }
                return new AnimationState(true, 0, 0, false);
            }
            return new AnimationState(false, linesToShow - 1, Integer.MAX_VALUE, false);
        }
        int totalCharsToPrint = (int)(elapsedMs / (long)msPerChar);
        int currentLine = 0;
        int currentChar = totalCharsToPrint;
        for (int i = 0; i < linesToShow; ++i) {
            String msg = this.messages.get(i);
            int lineLength = this.getSuffixLength(msg);
            if (currentChar < lineLength) {
                currentLine = i;
                break;
            }
            if (currentChar == lineLength) {
                if (i + 1 < linesToShow) {
                    currentLine = i + 1;
                    currentChar = 0;
                    break;
                }
                currentLine = i;
                currentChar = lineLength;
                break;
            }
            currentChar -= lineLength;
        }
        return new AnimationState(false, currentLine, currentChar, false);
    }

    public void render(@NonNull class_1297 entity, @NonNull class_4587 matrices, @NonNull class_4597 vertexConsumers, int light) {
        if (matrices == null) {
            throw new NullPointerException("matrices is marked non-null but is null");
        }
        if (vertexConsumers == null) {
            throw new NullPointerException("vertexConsumers is marked non-null but is null");
        }
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (matrices == null) {
            throw new NullPointerException("matrices is marked non-null but is null");
        }
        if (vertexConsumers == null) {
            throw new NullPointerException("vertexConsumers is marked non-null but is null");
        }
        long currentTime = System.nanoTime();
        long timeSinceLastRender = currentTime - this.lastRenderTime;
        if (timeSinceLastRender < 500000L && this.lastRenderTime > 0L) {
            return;
        }
        this.lastRenderTime = currentTime;
        class_310 client = class_310.method_1551();
        if (!this.renderBlocked) {
            boolean isVisible;
            boolean bl = isVisible = this.hasLineOfSight(client.field_1719, entity) && this.dispatcher.method_23168(entity) <= 4096.0;
            if (!isVisible) {
                this.messages.clear();
            } else {
                AnimationState state = this.calculateAnimationState();
                if (state.shouldRemoveGroup) {
                    ArrayList<String> remaining = new ArrayList<String>();
                    for (int i = 3; i < this.messages.size(); ++i) {
                        remaining.add(this.messages.get(i));
                    }
                    this.messages.clear();
                    this.messages.addAll(remaining);
                    this.startTime = System.currentTimeMillis();
                    this.applyColorCarryOver();
                    state = this.calculateAnimationState();
                }
                if (state.shouldClear) {
                    this.messages.clear();
                    return;
                }
                if (!(f1Mode == 1 || client.field_1690.field_1842 && client.method_1569())) {
                    if (!this.isRendered()) {
                        int linesToShow = Math.min(state.currentLine + 1, this.messages.size());
                        boolean stand = !entity.method_21751();
                        double msgOffset = 0.25;
                        double headOffsetY = 2.3;
                        float modelScale = 1.0f;
                        try {
                            Class<?> apiClass = Class.forName("com.votive.geckomythicclient.api.GeckoModelAPI");
                            Boolean hasModel = (Boolean)apiClass.getMethod("hasModel", class_1657.class).invoke(null, entity);
                            if (hasModel != null && hasModel.booleanValue()) {
                                Float scale;
                                class_243 headOffset = (class_243)apiClass.getMethod("getHeadOffset", class_1657.class).invoke(null, entity);
                                if (headOffset != null) {
                                    headOffsetY = headOffset.field_1351;
                                }
                                if ((scale = (Float)apiClass.getMethod("getModelScale", class_1657.class).invoke(null, entity)) != null) {
                                    modelScale = scale.floatValue();
                                }
                            }
                        }
                        catch (Exception apiClass) {
                            // empty catch block
                        }
                        double offset = headOffsetY - 0.25 + (double)linesToShow * msgOffset;
                        for (int i = 0; i < linesToShow; ++i) {
                            String fullLine = this.messages.get(i);
                            matrices.method_22903();
                            matrices.method_22904(0.0, offset - (double)i * msgOffset, 0.0);
                            matrices.method_22907(this.dispatcher.method_24197());
                            float textScale = -0.025f * modelScale;
                            matrices.method_22905(textScale, textScale, 0.025f);
                            if (i < state.currentLine) {
                                class_5250 text = class_2561.method_43470((String)fullLine);
                                this.drawText((class_2561)text, matrices, vertexConsumers, stand, light);
                            } else if (i == state.currentLine) {
                                int colonPos = fullLine.indexOf(58);
                                if (colonPos >= 0) {
                                    class_5250 text = this.getTextWithAnimation(fullLine, colonPos, state.currentChar);
                                    this.drawText((class_2561)text, matrices, vertexConsumers, stand, light);
                                } else {
                                    int typedLen = Math.min(state.currentChar, fullLine.length());
                                    boolean notComplete = typedLen < fullLine.length();
                                    String typedPart = fullLine.substring(0, typedLen) + (notComplete ? "|" : "");
                                    class_5250 text = class_2561.method_43470((String)typedPart);
                                    this.drawText((class_2561)text, matrices, vertexConsumers, stand, light);
                                }
                            }
                            matrices.method_22909();
                        }
                    }
                } else {
                    this.messages.clear();
                }
            }
        }
    }

    @NotNull
    private class_5250 getTextWithAnimation(String fullLine, int colonPos, int currentChar) {
        String prefix = fullLine.substring(0, colonPos + 1);
        String suffix = colonPos + 1 < fullLine.length() ? fullLine.substring(colonPos + 1) : "";
        int typedLen = currentChar;
        if (typedLen < 0) {
            typedLen = 0;
        }
        if (typedLen > suffix.length()) {
            typedLen = suffix.length();
        }
        String typedSub = suffix.substring(0, typedLen);
        boolean notComplete = typedLen < suffix.length();
        String lineToRender = prefix + typedSub + (notComplete ? "|" : "");
        return class_2561.method_43470((String)lineToRender);
    }

    public static void toggleF1Mode() {
        class_310 client = class_310.method_1551();
        f1Mode = (f1Mode + 1) % 3;
        if (client.field_1724 != null) {
            switch (f1Mode) {
                case 0: {
                    client.field_1690.field_1842 = false;
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a77\u0422\u0435\u043a\u0441\u0442 \u043d\u0430\u0434 \u0433\u043e\u043b\u043e\u0432\u043e\u0439:\u00a7a \u0432\u043a\u043b\u044e\u0447\u0435\u043d"), true);
                    break;
                }
                case 1: {
                    client.field_1690.field_1842 = false;
                    client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"\u00a77\u0422\u0435\u043a\u0441\u0442 \u043d\u0430\u0434 \u0433\u043e\u043b\u043e\u0432\u043e\u0439:\u00a7c \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d"), true);
                    break;
                }
                case 2: {
                    client.field_1690.field_1842 = true;
                }
            }
        }
    }

    private int getSuffixLength(@NonNull String fullLine) {
        if (fullLine == null) {
            throw new NullPointerException("fullLine is marked non-null but is null");
        }
        int colonPos = fullLine.indexOf(58);
        if (colonPos >= 0) {
            int suffixLen = fullLine.length() - (colonPos + 1);
            return Math.max(0, suffixLen);
        }
        return fullLine.length();
    }

    private boolean hasLineOfSight(@Nullable class_1297 viewer, @NonNull class_1297 target) {
        class_243 endPos;
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (viewer == null) {
            return true;
        }
        if (viewer == target) {
            return true;
        }
        class_243 startPos = viewer.method_5836(1.0f);
        class_3959 context = new class_3959(startPos, endPos = new class_243(target.method_23317(), target.method_23323(0.5), target.method_23321()), class_3959.class_3960.field_23142, class_3959.class_242.field_1348, viewer);
        class_3965 result = viewer.field_6002.method_17742(context);
        return result.method_17783() == class_239.class_240.field_1333;
    }

    private void drawText(@NonNull class_2561 text, @NonNull class_4587 matrices, @NonNull class_4597 vertexConsumers, boolean stand, int light) {
        if (matrices == null) {
            throw new NullPointerException("matrices is marked non-null but is null");
        }
        if (vertexConsumers == null) {
            throw new NullPointerException("vertexConsumers is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (matrices == null) {
            throw new NullPointerException("matrices is marked non-null but is null");
        }
        if (vertexConsumers == null) {
            throw new NullPointerException("vertexConsumers is marked non-null but is null");
        }
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        float opacity = class_310.method_1551().field_1690.method_19343(0.25f);
        int backgroundColor = (int)(opacity * 255.0f) << 24;
        String textString = text.getString();
        int x = -this.textRenderer.method_27525((class_5348)text) / 2;
        if (AnimationTokens.shouldAnimate(textString)) {
            int textWidth = this.textRenderer.method_27525((class_5348)text);
            String spaces = " ".repeat(Math.max(1, textWidth / this.textRenderer.method_1727(" ")));
            this.textRenderer.method_27521(spaces, (float)x, 0.0f, 0, false, matrix4f, vertexConsumers, false, backgroundColor, light);
            AnimatedTextRendererV8.drawAnimated(this.textRenderer, matrix4f, vertexConsumers, stand, light, textString, x, 0.0f, 0x20FFFFFF, false, 0);
        } else {
            this.textRenderer.method_30882(text, (float)x, 0.0f, 0x20FFFFFF, false, matrix4f, vertexConsumers, stand, backgroundColor, light);
            if (stand) {
                this.textRenderer.method_30882(text, (float)x, 0.0f, -1, false, matrix4f, vertexConsumers, false, 0, light);
            }
        }
    }

    private void applyColorCarryOver() {
        if (!this.messages.isEmpty()) {
            String first = this.messages.get(0);
            String lastColor = this.getLastColor(first);
            for (int i = 1; i < this.messages.size(); ++i) {
                String newLast;
                Object line = this.messages.get(i);
                if (this.getStartingColor((String)line) == null && lastColor != null) {
                    line = lastColor + (String)line;
                }
                if ((newLast = this.getLastColor((String)line)) != null) {
                    lastColor = newLast;
                }
                this.messages.set(i, (String)line);
            }
        }
    }

    @Nullable
    private String getLastColor(@NonNull String str) {
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        if (str.length() < 2) {
            return null;
        }
        String last = null;
        for (int i = 0; i < str.length() - 1; ++i) {
            char c;
            char prefix = str.charAt(i);
            if (prefix != '\u00a7' && prefix != '&' || !((c = Character.toLowerCase(str.charAt(i + 1))) >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'k' && c <= 'o' || c == 'r' || c == 'j' || c == 'h' || c == 'p' || c == 'w' || c == 'g' || c == 'z') && c != 'v') continue;
            last = "\u00a7" + c;
            ++i;
        }
        return last;
    }

    @Nullable
    private String getStartingColor(@NonNull String str) {
        char c;
        char prefix;
        if (str == null) {
            throw new NullPointerException("str is marked non-null but is null");
        }
        char c2 = prefix = str.length() >= 2 ? str.charAt(0) : (char)'\u0000';
        if ((prefix == '\u00a7' || prefix == '&') && ((c = Character.toLowerCase(str.charAt(1))) >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'k' && c <= 'o' || c == 'r' || c == 'j' || c == 'h' || c == 'p' || c == 'w' || c == 'g' || c == 'z' || c == 'v')) {
            return str.substring(0, 2);
        }
        return null;
    }

    private static class AnimationState {
        final boolean shouldClear;
        final int currentLine;
        final int currentChar;
        final boolean shouldRemoveGroup;

        AnimationState(boolean shouldClear, int currentLine, int currentChar, boolean shouldRemoveGroup) {
            this.shouldClear = shouldClear;
            this.currentLine = currentLine;
            this.currentChar = currentChar;
            this.shouldRemoveGroup = shouldRemoveGroup;
        }
    }
}

